/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest;

import java.lang.reflect.Method;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.info.ProductInformations;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/platform")
public class PlatformInformationRESTService
implements ResourceContainer {
    private Log logger = ExoLogger.getLogger(this.getClass());
    private ProductInformations platformInformations;

    public PlatformInformationRESTService(ProductInformations productInformations) {
        this.platformInformations = productInformations;
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public Response getPlatformInformation() {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        try {
            JsonPlatformInfo jsonPlatformInfo = new JsonPlatformInfo();
            jsonPlatformInfo.setPlatformVersion(this.platformInformations.getVersion());
            jsonPlatformInfo.setPlatformBuildNumber(this.platformInformations.getBuildNumber());
            jsonPlatformInfo.setPlatformRevision(this.platformInformations.getRevision());
            jsonPlatformInfo.setIsMobileCompliant(this.isMobileCompliant().toString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Getting Platform Informations: eXo Platform (v" + this.platformInformations.getVersion() + " - build " + this.platformInformations.getBuildNumber() + " - rev. " + this.platformInformations.getRevision()));
            }
            return Response.ok((Object)jsonPlatformInfo, (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occured while getting platform version information.", (Throwable)e);
            return Response.status((int)500).cacheControl(cacheControl).build();
        }
    }

    private Boolean isMobileCompliant() {
        String platformEdition = this.getPlatformEdition();
        return platformEdition != null && platformEdition.equals("enterprise");
    }

    private String getPlatformEdition() {
        try {
            Class<?> c = Class.forName("org.exoplatform.platform.edition.PlatformEdition");
            Method getEditionMethod = c.getMethod("getEdition", new Class[0]);
            String platformEdition = (String)getEditionMethod.invoke(null, new Object[0]);
            return platformEdition;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occured while getting the platform edition information.", (Throwable)e);
            return null;
        }
    }

    public static class JsonPlatformInfo {
        private String platformVersion;
        private String platformBuildNumber;
        private String platformRevision;
        private String isMobileCompliant;

        public String getPlatformVersion() {
            return this.platformVersion;
        }

        public void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public String getIsMobileCompliant() {
            return this.isMobileCompliant;
        }

        public void setIsMobileCompliant(String isMobileCompliant) {
            this.isMobileCompliant = isMobileCompliant;
        }

        public String getPlatformBuildNumber() {
            return this.platformBuildNumber;
        }

        public void setPlatformBuildNumber(String platformBuildNumber) {
            this.platformBuildNumber = platformBuildNumber;
        }

        public String getPlatformRevision() {
            return this.platformRevision;
        }

        public void setPlatformRevision(String platformRevision) {
            this.platformRevision = platformRevision;
        }
    }
}

