/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Payload;
import org.exoplatform.services.jcr.impl.core.query.lucene.PropertyMetaData;

public final class SingletonTokenStream
extends TokenStream
implements Serializable {
    private String value;
    private Payload payload;

    public SingletonTokenStream() {
    }

    public SingletonTokenStream(String value, int type) {
        this.value = value;
        this.payload = new Payload(new PropertyMetaData(type).toByteArray());
    }

    public SingletonTokenStream(Token t) {
        this.value = t.term();
        this.payload = t.getPayload();
    }

    public Token next(Token reusableToken) throws IOException {
        if (this.value == null) {
            return null;
        }
        reusableToken.clear();
        reusableToken.setTermBuffer(this.value);
        reusableToken.setPayload(this.payload);
        reusableToken.setStartOffset(0);
        reusableToken.setEndOffset(this.value.length());
        this.value = null;
        return reusableToken;
    }
}

