/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.SecurityManager;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.ActivityRestListOut;

@Path(value="api/social/v1-alpha2/{portalContainerName}/activity_stream/")
public class ActivityStreamResources
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger((String)ActivityStreamResources.class.getName());
    private static final String[] SUPPORTED_FORMATS = new String[]{"json"};
    private static final int MAX_LIMIT = 100;

    @GET
    @Path(value="{identityId}.{format}")
    public Response getActivityStreamByIdentityId(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="identityId") String identityId, @PathParam(value="format") String format, @QueryParam(value="limit") int limit, @QueryParam(value="since_id") String sinceId, @QueryParam(value="max_id") String maxId, @QueryParam(value="number_of_comments") int numberOfComments, @QueryParam(value="number_of_likes") int numberOfLikes) {
        RestChecker.checkAuthenticatedRequest();
        PortalContainer portalContainer = RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMATS);
        Identity targetIdentity = "me".equals(identityId) ? Util.getAuthenticatedUserIdentity(portalContainerName) : Util.getIdentityManager(portalContainerName).getIdentity(identityId, false);
        if (targetIdentity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        boolean canAccess = SecurityManager.canAccessActivityStream(portalContainer, Util.getAuthenticatedUserIdentity(portalContainerName), targetIdentity);
        if (!canAccess) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        int maxLimit = limit <= 0 ? 100 : Math.min(limit, 100);
        ExoSocialActivity baseActivity = null;
        boolean getOlder = false;
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        try {
            if (sinceId != null) {
                baseActivity = activityManager.getActivity(sinceId);
            } else if (maxId != null) {
                getOlder = true;
                baseActivity = activityManager.getActivity(maxId);
            }
        }
        catch (UndeclaredThrowableException udte) {
            if (udte.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        RealtimeListAccess rala = activityManager.getActivitiesWithListAccess(targetIdentity);
        List activityList = getOlder ? rala.loadOlder((Object)baseActivity, maxLimit) : (sinceId != null ? rala.loadNewer((Object)baseActivity, maxLimit) : rala.loadAsList(0, maxLimit));
        ActivityRestListOut arlo = new ActivityRestListOut(activityList, numberOfComments, numberOfLikes, portalContainerName);
        return Util.getResponse(arlo, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="feed.{format}")
    public Response getActivityFeedOfAuthenticated(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="format") String format, @QueryParam(value="limit") int limit, @QueryParam(value="since_id") String sinceId, @QueryParam(value="max_id") String maxId, @QueryParam(value="number_of_comments") int numberOfComments, @QueryParam(value="number_of_likes") int numberOfLikes) {
        RestChecker.checkAuthenticatedRequest();
        RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMATS);
        Identity sourceIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        int maxLimit = limit <= 0 ? 100 : Math.min(limit, 100);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        ExoSocialActivity newerActivity = null;
        ExoSocialActivity olderActivity = null;
        try {
            if (sinceId != null && !sinceId.trim().equals("")) {
                newerActivity = activityManager.getActivity(sinceId);
            } else if (maxId != null && !maxId.trim().equals("")) {
                olderActivity = activityManager.getActivity(maxId);
            }
        }
        catch (UndeclaredThrowableException e) {
            if (e.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        RealtimeListAccess listAccess = null;
        List activities = null;
        try {
            listAccess = activityManager.getActivityFeedWithListAccess(sourceIdentity);
            activities = newerActivity != null ? listAccess.loadNewer((Object)newerActivity, maxLimit) : (olderActivity != null ? listAccess.loadOlder((Object)olderActivity, maxLimit) : listAccess.loadAsList(0, maxLimit));
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        ActivityRestListOut activityRestListOut = new ActivityRestListOut(activities, numberOfComments, numberOfLikes, portalContainerName);
        return Util.getResponse(activityRestListOut, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="spaces.{format}")
    public Response getActivitySpacesOfAuthenticated(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="format") String format, @QueryParam(value="limit") int limit, @QueryParam(value="since_id") String sinceId, @QueryParam(value="max_id") String maxId, @QueryParam(value="number_of_comments") int numberOfComments, @QueryParam(value="number_of_likes") int numberOfLikes) {
        RestChecker.checkAuthenticatedRequest();
        RestChecker.checkValidPortalContainerName(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMATS);
        Identity targetIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        int maxLimit = limit == 0 ? 100 : limit;
        ExoSocialActivity baseActivity = null;
        boolean getOlder = false;
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        try {
            if (sinceId != null) {
                baseActivity = activityManager.getActivity(sinceId);
            } else if (maxId != null) {
                getOlder = true;
                baseActivity = activityManager.getActivity(maxId);
            }
        }
        catch (UndeclaredThrowableException udte) {
            if (udte.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        RealtimeListAccess rala = activityManager.getActivitiesOfUserSpacesWithListAccess(targetIdentity);
        List activityList = getOlder ? rala.loadOlder((Object)baseActivity, maxLimit) : (sinceId != null ? rala.loadNewer((Object)baseActivity, maxLimit) : rala.loadAsList(0, maxLimit));
        ActivityRestListOut arlo = new ActivityRestListOut(activityList, numberOfComments, numberOfLikes, portalContainerName);
        return Util.getResponse(arlo, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="connections.{format}")
    public Response getActivityConnectionsOfAuthenticated(@Context UriInfo uriInfo, @PathParam(value="portalContainerName") String portalContainerName, @PathParam(value="format") String format, @QueryParam(value="limit") int limit, @QueryParam(value="since_id") String sinceId, @QueryParam(value="max_id") String maxId, @QueryParam(value="number_of_comments") int numberOfComments, @QueryParam(value="number_of_likes") int numberOfLikes) {
        int maxLimit;
        RestChecker.checkAuthenticatedRequest();
        RestChecker.checkValidPortalContainerName(portalContainerName);
        ActivityManager activityManager = Util.getActivityManager(portalContainerName);
        MediaType mediaType = RestChecker.checkSupportedFormat(format, SUPPORTED_FORMATS);
        Identity targetIdentity = Util.getAuthenticatedUserIdentity(portalContainerName);
        ExoSocialActivity baseActivity = null;
        boolean getOlder = false;
        try {
            if (sinceId != null) {
                baseActivity = activityManager.getActivity(sinceId);
            } else if (maxId != null) {
                getOlder = true;
                baseActivity = activityManager.getActivity(maxId);
            }
        }
        catch (UndeclaredThrowableException udte) {
            if (udte.getCause() instanceof ActivityStorageException) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        RealtimeListAccess realtimeListAccess = null;
        realtimeListAccess = activityManager.getActivitiesOfConnectionsWithListAccess(targetIdentity);
        int n = maxLimit = limit <= 0 ? 100 : Math.min(limit, 100);
        List activityList = getOlder ? realtimeListAccess.loadOlder((Object)baseActivity, maxLimit) : (sinceId != null ? realtimeListAccess.loadNewer((Object)baseActivity, maxLimit) : realtimeListAccess.loadAsList(0, maxLimit));
        ActivityRestListOut activityRestListOut = new ActivityRestListOut(activityList, numberOfComments, numberOfLikes, portalContainerName);
        return Util.getResponse(activityRestListOut, uriInfo, mediaType, Response.Status.OK);
    }
}

