/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.SecurityUtils;
import org.jsecurity.session.Session;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.StringUtils;
import org.jsecurity.util.ThreadContext;
import org.jsecurity.web.RedirectView;
import org.jsecurity.web.SavedRequest;

public class WebUtils {
    private static final Log log = LogFactory.getLog(WebUtils.class);
    private static final String NOT_BOUND_ERROR_MESSAGE = "Make sure WebUtils.bind() is being called. (typically called by JSecurityFilter)  This could also happen when running integration tests that don't properly call WebUtils.bind().";
    public static final String SERVLET_REQUEST_KEY = ServletRequest.class.getName() + "_JSECURITY_THREAD_CONTEXT_KEY";
    public static final String SERVLET_RESPONSE_KEY = ServletResponse.class.getName() + "_JSECURITY_THREAD_CONTEXT_KEY";
    public static final String SAVED_REQUEST_KEY = "jsecuritySavedRequest";
    public static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING_ATTRIBUTE = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";

    public static String getPathWithinApplication(HttpServletRequest request) {
        String contextPath = WebUtils.getContextPath(request);
        String requestUri = WebUtils.getRequestUri(request);
        if (StringUtils.startsWithIgnoreCase(requestUri, contextPath)) {
            String path = requestUri.substring(contextPath.length());
            return StringUtils.hasText(path) ? path : "/";
        }
        return requestUri;
    }

    public static String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE);
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return WebUtils.decodeAndCleanUriString(request, uri);
    }

    private static String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        int semicolonIndex = (uri = WebUtils.decodeRequestString(request, uri)).indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return WebUtils.decodeRequestString(request, contextPath);
    }

    public static String decodeRequestString(HttpServletRequest request, String source) {
        String enc = WebUtils.determineEncoding(request);
        try {
            return URLDecoder.decode(source, enc);
        }
        catch (UnsupportedEncodingException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not decode request string [" + source + "] with encoding '" + enc + "': falling back to platform default encoding; exception message: " + ex.getMessage()));
            }
            return URLDecoder.decode(source);
        }
    }

    protected static String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        return enc;
    }

    public static InetAddress getInetAddress(ServletRequest request) {
        InetAddress clientAddress;
        block2: {
            clientAddress = null;
            String addrString = request.getRemoteHost();
            try {
                clientAddress = InetAddress.getByName(addrString);
            }
            catch (UnknownHostException e) {
                if (!log.isInfoEnabled()) break block2;
                log.info((Object)"Unable to acquire InetAddress from ServletRequest", (Throwable)e);
            }
        }
        return clientAddress;
    }

    public static HttpServletRequest toHttp(ServletRequest request) {
        return (HttpServletRequest)request;
    }

    public static HttpServletResponse toHttp(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    public static void bindInetAddressToThread(ServletRequest request) {
        InetAddress ip = WebUtils.getInetAddress(request);
        if (ip != null) {
            ThreadContext.bind(ip);
        }
    }

    public static void unbindInetAddressFromThread() {
        ThreadContext.unbindInetAddress();
    }

    public static ServletRequest getRequiredServletRequest() throws IllegalStateException {
        ServletRequest request = (ServletRequest)ThreadContext.get(SERVLET_REQUEST_KEY);
        if (request == null) {
            throw new IllegalStateException("No ServletRequest found in ThreadContext. Make sure WebUtils.bind() is being called. (typically called by JSecurityFilter)  This could also happen when running integration tests that don't properly call WebUtils.bind().");
        }
        return request;
    }

    public static void bind(ServletRequest servletRequest) {
        if (servletRequest != null) {
            ThreadContext.put(SERVLET_REQUEST_KEY, servletRequest);
        }
    }

    public static ServletRequest unbindServletRequest() {
        return (ServletRequest)ThreadContext.remove(SERVLET_REQUEST_KEY);
    }

    public static ServletResponse getRequiredServletResponse() throws IllegalStateException {
        ServletResponse response = (ServletResponse)ThreadContext.get(SERVLET_RESPONSE_KEY);
        if (response == null) {
            throw new IllegalStateException("No ServletResponse found in ThreadContext. Make sure WebUtils.bind() is being called. (typically called by JSecurityFilter)  This could also happen when running integration tests that don't properly call WebUtils.bind().");
        }
        return response;
    }

    public static void bind(ServletResponse servletResponse) {
        if (servletResponse != null) {
            ThreadContext.put(SERVLET_RESPONSE_KEY, servletResponse);
        }
    }

    public static ServletResponse unbindServletResponse() {
        return (ServletResponse)ThreadContext.remove(SERVLET_RESPONSE_KEY);
    }

    public static void issueRedirect(ServletRequest request, ServletResponse response, String url, Map queryParams, boolean contextRelative, boolean http10Compatible) throws IOException {
        RedirectView view = new RedirectView(url, contextRelative, http10Compatible);
        view.renderMergedOutputModel(queryParams, WebUtils.toHttp(request), WebUtils.toHttp(response));
    }

    public static void issueRedirect(ServletRequest request, ServletResponse response, String url) throws IOException {
        WebUtils.issueRedirect(request, response, url, null, true, true);
    }

    public static void issueRedirect(ServletRequest request, ServletResponse response, String url, Map queryParams) throws IOException {
        WebUtils.issueRedirect(request, response, url, queryParams, true, true);
    }

    public static void issueRedirect(ServletRequest request, ServletResponse response, String url, Map queryParams, boolean contextRelative) throws IOException {
        WebUtils.issueRedirect(request, response, url, queryParams, contextRelative, true);
    }

    public static boolean isTrue(ServletRequest request, String paramName) {
        String value = WebUtils.getCleanParam(request, paramName);
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("enabled") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static String getCleanParam(ServletRequest request, String paramName) {
        return StringUtils.clean(request.getParameter(paramName));
    }

    public static void saveRequest(ServletRequest request) {
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession();
        HttpServletRequest httpRequest = WebUtils.toHttp(request);
        SavedRequest savedRequest = new SavedRequest(httpRequest);
        session.setAttribute(SAVED_REQUEST_KEY, savedRequest);
    }

    public static SavedRequest getAndClearSavedRequest(ServletRequest request) {
        SavedRequest savedRequest = WebUtils.getSavedRequest(request);
        if (savedRequest != null) {
            Subject subject = SecurityUtils.getSubject();
            Session session = subject.getSession();
            session.removeAttribute(SAVED_REQUEST_KEY);
        }
        return savedRequest;
    }

    public static SavedRequest getSavedRequest(ServletRequest request) {
        SavedRequest savedRequest = null;
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession(false);
        if (session != null) {
            savedRequest = (SavedRequest)session.getAttribute(SAVED_REQUEST_KEY);
        }
        return savedRequest;
    }
}

