/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.HashMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AnswersSpaceActivityPublisher
extends AnswerEventListener {
    public static final String SPACE_APP_ID = "ks-answer:spaces";
    public static final String QUESTION_ID_KEY = "QuestionId";
    public static final String ANSWER_ID_KEY = "AnswerId";
    public static final String COMMENT_ID_KEY = "CommentId";
    public static final String ACTIVITY_TYPE_KEY = "ActivityType";
    public static final String AUTHOR_KEY = "Author";
    public static final String LINK_KEY = "Link";
    public static final String QUESTION_NAME_KEY = "Name";
    public static final String LANGUAGE_KEY = "Language";
    public static final String ANSWER = "Answer";
    public static final String QUESTION = "Question";
    public static final String COMMENT = "Comment";
    public static final String ANSWER_ADD = "AnswerAdd";
    public static final String QUESTION_ADD = "QuestionAdd";
    public static final String COMMENT_ADD = "CommentAdd";
    public static final String ANSWER_UPDATE = "AnswerUpdate";
    public static final String QUESTION_UPDATE = "QuestionUpdate";
    public static final String COMMENT_UPDATE = "CommentUpdate";
    private static Log LOG = ExoLogger.getExoLogger(AnswerEventListener.class);

    public void saveAnswer(String questionId, Answer answer, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            if (!(q.isActivated() && q.isApproved() && answer.getApprovedAnswers() && answer.getActivateAnswers())) {
                return;
            }
            String msg = "@" + answer.getResponseBy();
            String body = answer.getResponses();
            String spaceId = catId.split(Utils.CATE_SPACE_ID_PREFIX)[1];
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            SpaceService spaceService = (SpaceService)exoContainer.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            Identity spaceIdentity = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", answer.getResponseBy(), false);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setUserId(userIdentity.getId());
            activity.setTitle(msg);
            activity.setBody(body);
            activity.setType(SPACE_APP_ID);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(QUESTION_ID_KEY, questionId);
            params.put(ACTIVITY_TYPE_KEY, isNew ? ANSWER_ADD : ANSWER_UPDATE);
            params.put(ANSWER_ID_KEY, answer.getId());
            params.put(AUTHOR_KEY, answer.getResponseBy());
            params.put(QUESTION_NAME_KEY, q.getQuestion());
            params.put(LINK_KEY, q.getLink());
            params.put(LANGUAGE_KEY, q.getLanguage());
            activity.setTemplateParams(params);
            activityM.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }

    public void saveComment(String questionId, Comment comment, boolean isNew) {
    }

    public void saveQuestion(Question question, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            String catId = question.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            if (!question.isActivated() || !question.isApproved()) {
                return;
            }
            String msg = "@" + question.getAuthor();
            String body = question.getDetail();
            String spaceId = catId.split(Utils.CATE_SPACE_ID_PREFIX)[1];
            if (spaceId.indexOf("/") > 0) {
                spaceId = spaceId.substring(0, spaceId.indexOf("/"));
            }
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            SpaceService spaceService = (SpaceService)exoContainer.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            Identity spaceIdentity = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", question.getAuthor(), false);
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setUserId(userIdentity.getId());
            activity.setTitle(msg);
            activity.setBody(body);
            activity.setType(SPACE_APP_ID);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(QUESTION_ID_KEY, question.getId());
            params.put(ACTIVITY_TYPE_KEY, isNew ? QUESTION_ADD : QUESTION_UPDATE);
            params.put(QUESTION_NAME_KEY, question.getQuestion());
            params.put(LINK_KEY, question.getLink());
            params.put(LANGUAGE_KEY, question.getLanguage());
            activity.setTemplateParams(params);
            activityM.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Please check the integrated project does the social deploy? ", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when add new questin ", (Throwable)e);
        }
    }

    public void saveAnswer(String questionId, Answer[] answers, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            FAQService faqS = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            Question q = faqS.getQuestionById(questionId);
            String catId = q.getCategoryId();
            if (catId == null || catId.indexOf(Utils.CATE_SPACE_ID_PREFIX) < 0) {
                return;
            }
            if (answers != null) {
                for (Answer a : answers) {
                    this.saveAnswer(questionId, a, isNew);
                }
            }
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }
}

