/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.commons.chromattic.SynchronizationListener;
import org.exoplatform.commons.chromattic.SynchronizationStatus;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.lifecycle.LifeCycleCompletionService;
import org.exoplatform.social.common.lifecycle.LifeCycleEvent;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLifeCycle<T extends LifeCycleListener<E>, E extends LifeCycleEvent<?, ?>> {
    private static final Log LOG = ExoLogger.getLogger(AbstractLifeCycle.class);
    protected Set<T> listeners = new HashSet<T>();
    protected final PortalContainer container = PortalContainer.getInstance();
    protected LifeCycleCompletionService completionService = (LifeCycleCompletionService)this.container.getComponentInstanceOfType(LifeCycleCompletionService.class);
    protected ChromatticManager manager = (ChromatticManager)this.container.getComponentInstanceOfType(ChromatticManager.class);
    protected ChromatticLifeCycle lifeCycle;

    protected AbstractLifeCycle() {
        if (this.manager != null) {
            this.lifeCycle = this.manager.getLifeCycle("soc");
        }
    }

    public void addListener(T listener) {
        this.listeners.add(listener);
    }

    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    protected void broadcast(E event) {
        SessionContext ctx = this.lifeCycle.getContext();
        ctx.addSynchronizationListener(new SynchronizationListener((LifeCycleEvent)event){
            final /* synthetic */ LifeCycleEvent val$event;
            {
                this.val$event = lifeCycleEvent;
            }

            public void beforeSynchronization() {
            }

            public void afterSynchronization(SynchronizationStatus status) {
                if (status == SynchronizationStatus.SAVED) {
                    AbstractLifeCycle.this.addTasks(this.val$event);
                }
            }
        });
    }

    protected void addTasks(E event) {
        for (final LifeCycleListener listener : this.listeners) {
            this.completionService.addTask(new Callable<E>((LifeCycleEvent)event){
                final /* synthetic */ LifeCycleEvent val$event;
                {
                    this.val$event = lifeCycleEvent;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public E call() throws Exception {
                    try {
                        AbstractLifeCycle.this.begin();
                        AbstractLifeCycle.this.dispatchEvent(listener, this.val$event);
                    }
                    catch (Exception e) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        AbstractLifeCycle.this.end();
                    }
                    return this.val$event;
                }
            });
        }
    }

    protected void begin() {
        this.manager.beginRequest();
        this.lifeCycle.getChromattic().openSession();
    }

    protected void end() {
        this.manager.endRequest(true);
    }

    protected abstract void dispatchEvent(T var1, E var2);
}

