/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.definition.PortalContainerConfig;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.quartz.JobExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMCoreUtils {
    private static Log log = ExoLogger.getLogger((String)"wcm.WCMCoreUtils");
    private static String WEBCONTENT_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' and jcr:mixinTypes <> 'exo:restoreLocation' order by exo:priority ASC";

    public static <T> T getService(Class<T> clazz) {
        return WCMCoreUtils.getService(clazz, null);
    }

    public static SessionProvider getSystemSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        return sessionProvider;
    }

    public static SessionProvider getUserSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        return sessionProvider;
    }

    public static boolean isAnonim() {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        return userId == null;
    }

    public static SessionProvider createAnonimProvider() {
        return SessionProvider.createAnonimProvider();
    }

    public static <T> T getService(Class<T> clazz, String containerName) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (containerName != null) {
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        if (container.getComponentInstanceOfType(clazz) == null) {
            containerName = PortalContainer.getCurrentPortalContainerName();
            container = RootContainer.getInstance().getPortalContainer(containerName);
        }
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static String getContainerNameFromJobContext(JobExecutionContext context) {
        return context.getJobDetail().getGroup().split(":")[0];
    }

    public static boolean hasPermission(String userId, List<String> permissions, boolean isNeedFullAccess) {
        try {
            OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
            WCMCoreUtils.startRequest(organizationService);
            Collection memberships = null;
            Membership userMembership2 = null;
            String userMembershipTmp = null;
            int count = 0;
            String permissionTmp = "";
            for (String permission : permissions) {
                if (!permissionTmp.equals(permission)) {
                    count = 0;
                }
                memberships = organizationService.getMembershipHandler().findMembershipsByUser(userId);
                for (Membership userMembership2 : memberships) {
                    if (permission.equals(userMembership2.getUserName())) {
                        return true;
                    }
                    if ("any".equals(permission)) {
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    if (permission.startsWith("*") && permission.contains(userMembership2.getGroupId())) {
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    userMembershipTmp = userMembership2.getMembershipType() + ":" + userMembership2.getGroupId();
                    if (!permission.equals(userMembershipTmp)) continue;
                    if (isNeedFullAccess) {
                        if (++count != 4) continue;
                        return true;
                    }
                    return true;
                }
                permissionTmp = permission;
            }
            WCMCoreUtils.endRequest(organizationService);
        }
        catch (Exception e) {
            log.error((Object)"hasPermission() failed because of ", (Throwable)e);
        }
        return false;
    }

    public static <T> List<T> getAllElementsOfListAccess(ListAccess<T> listAccess) {
        try {
            return Arrays.asList(listAccess.load(0, listAccess.getSize()));
        }
        catch (Exception e) {
            log.error((Object)"getAllElementsOfListAccess() failed because of ", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static ManageableRepository getRepository(String repository) {
        return WCMCoreUtils.getRepository();
    }

    public static ManageableRepository getRepository() {
        try {
            RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
            return repositoryService.getCurrentRepository();
        }
        catch (Exception e) {
            log.error((Object)"getRepository() failed because of ", (Throwable)e);
            return null;
        }
    }

    public static void startRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).startRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static void endRequest(OrganizationService orgService) throws Exception {
        if (orgService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)orgService).endRequest(ExoContainerContext.getCurrentContainer());
        }
    }

    public static String getProjectVersion() throws Exception {
        String filePath = "jar:/conf/projectInfo.properties";
        Properties productInformationProperties = new Properties();
        try {
            ConfigurationManager configManager = WCMCoreUtils.getService(ConfigurationManager.class);
            log.info((Object)("Read products versions from " + filePath));
            InputStream inputStream = configManager.getInputStream(filePath);
            productInformationProperties.load(inputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException("Couldn't parse the file " + filePath, exception);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error occured while reading the file " + filePath, exception);
        }
        if (!productInformationProperties.containsKey("project.current.version")) {
            throw new RuntimeException("Missing product information.");
        }
        return productInformationProperties.getProperty("project.current.version");
    }

    public static String getActiveStylesheet(Node webcontent) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String cssQuery = StringUtils.replaceOnce((String)WEBCONTENT_CSS_QUERY, (String)"{path}", (String)webcontent.getPath());
        NodeLocation webcontentLocation = NodeLocation.getNodeLocationByNode(webcontent);
        ManageableRepository repository = (ManageableRepository)webcontent.getSession().getRepository();
        Session session = null;
        try {
            session = webcontentLocation.getPath().startsWith("/jcr:system") ? WCMCoreUtils.getSystemSessionProvider().getSession(repository.getConfiguration().getSystemWorkspaceName(), repository) : WCMCoreUtils.getSystemSessionProvider().getSession(webcontentLocation.getWorkspace(), repository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(cssQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node registeredCSSFile = iterator.nextNode();
                buffer.append(registeredCSSFile.getNode("jcr:content").getProperty("jcr:data").getString());
            }
        }
        catch (Exception e) {
            log.error((Object)"Unexpected problem happen when active stylesheet", (Throwable)e);
        }
        return buffer.toString();
    }

    public static Hashtable<String, String> getMetadataTemplates(Node node) throws Exception {
        NodeType[] nodeTypes;
        MetadataService metadataService = WCMCoreUtils.getService(MetadataService.class);
        Hashtable<String, String> templates = new Hashtable<String, String>();
        List<String> metaDataList = metadataService.getMetadataList();
        for (NodeType nt : nodeTypes = node.getMixinNodeTypes()) {
            if (!metaDataList.contains(nt.getName())) continue;
            templates.put(nt.getName(), metadataService.getMetadataPath(nt.getName(), false));
        }
        Item primaryItem = null;
        try {
            primaryItem = node.getPrimaryItem();
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        if (primaryItem != null && primaryItem.isNode()) {
            NodeType[] primaryTypes;
            Node primaryNode = (Node)node.getPrimaryItem();
            for (NodeType nt : primaryTypes = primaryNode.getMixinNodeTypes()) {
                if (!metaDataList.contains(nt.getName())) continue;
                templates.put(nt.getName(), metadataService.getMetadataPath(nt.getName(), false));
            }
        }
        return templates;
    }

    public static String getRestContextName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerConfig portalContainerConfig = (PortalContainerConfig)container.getComponentInstance(PortalContainerConfig.class);
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return portalContainerConfig.getRestContextName(containerInfo.getContainerName());
    }
}

