/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webos.webui.page;

import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webos.services.desktop.DesktopBackgroundService;
import org.exoplatform.webos.services.desktop.exception.ImageQuantityException;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}), @EventConfig(listeners={BackActionListener.class})})
public class UIBackgroundUploadForm
extends UIForm {
    public static final String MULTI_IMAGE = "Image";
    public static final String[] ACTIONS = new String[]{"Save", "Back"};
    private UIComponent referrer;

    public UIBackgroundUploadForm() throws Exception {
        DesktopBackgroundService backgroundService = (DesktopBackgroundService)this.getApplicationComponent(DesktopBackgroundService.class);
        int sizeLimit = backgroundService.getSizeLimit();
        Class[] paramTypes = new Class[]{String.class, String.class, Integer.TYPE, Boolean.TYPE};
        Object[] paramValues = new Object[]{MULTI_IMAGE, null, sizeLimit, true};
        this.addUIFormInput(this.makeMultiValueInputSet(MULTI_IMAGE, UIFormUploadInput.class, paramTypes, paramValues));
        this.setActions(ACTIONS);
    }

    public UIComponent getReferrer() {
        return this.referrer;
    }

    public void setReferrer(UIComponent referrer) {
        this.referrer = referrer;
    }

    private UIFormInput makeMultiValueInputSet(String name, Class<? extends UIFormInputBase> type, Class[] paramTypes, Object[] paramValues) throws Exception {
        UIFormMultiValueInputSet multiInput = new UIFormMultiValueInputSet(name, null);
        multiInput.setType(type);
        multiInput.setConstructorParameterTypes(paramTypes);
        multiInput.setConstructorParameterValues(paramValues);
        return multiInput;
    }

    private void backToImageList(WebuiRequestContext requestContext) {
        UIMaskWorkspace maskWorkspace = (UIMaskWorkspace)this.getAncestorOfType(UIMaskWorkspace.class);
        maskWorkspace.setUIComponent(this.getReferrer());
        requestContext.addUIComponentToUpdateByAjax((UIComponent)maskWorkspace);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIBackgroundUploadForm> {
        public void execute(Event<UIBackgroundUploadForm> event) throws Exception {
            UIBackgroundUploadForm uploadForm = (UIBackgroundUploadForm)((Object)event.getSource());
            uploadForm.backToImageList(event.getRequestContext());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIBackgroundUploadForm> {
        public void execute(Event<UIBackgroundUploadForm> event) throws Exception {
            UIBackgroundUploadForm uploadForm = (UIBackgroundUploadForm)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            rcontext.addUIComponentToUpdateByAjax((UIComponent)uploadForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIBackgroundUploadForm> {
        public void execute(Event<UIBackgroundUploadForm> event) throws Exception {
            UIBackgroundUploadForm uploadForm = (UIBackgroundUploadForm)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            rcontext.addUIComponentToUpdateByAjax((UIComponent)uploadForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIBackgroundUploadForm> {
        public void execute(Event<UIBackgroundUploadForm> event) throws Exception {
            UIBackgroundUploadForm uploadForm = (UIBackgroundUploadForm)((Object)event.getSource());
            UIFormMultiValueInputSet multiInput = (UIFormMultiValueInputSet)uploadForm.findComponentById(UIBackgroundUploadForm.MULTI_IMAGE);
            StringBuilder invalidFiles = new StringBuilder();
            for (UIComponent child : multiInput.getChildren()) {
                UIFormUploadInput uploadInput;
                UploadResource uploadResource;
                if (!(child instanceof UIFormUploadInput) || (uploadResource = (uploadInput = (UIFormUploadInput)child).getUploadResource()) == null) continue;
                if (!uploadResource.getMimeType().startsWith("image/")) {
                    invalidFiles.append(uploadResource.getFileName()).append(", ");
                    continue;
                }
                try {
                    this.saveToDB(uploadInput);
                }
                catch (ImageQuantityException e) {
                    ApplicationMessage msg = new ApplicationMessage("UIBackgroundUploadForm.msg.image.quantity.exceed", (Object[])new String[]{String.valueOf(e.getQuantity())}, 1);
                    Util.getUIPortalApplication().addMessage(msg);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uploadForm);
                    return;
                }
                this.cleanUploadedFile(uploadInput);
            }
            if (invalidFiles.length() > 0) {
                ApplicationMessage msg = new ApplicationMessage("UIBackgroundUploadForm.msg.invalid.image", null, 1);
                Util.getUIPortalApplication().addMessage(msg);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uploadForm);
                return;
            }
            uploadForm.backToImageList(event.getRequestContext());
        }

        private boolean saveToDB(UIFormUploadInput uploadInput) throws Exception {
            UploadResource uploadResource = uploadInput.getUploadResource();
            DesktopBackgroundService backgroundService = (DesktopBackgroundService)uploadInput.getApplicationComponent(DesktopBackgroundService.class);
            UIPortal uiPortal = Util.getUIPortal();
            backgroundService.uploadBackgroundImage(new PortalKey(uiPortal.getSiteType().getName(), uiPortal.getSiteKey().getName()), uploadResource.getFileName(), uploadResource.getMimeType(), "UTF-8", uploadInput.getUploadDataAsStream());
            return true;
        }

        private void cleanUploadedFile(UIFormUploadInput uploadInput) {
            UploadService uploadService = (UploadService)uploadInput.getApplicationComponent(UploadService.class);
            uploadService.removeUploadResource(uploadInput.getUploadId());
        }
    }
}

