/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal;

import java.util.Map;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;

@Component
public class DefaultModelContext
implements ModelContext {
    public static final String XCONTEXT_KEY = "xwikicontext";
    private static final String WIKINAME_KEY = "wiki";
    @Requirement
    private Execution execution;

    public EntityReference getCurrentEntityReference() {
        String wikiName;
        Map xcontext;
        WikiReference result = null;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null && (xcontext = (Map)econtext.getProperty(XCONTEXT_KEY)) != null && (wikiName = (String)xcontext.get(WIKINAME_KEY)) != null) {
            result = new WikiReference(wikiName);
        }
        return result;
    }

    public void setCurrentEntityReference(EntityReference entityReference) {
        Map xcontext;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null && (xcontext = (Map)econtext.getProperty(XCONTEXT_KEY)) != null) {
            xcontext.put(WIKINAME_KEY, this.extractWikiName(entityReference));
        }
    }

    private String extractWikiName(EntityReference entityReference) {
        EntityReference wikiReference;
        String wikiName = null;
        if (entityReference != null && (wikiReference = entityReference.extractReference(EntityType.WIKI)) != null) {
            wikiName = wikiReference.getName();
        }
        return wikiName;
    }
}

