/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.commons;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.UIDocumentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/webui/commons/UISaveAttachment.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={SaveFileActionListener.class})})
public class UISaveAttachment
extends UIForm
implements UIPopupComponent {
    protected static Log log = ExoLogger.getLogger(UISaveAttachment.class);
    protected static final String UIDOCUMENTSELECTOR = "UIDocumentSelector";
    protected static final String FIELD_INPUT = "FileNameInput";
    protected static final String CANCEL = "Cancel";
    protected static final String SAVEFILE = "SaveFile";
    private String filePath = "";
    private String fileName = "";
    private static final String invalidCharacters = ": @ / \\ | ^ # ; [ ] { } < > * ' \" + ? &";

    public UISaveAttachment() {
        try {
            this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_INPUT, null, null));
            UIDocumentSelector documentSelector = (UIDocumentSelector)this.addChild(UIDocumentSelector.class, null, UIDOCUMENTSELECTOR);
            documentSelector.setAllowAddFolder(true);
            documentSelector.setAllowDeleteItem(true);
        }
        catch (Exception e) {
            log.error((Object)"An exception happens when init UISaveAttachment", (Throwable)e);
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        this.getUIStringInput(FIELD_INPUT).setValue((Object)this.fileName);
        super.processRender(context);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Session getSession(String workspace) throws Exception {
        ManageableRepository repository = this.getCurrentRepository();
        return repository.getSystemSession(workspace);
    }

    public Session getDefaultSession() throws Exception {
        ManageableRepository repository = this.getCurrentRepository();
        String defaultWorkspace = repository.getConfiguration().getDefaultWorkspaceName();
        return repository.getSystemSession(defaultWorkspace);
    }

    private ManageableRepository getCurrentRepository() throws RepositoryException {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        return repoService.getCurrentRepository();
    }

    public static void validate(String s) throws IllegalNameException {
        if (s == null || s.trim().length() == 0) {
            throw new IllegalNameException();
        }
        for (int i = 0; i < s.length(); ++i) {
            String test;
            StringTokenizer tokens = new StringTokenizer(invalidCharacters);
            char c = s.charAt(i);
            boolean isInvalid = false;
            while (tokens.hasMoreTokens() && !(isInvalid = (test = tokens.nextToken()).equals(String.valueOf(c)))) {
            }
            if (Character.isLetter(c) || Character.isDigit(c) || !isInvalid) continue;
            throw new IllegalNameException(invalidCharacters);
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveFileActionListener
    extends EventListener<UISaveAttachment> {
        public void execute(Event<UISaveAttachment> event) throws Exception {
            UISaveAttachment component = (UISaveAttachment)((Object)event.getSource());
            UIDocumentSelector selector = (UIDocumentSelector)component.getChildById(UISaveAttachment.UIDOCUMENTSELECTOR);
            UIFormStringInput nameInput = (UIFormStringInput)component.getChildById(UISaveAttachment.FIELD_INPUT);
            String fileName = (String)nameInput.getValue();
            String tempPath = component.filePath.substring(1);
            String workspaceName = tempPath.substring(0, tempPath.indexOf("/"));
            if (fileName == null || fileName.trim().length() == 0) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UISaveAttachment.msg.file-name-not-null", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).setFullRender(true);
                return;
            }
            String nodePath = tempPath.substring(tempPath.indexOf("/"));
            Session srcSession = component.getSession(workspaceName);
            Node srcNode = (Node)srcSession.getItem(nodePath);
            Node srcContent = srcNode.getNode("jcr:content");
            Value value = srcContent.getProperty("jcr:data").getValue();
            String mimeType = srcContent.getProperty("jcr:mimeType").getString();
            srcSession.logout();
            Session desSession = component.getDefaultSession();
            String selectedFolder = selector.getSeletedFolder();
            if (StringUtils.isEmpty((String)selectedFolder)) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UISaveAttachment.msg.not-a-folder", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).setFullRender(true);
                return;
            }
            Node desNode = (Node)desSession.getItem(selector.getSeletedFolder());
            try {
                UISaveAttachment.validate(fileName);
            }
            catch (IllegalNameException e) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UISaveAttachment.msg.not-valid-name", (Object[])new String[]{UISaveAttachment.invalidCharacters}, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).setFullRender(true);
                return;
            }
            Node file = desNode.addNode(fileName, "nt:file");
            Node jcrContent = file.addNode("jcr:content", "nt:resource");
            jcrContent.setProperty("jcr:data", value);
            jcrContent.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            jcrContent.setProperty("jcr:mimeType", mimeType);
            desSession.save();
            desSession.logout();
            UIPopupWindow uiPopupWindow = (UIPopupWindow)((UISaveAttachment)((Object)event.getSource())).getParent();
            uiPopupWindow.setUIComponent(null);
            uiPopupWindow.setRendered(false);
            event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UISaveAttachment.msg.saved-successfully", null, 2));
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopupWindow.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISaveAttachment> {
        public void execute(Event<UISaveAttachment> event) throws Exception {
            UIPopupWindow uiPopupWindow = (UIPopupWindow)((UISaveAttachment)((Object)event.getSource())).getParent();
            uiPopupWindow.setUIComponent(null);
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopupWindow.getParent());
        }
    }
}

