/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.navigation;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationServiceWrapper;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.publication.WCMPublicationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateNavigationEventListener
extends Listener<NavigationServiceWrapper, SiteKey> {
    private static Log log = ExoLogger.getLogger(UpdateNavigationEventListener.class);

    public void onEvent(Event<NavigationServiceWrapper, SiteKey> event) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        WCMPublicationService publicationService = (WCMPublicationService)container.getComponentInstanceOfType(WCMPublicationService.class);
        NavigationServiceWrapper navigationWrapper = (NavigationServiceWrapper)event.getSource();
        SiteKey key = (SiteKey)event.getData();
        NavigationContext navigationContext = navigationWrapper.loadNavigation(key);
        try {
            if (ConversationState.getCurrent() == null) {
                publicationService.updateLifecycleOnChangeNavigation(navigationContext, null);
            } else {
                publicationService.updateLifecycleOnChangeNavigation(navigationContext, ConversationState.getCurrent().getIdentity().getUserId());
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception when update publication lifecyle", (Throwable)e);
        }
    }
}

