/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api_v1alpha1.models;

import java.util.Map;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api_v1alpha1.models.ActivityStream;
import org.exoplatform.social.service.rest.api_v1alpha1.models.Comment;
import org.exoplatform.social.service.rest.api_v1alpha1.models.Identity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activity {
    private String id;
    private String title;
    private Float priority;
    private String appId;
    private String type;
    private long postedTime;
    private String createdAt;
    private String titleId;
    private Map<String, String> templateParams;
    private boolean liked;
    private Identity[] likedByIdentities;
    private Comment[] comments;
    private int totalNumberOfComments;
    private Identity posterIdentity;
    private String identityId;
    private ActivityStream activityStream;

    public Activity() {
    }

    public Activity(String id, String title, Float priority, String appId, String type, long postedTime, String createdAt, String titleId, Map<String, String> templateParams, boolean liked, Identity[] likedByIdentities, String identityId) {
        this.id = id;
        this.title = title;
        this.priority = priority;
        this.appId = appId;
        this.type = type;
        this.postedTime = postedTime;
        this.createdAt = createdAt;
        this.titleId = titleId;
        this.templateParams = templateParams;
        this.liked = liked;
        this.likedByIdentities = likedByIdentities;
        this.identityId = identityId;
    }

    public Activity(ExoSocialActivity activity) {
        Identity[] identitysIdentities = null;
        if (activity.getLikeIdentityIds() != null && activity.getLikeIdentityIds().length > 0) {
            String[] getLikeIdentityIds = activity.getLikeIdentityIds();
            identitysIdentities = new Identity[getLikeIdentityIds.length];
            for (int i = 0; i < identitysIdentities.length; ++i) {
                identitysIdentities[i] = new Identity(getLikeIdentityIds[i]);
            }
        }
        this.id = activity.getId();
        this.title = activity.getTitle();
        this.priority = activity.getPriority();
        this.appId = activity.getAppId();
        this.type = activity.getType();
        this.postedTime = activity.getPostedTime();
        this.createdAt = Util.convertTimestampToTimeString(this.getPostedTime());
        this.titleId = activity.getTitleId();
        this.templateParams = activity.getTemplateParams();
        this.likedByIdentities = identitysIdentities;
        org.exoplatform.social.core.identity.model.Identity streamOwnerIdentity = Util.getOwnerIdentityIdFromActivity(activity);
        if (streamOwnerIdentity != null) {
            this.identityId = streamOwnerIdentity.getId();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Float getPriority() {
        return this.priority;
    }

    public void setPriority(Float priority) {
        this.priority = priority;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public long getPostedTime() {
        return this.postedTime;
    }

    public void setPostedTime(long postedTime) {
        this.postedTime = postedTime;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getTitleId() {
        return this.titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public Map<String, String> getTemplateParams() {
        return this.templateParams;
    }

    public void setTemplateParams(Map<String, String> templateParams) {
        this.templateParams = templateParams;
    }

    public boolean isLiked() {
        return this.liked;
    }

    public void setLiked(boolean liked) {
        this.liked = liked;
    }

    public Identity[] getLikedByIdentities() {
        return this.likedByIdentities;
    }

    public void setLikedByIdentities(Identity[] likedByIdentities) {
        this.likedByIdentities = likedByIdentities;
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void setComments(Comment[] comments) {
        this.comments = comments;
    }

    public int getTotalNumberOfComments() {
        return this.totalNumberOfComments;
    }

    public void setTotalNumberOfComments(int numberOfComments) {
        this.totalNumberOfComments = numberOfComments;
    }

    public Identity getPosterIdentity() {
        return this.posterIdentity;
    }

    public void setPosterIdentity(Identity posterIdentity) {
        this.posterIdentity = posterIdentity;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public ActivityStream getActivityStream() {
        return this.activityStream;
    }

    public void setActivityStream(ActivityStream activityStream) {
        this.activityStream = activityStream;
    }
}

