/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.util.ClassLoaderUtil;

public class FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog((Class)FieldInstantiator.class);

    public Object instantiate(Class clazz, String configuration) {
        Object newInstance = this.newInstance(clazz);
        if (configuration != null && configuration.length() > 0) {
            Element configurationElement = this.parseConfiguration(configuration);
            Iterator iter = configurationElement.elementIterator();
            while (iter.hasNext()) {
                Element propertyElement = (Element)iter.next();
                String propertyName = propertyElement.getName();
                this.setPropertyValue(clazz, newInstance, propertyName, propertyElement);
            }
        }
        return newInstance;
    }

    protected void setPropertyValue(Class clazz, Object instance, String propertyName, Element propertyElement) {
        Field field = this.findField(clazz, propertyName);
        if (field != null) {
            field.setAccessible(true);
            Object value = FieldInstantiator.getValue(field.getType(), propertyElement);
            try {
                field.set(instance, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("field '" + propertyName + "' cannot be set to value: " + value), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)(" field '" + propertyName + "' is inaccessible"), (Throwable)e);
            }
        } else {
            log.error((Object)("field '" + propertyName + "' was not found"));
        }
    }

    private Field findField(Class clazz, String propertyName) {
        while (true) {
            try {
                return clazz.getDeclaredField(propertyName);
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    protected Element parseConfiguration(String configuration) {
        Element element = null;
        try {
            element = DocumentHelper.parseText((String)("<action>" + configuration + "</action>")).getRootElement();
        }
        catch (DocumentException e) {
            log.error((Object)("couldn't parse bean configuration : " + configuration), (Throwable)e);
            throw new JbpmException(e);
        }
        return element;
    }

    protected Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new JbpmException("could not instantiate " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException("could not access " + clazz, e);
        }
    }

    public static Object getValue(Class type, Element propertyElement) {
        Object value;
        block40: {
            value = null;
            if (type == String.class) {
                value = propertyElement.getText();
            } else if (type == Integer.class || type == Integer.TYPE) {
                value = new Integer(propertyElement.getTextTrim());
            } else if (type == Long.class || type == Long.TYPE) {
                value = new Long(propertyElement.getTextTrim());
            } else if (type == Float.class || type == Float.TYPE) {
                value = new Float(propertyElement.getTextTrim());
            } else if (type == Double.class || type == Double.TYPE) {
                value = new Double(propertyElement.getTextTrim());
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                value = Boolean.valueOf(propertyElement.getTextTrim());
            } else if (type == Character.class || type == Character.TYPE) {
                value = new Character(propertyElement.getTextTrim().charAt(0));
            } else if (type == Short.class || type == Short.TYPE) {
                value = new Short(propertyElement.getTextTrim());
            } else if (type == Byte.class || type == Byte.TYPE) {
                value = new Byte(propertyElement.getTextTrim());
            } else if (type == List.class || type == Collection.class) {
                value = FieldInstantiator.getCollection(propertyElement, new ArrayList());
            } else if (type == Set.class) {
                value = FieldInstantiator.getCollection(propertyElement, new HashSet());
            } else if (type == SortedSet.class) {
                value = FieldInstantiator.getCollection(propertyElement, new TreeSet());
            } else if (type == Map.class) {
                value = FieldInstantiator.getMap(propertyElement, new HashMap());
            } else if (type == SortedMap.class) {
                value = FieldInstantiator.getMap(propertyElement, new TreeMap());
            } else if (Element.class.isAssignableFrom(type)) {
                value = propertyElement;
            } else {
                try {
                    if (Collection.class.isAssignableFrom(type)) {
                        value = FieldInstantiator.getCollection(propertyElement, (Collection)type.newInstance());
                        break block40;
                    }
                    if (Map.class.isAssignableFrom(type)) {
                        value = FieldInstantiator.getMap(propertyElement, (Map)type.newInstance());
                        break block40;
                    }
                    try {
                        Constructor constructor = type.getConstructor(String.class);
                        if (propertyElement.isTextOnly()) {
                            value = constructor.newInstance(propertyElement.getTextTrim());
                            break block40;
                        }
                        log.error((Object)("element '" + propertyElement.getName() + "' has non-text content"));
                    }
                    catch (NoSuchMethodException e) {
                        log.error((Object)(type + " does not have a string constructor"), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)(type + " cannot be constructed with value " + propertyElement.getTextTrim()), (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    log.error((Object)("could not instantiate " + type), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)(type + " is inaccessible"), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)("constructor for " + type + " threw exception"), e.getCause());
                }
            }
        }
        return value;
    }

    private static Map getMap(Element mapElement, Map map) {
        Class keyClass = FieldInstantiator.classForAttributeValue(mapElement, "key-type");
        Class valueClass = FieldInstantiator.classForAttributeValue(mapElement, "value-type");
        Iterator iter = mapElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            Element keyElement = element.element("key");
            Element valueElement = element.element("value");
            map.put(FieldInstantiator.getValue(keyClass, keyElement), FieldInstantiator.getValue(valueClass, valueElement));
        }
        return map;
    }

    static Object getCollection(Element collectionElement, Collection collection) {
        Class elementClass = FieldInstantiator.classForAttributeValue(collectionElement, "element-type");
        Iterator iter = collectionElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            collection.add(FieldInstantiator.getValue(elementClass, element));
        }
        return collection;
    }

    private static Class classForAttributeValue(Element element, String attributeName) {
        Class type = String.class;
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue != null) {
            type = ClassLoaderUtil.classForName(attributeValue);
        }
        return type;
    }
}

