/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.util.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SinglePropertyQuasi
extends QuasiNode {
    SinglePropertyQuasi(QuasiNode key, QuasiNode value) {
        super(key, value);
    }

    QuasiNode getKey() {
        return this.getChildren().get(0);
    }

    QuasiNode getValue() {
        return this.getChildren().get(1);
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        QuasiNode key = this.getKey();
        QuasiNode value = this.getValue();
        Iterator<ParseTreeNode> it = specimens.iterator();
        while (it.hasNext()) {
            List<ParseTreeNode> valueCandidate;
            ParseTreeNode candidate = it.next();
            if (!(candidate instanceof ValueProperty)) continue;
            ValueProperty prop = (ValueProperty)candidate;
            List<ParseTreeNode> keyCandidate = Lists.newArrayList(prop.getPropertyNameNode());
            if (!key.consumeSpecimens(keyCandidate, bindings) || !keyCandidate.isEmpty() || !value.consumeSpecimens(valueCandidate = Lists.newArrayList(prop.getValueExpr()), bindings)) continue;
            if (valueCandidate.isEmpty()) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        int subsSizeValue;
        int subsSizeKey;
        int subsSize = substitutes.size();
        if (this.getKey().createSubstitutes(substitutes, bindings) && (subsSizeKey = substitutes.size()) == subsSize + 1 && substitutes.get(subsSize) instanceof StringLiteral && this.getValue().createSubstitutes(substitutes, bindings) && (subsSizeValue = substitutes.size()) == subsSizeKey + 1) {
            StringLiteral key = (StringLiteral)substitutes.get(subsSize);
            Expression value = (Expression)substitutes.get(subsSize + 1);
            substitutes.subList(subsSize, substitutes.size()).clear();
            substitutes.add(new ValueProperty(key, value));
            return true;
        }
        substitutes.subList(subsSize, substitutes.size()).clear();
        return false;
    }
}

