/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import java.io.Reader;
import java.io.StringReader;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.resource.Resource;
import org.exoplatform.portal.resource.ResourceResolver;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMSkinResourceResolver
implements ResourceResolver {
    private SkinService skinService;
    private LivePortalManagerService livePortalService;
    private static Log log = ExoLogger.getLogger((String)"wcm:WCMSkinResourceResolver");
    private static String SHARED_CSS_QUERY = "select * from exo:cssFile where jcr:path like '{path}/%' and exo:active='true' and exo:sharedCSS='true' and jcr:mixinTypes <> 'exo:restoreLocation' order by exo:priority ASC";

    public WCMSkinResourceResolver(SkinService skinService, LivePortalManagerService livePortalService) {
        this.skinService = skinService;
        this.livePortalService = livePortalService;
    }

    public Resource resolve(String path) {
        if (!path.matches("/(.*)/css/jcr/(.*)/(.*)/(.*).css")) {
            return null;
        }
        String[] elements = path.split("/");
        String portalName = elements[4];
        String skinName = elements[5];
        String skinModule = portalName;
        String cssPath = null;
        SkinConfig portalSkinConfig = this.skinService.getSkin(portalName, skinName);
        if (portalSkinConfig != null) {
            cssPath = portalSkinConfig.getCSSPath();
        }
        if (cssPath == null) {
            for (SkinConfig skinConfig : this.skinService.getPortalSkins(skinName)) {
                if (!skinConfig.getModule().equals(skinModule)) continue;
                cssPath = skinConfig.getCSSPath();
                break;
            }
        }
        try {
            Node portalNode = this.livePortalService.getLivePortal(WCMCoreUtils.getSystemSessionProvider(), portalName);
            final String cssData = WCMCoreUtils.getSiteGlobalActiveStylesheet(portalNode);
            if (cssData == null) {
                return null;
            }
            return new Resource(cssPath){

                public Reader read() {
                    return new StringReader(cssData);
                }
            };
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error happens", (Throwable)e);
            return null;
        }
    }

    private String mergeCSSData(Node portalNode) throws Exception {
        StringBuffer buffer = new StringBuffer();
        WebSchemaConfigService schemaConfigService = WCMCoreUtils.getService(WebSchemaConfigService.class);
        Node cssFolder = schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class).getCSSFolder(portalNode);
        String statement = StringUtils.replaceOnce((String)SHARED_CSS_QUERY, (String)"{path}", (String)cssFolder.getPath());
        try {
            QueryManager queryManager = portalNode.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(statement, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node registeredCSSFile = iterator.nextNode();
                buffer.append(this.getActivedCSSData(registeredCSSFile));
            }
            buffer.append(WCMCoreUtils.getActiveStylesheet(portalNode));
        }
        catch (Exception e) {
            log.error((Object)"Unexpected problem happen when merge CSS data", (Throwable)e);
        }
        return buffer.toString();
    }

    private String getActivedCSSData(Node cssFile) throws ValueFormatException, RepositoryException, PathNotFoundException {
        if (!cssFile.isNodeType("exo:restoreLocation") && cssFile.hasNode("jcr:content") && cssFile.getNode("jcr:content").hasProperty("jcr:data") && cssFile.hasProperty("exo:active") && cssFile.getProperty("exo:active").getBoolean()) {
            return cssFile.getNode("jcr:content").getProperty("jcr:data").getString();
        }
        return "";
    }
}

