/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.service.rest.api.models.ActivityRestOut;
import org.exoplatform.social.service.rest.api.models.ActivityStreamRestOut;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityRestListOut
extends HashMap<String, Object> {
    private static final int MAX_LIMIT = 100;
    private static final int MAX_NUMBER_OF_COMMENTS = 100;
    private static final int MAX_NUMBER_OF_LIKES = 100;

    public ActivityRestListOut() {
        this.initialize();
    }

    public ActivityRestListOut(List<ExoSocialActivity> activityList, int numberOfComments, int numberOfLikes, String portalContainerName) {
        if (activityList == null || activityList.size() == 0) {
            this.initialize();
            return;
        }
        if (activityList.size() > 100) {
            activityList = activityList.subList(0, 99);
        }
        numberOfComments = numberOfComments >= 0 ? numberOfComments : 0;
        numberOfComments = Math.min(numberOfComments, 100);
        numberOfLikes = numberOfLikes >= 0 ? numberOfLikes : 0;
        numberOfLikes = Math.min(numberOfLikes, 100);
        this.initialize(activityList, numberOfComments, numberOfLikes, portalContainerName);
    }

    private void initialize() {
        this.put(Field.ACTIVITIES.toString(), new ArrayList());
    }

    private void initialize(List<ExoSocialActivity> activityList, int numberOfComments, int numberOfLikes, String portalContainerName) {
        ArrayList<ActivityRestOut> activityItems = new ArrayList<ActivityRestOut>();
        for (ExoSocialActivity activity : activityList) {
            ActivityRestOut activityItem = new ActivityRestOut(activity, portalContainerName);
            activityItem.setPosterIdentity(new IdentityRestOut(activity.getUserId(), portalContainerName));
            activityItem.setActivityStream(new ActivityStreamRestOut(activity.getActivityStream()));
            activityItem.setNumberOfComments(numberOfComments, activity, portalContainerName);
            activityItem.setNumberOfLikes(numberOfLikes, activity, portalContainerName);
            activityItems.add(activityItem);
        }
        this.put(Field.ACTIVITIES.toString(), activityItems);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Field {
        ACTIVITIES("activities");

        private final String fieldName;

        private Field(String str) {
            this.fieldName = str;
        }

        public String toString() {
            return this.fieldName;
        }
    }
}

