/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faq.service.notify;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.ks.common.CommonUtils;
import org.exoplatform.ks.common.NotifyInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class NotifyJob
implements Job {
    private static Log log_ = ExoLogger.getLogger((String)"job.RecordsJob");

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer exoContainer = CommonUtils.getExoContainer((JobExecutionContext)context);
        try {
            MailService mailService = (MailService)exoContainer.getComponentInstanceOfType(MailService.class);
            FAQService faqService = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            Iterator<NotifyInfo> iter = faqService.getPendingMessages();
            int countEmail = 0;
            while (iter.hasNext()) {
                try {
                    NotifyInfo messageInfo = iter.next();
                    List emailAddresses = messageInfo.getEmailAddresses();
                    Message message = messageInfo.getMessage();
                    message.setFrom(CommonUtils.makeNotificationSender((String)message.getFrom()));
                    if (message == null || emailAddresses == null || emailAddresses.size() <= 0) continue;
                    ArrayList<String> sentMessages = new ArrayList<String>();
                    for (String address : emailAddresses) {
                        if (sentMessages.contains(address)) continue;
                        message.setTo(address);
                        mailService.sendMessage(message);
                        sentMessages.add(address);
                        ++countEmail;
                    }
                }
                catch (Exception e) {
                }
            }
            if (log_.isInfoEnabled() && countEmail > 0) {
                log_.info((Object)("\n\nEmail notifications for Thread Save Question have been sent to " + countEmail + " addresses"));
            }
        }
        catch (Exception e) {
            log_.warn((Object)"\n\n Unable send email notification ");
        }
    }
}

