/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;
import org.xwiki.component.annotation.Component;
import org.xwiki.script.service.ScriptService;

@Component(value="xml")
public class XMLScriptService
implements ScriptService {
    private static final Log LOG = LogFactory.getLog(XMLScriptService.class);
    private static final String DISABLE_DTD_PARAM = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String AMP = "&#38;";
    private static final Pattern AMP_PATTERN = Pattern.compile("&(?:amp|#0*+38|#x0*+26);");
    private static final String APOS = "&#39;";
    private static final Pattern APOS_PATTERN = Pattern.compile("&(?:apos|#0*+39|#x0*+27);");
    private static final String QUOT = "&#34;";
    private static final Pattern QUOT_PATTERN = Pattern.compile("&(?:quot|#0*+34|#x0*+22);");
    private static final String LT = "&#60;";
    private static final Pattern LT_PATTERN = Pattern.compile("&(?:lt|#0*+60|#x0*+3[cC]);");
    private static final String GT = "&#62;";
    private static final Pattern GT_PATTERN = Pattern.compile("&(?:gt|#0*+62|#x0*+3[eE]);");
    private DOMImplementationLS lsImpl;

    public XMLScriptService() {
        try {
            this.lsImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS 3.0"));
        }
        catch (Exception ex) {
            LOG.warn((Object)"Cannot initialize the XML Script Service", (Throwable)ex);
        }
    }

    public static String escape(Object content) {
        return XMLScriptService.escapeForAttributeValue(content);
    }

    public static String escapeForAttributeValue(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block7;
                }
                case '\'': {
                    result.append(APOS);
                    continue block7;
                }
                case '\"': {
                    result.append(QUOT);
                    continue block7;
                }
                case '<': {
                    result.append(LT);
                    continue block7;
                }
                case '>': {
                    result.append(GT);
                    continue block7;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeForElementContent(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        StringBuilder result = new StringBuilder((int)((double)str.length() * 1.1));
        int length = str.length();
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    result.append(AMP);
                    continue block5;
                }
                case '<': {
                    result.append(LT);
                    continue block5;
                }
                case '>': {
                    result.append(GT);
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String unescape(Object content) {
        if (content == null) {
            return null;
        }
        String str = String.valueOf(content);
        str = APOS_PATTERN.matcher(str).replaceAll("'");
        str = QUOT_PATTERN.matcher(str).replaceAll("\"");
        str = LT_PATTERN.matcher(str).replaceAll("<");
        str = GT_PATTERN.matcher(str).replaceAll(">");
        str = AMP_PATTERN.matcher(str).replaceAll("&");
        return str;
    }

    public Document createDOMDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)"Cannot create DOM Documents", (Throwable)ex);
            return null;
        }
    }

    public Document parse(LSInput source) {
        try {
            LSParser p = this.lsImpl.createLSParser((short)1, null);
            p.getDomConfig().setParameter("validate", false);
            if (p.getDomConfig().canSetParameter(DISABLE_DTD_PARAM, false)) {
                p.getDomConfig().setParameter(DISABLE_DTD_PARAM, false);
            }
            return p.parse(source);
        }
        catch (Exception ex) {
            LOG.warn((Object)("Cannot parse XML document: " + ex.getMessage()));
            return null;
        }
    }

    public Document parse(byte[] content) {
        if (content == null) {
            return null;
        }
        LSInput input = this.lsImpl.createLSInput();
        input.setByteStream(new ByteArrayInputStream(content));
        return this.parse(input);
    }

    public Document parse(String content) {
        if (content == null) {
            return null;
        }
        LSInput input = this.lsImpl.createLSInput();
        input.setCharacterStream(new StringReader(content));
        return this.parse(input);
    }

    public Document parse(InputStream stream) {
        if (stream == null) {
            return null;
        }
        LSInput input = this.lsImpl.createLSInput();
        input.setByteStream(stream);
        return this.parse(input);
    }

    public String serialize(Node node) {
        return this.serialize(node, true);
    }

    public String serialize(Node node, boolean withXmlDeclaration) {
        if (node == null) {
            return "";
        }
        try {
            LSOutput output = this.lsImpl.createLSOutput();
            StringWriter result = new StringWriter();
            output.setCharacterStream(result);
            LSSerializer serializer = this.lsImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", withXmlDeclaration);
            serializer.setNewLine("\n");
            String encoding = "UTF-8";
            if (node instanceof Document) {
                encoding = ((Document)node).getXmlEncoding();
            } else if (node.getOwnerDocument() != null) {
                encoding = node.getOwnerDocument().getXmlEncoding();
            }
            output.setEncoding(encoding);
            serializer.write(node, output);
            return result.toString();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to serialize node to XML String", (Throwable)ex);
            return "";
        }
    }

    public String transform(Source xml, Source xslt) {
        if (xml != null && xslt != null) {
            try {
                StringWriter output = new StringWriter();
                StreamResult result = new StreamResult(output);
                TransformerFactory.newInstance().newTransformer(xslt).transform(xml, result);
                return output.toString();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Failed to apply XSLT transformation: " + ex.getMessage()));
            }
        }
        return null;
    }

    public String transform(Document xml, Document xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        return this.transform(new DOMSource(xml), new DOMSource(xslt));
    }

    public String transform(byte[] xml, byte[] xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        return this.transform(new StreamSource(new ByteArrayInputStream(xml)), new StreamSource(new ByteArrayInputStream(xslt)));
    }

    public String transform(String xml, String xslt) {
        if (xml == null || xslt == null) {
            return null;
        }
        return this.transform(new StreamSource(new StringReader(xml)), new StreamSource(new StringReader(xslt)));
    }
}

