/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UISocialGroupSelector;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceGroupBound;
import org.exoplatform.social.webui.space.UISpaceSettings;
import org.exoplatform.social.webui.space.UISpaceVisibility;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={CreateActionListener.class}), @EventConfig(listeners={ToggleUseGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangePriorityActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeOptionActionListener.class}, phase=Event.Phase.DECODE)})
public class UISpaceAddForm
extends UIFormTabPane {
    private static final Log LOG = ExoLogger.getLogger(UISpaceAddForm.class);
    private static final String MSG_DEFAULT_SPACE_DESCRIPTION = "UISpaceAddForm.msg.default_space_description";
    private static final String MSG_ERROR_SPACE_CREATION = "UISpaceAddForm.msg.error_space_creation";
    private static final String MSG_ERROR_DATASTORE = "UISpaceAddForm.msg.error_space_not_saved";
    private static final String MSG_ERROR_UNABLE_TO_INIT_APP = "UISpaceAddForm.msg.error_unable_to_init_app";
    private static final String MSG_ERROR_UNABLE_TO_ADD_CREATOR = "UISpaceAddForm.msg.error_unable_to_add_creator";
    private static final String MSG_ERROR_UNABLE_TO_ADD_APPLICATION = "UISpaceAddForm.msg.error_unable_to_add_application";
    private static final String MSG_ERROR_RETRIEVING_USER = "UISpaceAddForm.msg.error_unable_to_retrieve_user";
    private static final String MSG_SPACE_CREATION_SUCCESS = "UISpaceAddForm.msg.space_creation_success";
    private static final String MSG_ERROR_SPACE_ALREADY_EXIST = "UISpaceAddForm.msg.error_space_already_exist";
    private final String SPACE_SETTINGS = "UISpaceSettings";
    private final String SPACE_VISIBILITY = "UISpaceVisibility";
    private final String CHANGE_PRIORITY = "ChangePriority";

    public UISpaceAddForm() throws Exception {
        super("UISpaceAddForm");
        UISpaceSettings uiSpaceSettings = new UISpaceSettings("UISpaceSettings");
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)uiSpaceSettings.getChild(UIFormSelectBox.class);
        uiSelectBox.setOnChange("ChangePriority");
        this.addChild((UIComponent)uiSpaceSettings);
        UISpaceVisibility uiSpaceVisibility = new UISpaceVisibility("UISpaceVisibility");
        this.addChild((UIComponent)uiSpaceVisibility);
        this.addChild(UISpaceGroupBound.class, null, null);
        this.setActions(new String[]{"Create"});
        this.setSelectedTab(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeOptionActionListener
    extends EventListener<UISpaceAddForm> {
        private final String VISIBLE_OPEN_SPACE = "UISpaceVisibility.label.VisibleAndOpenSpace";
        private final String VISIBLE_VALIDATION_SPACE = "UISpaceVisibility.label.VisibleAndValidationSpace";
        private final String VISIBLE_CLOSE_SPACE = "UISpaceVisibility.label.VisibleAndCloseSpace";
        private final String HIDDEN_SPACE = "UISpaceVisibility.label.HiddenSpace";

        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String visibleAndOpenSpace = resApp.getString("UISpaceVisibility.label.VisibleAndOpenSpace");
            String visibleAndValidationSpace = resApp.getString("UISpaceVisibility.label.VisibleAndValidationSpace");
            String visibleAndCloseSpace = resApp.getString("UISpaceVisibility.label.VisibleAndCloseSpace");
            String hiddenSpace = resApp.getString("UISpaceVisibility.label.HiddenSpace");
            Space space = new Space();
            uiSpaceAddForm.invokeSetBindingBean(space);
            UIFormInputSet uiSpaceVisibility = (UIFormInputSet)uiSpaceAddForm.getChildById("UISpaceVisibility");
            UIFormInputInfo uiFormInfo = (UIFormInputInfo)uiSpaceVisibility.getChild(UIFormInputInfo.class);
            String currentVisibility = space.getVisibility();
            String currentRegistration = space.getRegistration();
            boolean isPrivate = "private".equals(currentVisibility);
            boolean isOpen = "open".equals(currentRegistration);
            boolean isValidation = "validation".equals(currentRegistration);
            boolean isClose = "close".equals(currentRegistration);
            if (isPrivate && isOpen) {
                uiFormInfo.setValue((Object)visibleAndOpenSpace);
            } else if (isPrivate && isValidation) {
                uiFormInfo.setValue((Object)visibleAndValidationSpace);
            } else if (isPrivate && isClose) {
                uiFormInfo.setValue((Object)visibleAndCloseSpace);
            } else {
                uiFormInfo.setValue((Object)hiddenSpace);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangePriorityActionListener
    extends EventListener<UISpaceAddForm> {
        private final String HIGH_PRIORITY_LABEL = "UISpaceSettings.label.HighPrio";
        private final String INTERMEDIATE_PRIORITY_LABEL = "UISpaceSettings.label.InterMePrio";
        private final String LOW_PRIORITY_LABEL = "UISpaceSettings.label.lowPrio";

        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String highPrio = resApp.getString("UISpaceSettings.label.HighPrio");
            String interMePrio = resApp.getString("UISpaceSettings.label.InterMePrio");
            String lowPrio = resApp.getString("UISpaceSettings.label.lowPrio");
            Space space = new Space();
            uiSpaceAddForm.invokeSetBindingBean(space);
            UIFormInputSet uiSpaceSettings = (UIFormInputSet)uiSpaceAddForm.getChildById("UISpaceSettings");
            UIFormInputInfo uiFormInfo = (UIFormInputInfo)uiSpaceSettings.getChild(UIFormInputInfo.class);
            int selectedValue = Integer.parseInt(space.getPriority());
            switch (selectedValue) {
                case 1: {
                    uiFormInfo.setValue((Object)highPrio);
                    break;
                }
                case 2: {
                    uiFormInfo.setValue((Object)interMePrio);
                    break;
                }
                case 3: {
                    uiFormInfo.setValue((Object)lowPrio);
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ToggleUseGroupActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiSpaceAddForm = (UISpaceAddForm)((Object)event.getSource());
            UISpaceGroupBound uiSpaceGroupBound = (UISpaceGroupBound)uiSpaceAddForm.getChild(UISpaceGroupBound.class);
            UIFormCheckBoxInput uiUseExistingGroup = (UIFormCheckBoxInput)uiSpaceGroupBound.getChild(UIFormCheckBoxInput.class);
            if (uiUseExistingGroup.isChecked()) {
                UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceGroupBound.getChild(UIPopupWindow.class);
                UISocialGroupSelector uiGroupSelector = (UISocialGroupSelector)uiSpaceAddForm.createUIComponent(UISocialGroupSelector.class, null, null);
                uiPopup.setUIComponent((UIComponent)uiGroupSelector);
                uiPopup.setShowMask(true);
                uiPopup.setShow(true);
            } else {
                UIFormInputInfo uiFormInputInfo = (UIFormInputInfo)uiSpaceGroupBound.getChild(UIFormInputInfo.class);
                uiFormInputInfo.setValue(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CreateActionListener
    extends EventListener<UISpaceAddForm> {
        public void execute(Event<UISpaceAddForm> event) throws Exception {
            UISpaceAddForm uiAddForm = (UISpaceAddForm)((Object)event.getSource());
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApplication = ctx.getUIApplication();
            SpaceService spaceService = (SpaceService)uiAddForm.getApplicationComponent(SpaceService.class);
            UISpaceGroupBound uiGroupBound = (UISpaceGroupBound)uiAddForm.getChild(UISpaceGroupBound.class);
            String selectedGroup = uiGroupBound.getSelectedGroup();
            String creator = ctx.getRemoteUser();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            Space space = new Space();
            uiAddForm.invokeSetBindingBean(space);
            space.setDisplayName(space.getDisplayName().trim());
            String spaceDescription = space.getDescription();
            if (spaceDescription == null || spaceDescription.trim().length() == 0) {
                space.setDescription(resApp.getString(UISpaceAddForm.MSG_DEFAULT_SPACE_DESCRIPTION));
            } else {
                space.setDescription(StringEscapeUtils.escapeHtml((String)spaceDescription));
            }
            String msg = UISpaceAddForm.MSG_SPACE_CREATION_SUCCESS;
            try {
                SpaceUtils.checkUserExisting((String)ctx.getRemoteUser());
                if (spaceService.getSpaceByPrettyName(space.getPrettyName()) != null) {
                    throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
                }
                space.setType("classic");
                space = selectedGroup != null ? spaceService.createSpace(space, creator, selectedGroup) : spaceService.createSpace(space, creator);
            }
            catch (SpaceException se) {
                if (se.getCode() == SpaceException.Code.SPACE_ALREADY_EXIST) {
                    msg = UISpaceAddForm.MSG_ERROR_SPACE_ALREADY_EXIST;
                    uiApplication.addMessage(new ApplicationMessage(msg, null, 1));
                    return;
                }
                msg = se.getCode() == SpaceException.Code.UNABLE_TO_ADD_CREATOR ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_ADD_CREATOR : (se.getCode() == SpaceException.Code.ERROR_DATASTORE ? UISpaceAddForm.MSG_ERROR_DATASTORE : (se.getCode() == SpaceException.Code.UNABLE_TO_INIT_APP ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_INIT_APP : (se.getCode() == SpaceException.Code.UNABLE_TO_ADD_APPLICATION ? UISpaceAddForm.MSG_ERROR_UNABLE_TO_ADD_APPLICATION : (se.getCode() == SpaceException.Code.ERROR_RETRIEVING_USER ? UISpaceAddForm.MSG_ERROR_RETRIEVING_USER : UISpaceAddForm.MSG_ERROR_SPACE_CREATION))));
                LOG.error((Object)"Failed to create a new space", (Throwable)se);
                uiApplication.addMessage(new ApplicationMessage(msg, null, 0));
                return;
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiAddForm.getParent();
            uiPopup.setShow(false);
            Utils.updateWorkingWorkSpace();
            SpaceUtils.endRequest();
            JavascriptManager jsManager = ctx.getJavascriptManager();
            jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(space) + "' } catch(e) {" + "window.location.href('" + Utils.getSpaceHomeURL(space) + "') }"));
        }
    }
}

