/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.dom.CSSCharsetRuleImpl;
import com.steadystate.css.dom.CSSFontFaceRuleImpl;
import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSMediaRuleImpl;
import com.steadystate.css.dom.CSSOMObject;
import com.steadystate.css.dom.CSSPageRuleImpl;
import com.steadystate.css.dom.CSSRuleListImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.CSSUnknownRuleImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.MediaListImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.AbstractSACParser;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.SACParserCSS2;
import com.steadystate.css.sac.DocumentHandlerExt;
import com.steadystate.css.userdata.UserDataConstants;
import java.io.IOException;
import java.util.Properties;
import java.util.Stack;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.helpers.ParserFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

public class CSSOMParser {
    private static final String PARSER = "com.steadystate.css.parser.SACParserCSS2";
    private static boolean use_internal = false;
    private Parser _parser = null;
    private CSSStyleSheetImpl _parentStyleSheet = null;

    public CSSOMParser() {
        try {
            if (use_internal) {
                this._parser = new SACParserCSS2();
            } else {
                CSSOMParser.setProperty("org.w3c.css.sac.parser", PARSER);
                ParserFactory factory = new ParserFactory();
                this._parser = factory.makeParser();
            }
        }
        catch (Exception e) {
            use_internal = true;
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.err.println("using the default parser instead");
            this._parser = new SACParserCSS2();
        }
    }

    public CSSOMParser(Parser parser) {
        this._parser = parser;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this._parser.setErrorHandler(eh);
    }

    public CSSStyleSheet parseStyleSheet(InputSource source, Node ownerNode, String href) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        handler.setOwnerNode(ownerNode);
        handler.setHref(href);
        this._parser.setDocumentHandler((DocumentHandler)handler);
        this._parser.parseStyleSheet(source);
        Object o = handler.getRoot();
        if (o instanceof CSSStyleSheet) {
            return (CSSStyleSheet)handler.getRoot();
        }
        return null;
    }

    public CSSStyleDeclaration parseStyleDeclaration(InputSource source) throws IOException {
        CSSStyleDeclarationImpl sd = new CSSStyleDeclarationImpl(null);
        this.parseStyleDeclaration(sd, source);
        return sd;
    }

    public void parseStyleDeclaration(CSSStyleDeclaration sd, InputSource source) throws IOException {
        Stack<CSSStyleDeclaration> nodeStack = new Stack<CSSStyleDeclaration>();
        nodeStack.push(sd);
        CSSOMHandler handler = new CSSOMHandler(nodeStack);
        this._parser.setDocumentHandler((DocumentHandler)handler);
        this._parser.parseStyleDeclaration(source);
    }

    public CSSValue parsePropertyValue(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this._parser.setDocumentHandler((DocumentHandler)handler);
        return new CSSValueImpl(this._parser.parsePropertyValue(source));
    }

    public CSSRule parseRule(InputSource source) throws IOException {
        CSSOMHandler handler = new CSSOMHandler();
        this._parser.setDocumentHandler((DocumentHandler)handler);
        this._parser.parseRule(source);
        return (CSSRule)handler.getRoot();
    }

    public SelectorList parseSelectors(InputSource source) throws IOException {
        HandlerBase handler = new HandlerBase();
        this._parser.setDocumentHandler((DocumentHandler)handler);
        return this._parser.parseSelectors(source);
    }

    public void setParentStyleSheet(CSSStyleSheetImpl parentStyleSheet) {
        this._parentStyleSheet = parentStyleSheet;
    }

    protected CSSStyleSheetImpl getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public static void setProperty(String key, String val) {
        Properties props = System.getProperties();
        props.put(key, val);
        System.setProperties(props);
    }

    class CSSOMHandler
    implements DocumentHandlerExt {
        private Stack _nodeStack;
        private Object _root = null;
        private Node ownerNode;
        private String href;

        private Node getOwnerNode() {
            return this.ownerNode;
        }

        private void setOwnerNode(Node ownerNode) {
            this.ownerNode = ownerNode;
        }

        private String getHref() {
            return this.href;
        }

        private void setHref(String href) {
            this.href = href;
        }

        public CSSOMHandler(Stack nodeStack) {
            this._nodeStack = nodeStack;
        }

        public CSSOMHandler() {
            this._nodeStack = new Stack();
        }

        public Object getRoot() {
            return this._root;
        }

        public void startDocument(InputSource source) throws CSSException {
            if (this._nodeStack.empty()) {
                CSSStyleSheetImpl ss = new CSSStyleSheetImpl();
                CSSOMParser.this.setParentStyleSheet(ss);
                ss.setOwnerNode(this.getOwnerNode());
                ss.setBaseUri(source.getURI());
                ss.setHref(this.getHref());
                ss.setMediaText(source.getMedia());
                ss.setTitle(source.getTitle());
                CSSRuleListImpl rules = new CSSRuleListImpl();
                ss.setCssRules(rules);
                this._nodeStack.push(ss);
                this._nodeStack.push(rules);
            }
        }

        public void endDocument(InputSource source) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
            CSSUnknownRuleImpl ir = new CSSUnknownRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), atRule);
            this.addLocator(ir);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(ir);
            } else {
                this._root = ir;
            }
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void charset(String characterEncoding) throws CSSException {
            CSSCharsetRuleImpl cr = new CSSCharsetRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), characterEncoding);
            this.addLocator(cr);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(cr);
            } else {
                this._root = cr;
            }
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
            CSSImportRuleImpl ir = new CSSImportRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), uri, new MediaListImpl(media));
            this.addLocator(ir);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(ir);
            } else {
                this._root = ir;
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            MediaListImpl ml = new MediaListImpl(media);
            this.addLocator(ml);
            CSSMediaRuleImpl mr = new CSSMediaRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), ml);
            this.addLocator(mr);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(mr);
            }
            CSSRuleListImpl rules = new CSSRuleListImpl();
            mr.setRuleList(rules);
            this._nodeStack.push(mr);
            this._nodeStack.push(rules);
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            CSSPageRuleImpl pr = new CSSPageRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), name, pseudo_page);
            this.addLocator(pr);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(pr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(pr);
            pr.setStyle(decl);
            this._nodeStack.push(pr);
            this._nodeStack.push(decl);
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startFontFace() throws CSSException {
            CSSFontFaceRuleImpl ffr = new CSSFontFaceRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule());
            this.addLocator(ffr);
            if (!this._nodeStack.empty()) {
                ((CSSRuleListImpl)this._nodeStack.peek()).add(ffr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(ffr);
            ffr.setStyle(decl);
            this._nodeStack.push(ffr);
            this._nodeStack.push(decl);
        }

        public void endFontFace() throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            CSSStyleRuleImpl sr = new CSSStyleRuleImpl(CSSOMParser.this.getParentStyleSheet(), this.getParentRule(), selectors);
            this.addLocator(sr);
            if (!this._nodeStack.empty()) {
                Object o = this._nodeStack.peek();
                ((CSSRuleListImpl)o).add(sr);
            }
            CSSStyleDeclarationImpl decl = new CSSStyleDeclarationImpl(sr);
            sr.setStyle(decl);
            this._nodeStack.push(sr);
            this._nodeStack.push(decl);
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            this._nodeStack.pop();
            this._root = this._nodeStack.pop();
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            CSSStyleDeclarationImpl decl = (CSSStyleDeclarationImpl)this._nodeStack.peek();
            try {
                Property property = new Property(name, new CSSValueImpl(value), important);
                this.addLocator(property);
                decl.addProperty(property);
            }
            catch (DOMException e) {
                // empty catch block
            }
        }

        private CSSRule getParentRule() {
            Object node;
            if (!this._nodeStack.empty() && this._nodeStack.size() > 1 && (node = this._nodeStack.get(this._nodeStack.size() - 2)) instanceof CSSRule) {
                return (CSSRule)node;
            }
            return null;
        }

        private void addLocator(CSSOMObject cssomObject) {
            cssomObject.setUserData(UserDataConstants.KEY_LOCATOR, ((AbstractSACParser)CSSOMParser.this._parser).getLocator());
        }
    }
}

