/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.workflow.webui.component.controller;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.Task;
import org.exoplatform.services.workflow.WorkflowFormsService;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;
import org.exoplatform.workflow.webui.component.BJARResourceResolver;
import org.exoplatform.workflow.webui.component.InputInfo;
import org.exoplatform.workflow.webui.component.UISelectable;
import org.exoplatform.workflow.webui.component.VariableMaps;
import org.exoplatform.workflow.webui.component.controller.UITaskManager;
import org.exoplatform.workflow.webui.utils.LockUtil;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:templates/controller/UITask.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={StartProcessActionListener.class}), @EventConfig(listeners={EndOfStateActionListener.class}), @EventConfig(listeners={TransitionActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE)})
public class UITask
extends UIForm
implements UISelectable {
    public static final String MANAGE_TRANSITION = "manageTransition";
    private static final String TEXT = "text";
    private static final String TEXTAREA = "textarea";
    private static final String WYSIWYG = "wysiwyg";
    private static final String DATE = "date";
    private static final String DATE_TIME = "datetime";
    private static final String SELECT = "select";
    private static final String UPLOAD = "upload";
    private static final String CHECK_BOX = "checkbox";
    private static final String RADIO_BOX = "radiobox";
    private static final String NODE_VIEW = "nodeview";
    private static final String NODE_EDIT = "nodeedit";
    private static final String LABEL_ENCODING = ".label";
    private static final String NODE_PATH_VARIABLE = "nodePath";
    private static final String WORKSPACE_VARIABLE = "srcWorkspace";
    private static final String REPOSITORY_VARIABLE = "repository";
    private static final String DEST_PATH = "exo:destPath";
    private static final String DEST_WORKSPACE = "exo:destWorkspace";
    private static final String DELEGATE_FIELD = "delegator";
    private Form form;
    private boolean isStart_;
    private String identification_;
    private WorkflowServiceContainer serviceContainer = (WorkflowServiceContainer)this.getApplicationComponent(WorkflowServiceContainer.class);
    private WorkflowFormsService formsService = (WorkflowFormsService)this.getApplicationComponent(WorkflowFormsService.class);
    private RepositoryService jcrService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
    private List<InputInfo> inputInfo_ = new ArrayList<InputInfo>();
    private static final Log LOG = ExoLogger.getExoLogger(UITask.class);

    public String getTemplate() {
        if (this.isCustomizedView()) {
            return this.getIdentification() + ":/" + this.getCustomizedView();
        }
        return this.getComponentConfig().getTemplate();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.isCustomizedView()) {
            return new BJARResourceResolver(this.serviceContainer);
        }
        return super.getTemplateResourceResolver(context, this.getComponentConfig().getTemplate());
    }

    public String getManageTransition() {
        return MANAGE_TRANSITION;
    }

    public String getStateImageURL() {
        try {
            Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
            if (this.isStart()) {
                Process process = this.serviceContainer.getProcess(this.identification_);
                this.form = this.formsService.getForm(this.identification_, process.getStartStateName(), locale);
            } else {
                Task task = this.serviceContainer.getTask(this.identification_);
                this.form = this.formsService.getForm(task.getProcessId(), task.getTaskName(), locale);
            }
            return this.form.getStateImageURL();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void updateUITree() throws Exception {
        this.clean();
        UITaskManager uiTaskManager = (UITaskManager)this.getParent();
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        Map variablesForService = new HashMap();
        if (this.isStart_) {
            Process process = this.serviceContainer.getProcess(this.identification_);
            this.form = this.formsService.getForm(this.identification_, process.getStartStateName(), locale);
        } else {
            Task task = this.serviceContainer.getTask(this.identification_);
            String processInstanceId = task.getProcessInstanceId();
            variablesForService = this.serviceContainer.getVariables(processInstanceId, this.identification_);
            this.form = this.formsService.getForm(task.getProcessId(), task.getTaskName(), locale);
        }
        String workspaceName = (String)variablesForService.get(WORKSPACE_VARIABLE);
        String repository = (String)variablesForService.get(REPOSITORY_VARIABLE);
        if (repository == null) {
            repository = this.jcrService.getCurrentRepository().getConfiguration().getName();
        }
        ManageableRepository mRepository = this.jcrService.getCurrentRepository();
        SessionProviderService sessionProviderService = (SessionProviderService)Util.getUIPortal().getApplicationComponent(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        List variables = this.form.getVariables();
        UIFormStringInput input = null;
        int i = 0;
        for (Map attributes : variables) {
            String nodePath;
            String name = (String)attributes.get("name");
            String component = (String)attributes.get("component");
            String editableString = (String)attributes.get("editable");
            boolean editable = true;
            if (editableString != null && !"".equals(editableString)) {
                editable = new Boolean(editableString);
            }
            boolean mandatory = false;
            String mandatoryString = (String)attributes.get("mandatory");
            if (mandatoryString != null && !"".equals(mandatoryString)) {
                mandatory = new Boolean(mandatoryString);
            }
            boolean visiable = true;
            String visiableString = (String)attributes.get("visiable");
            if (visiableString != null && !"".equals(visiableString)) {
                visiable = new Boolean(visiableString);
            }
            Object value = variablesForService.get(name);
            if (NODE_EDIT.equals(component)) {
                nodePath = (String)variablesForService.get(NODE_PATH_VARIABLE);
                Node dialogNode = (Node)sessionProvider.getSession(workspaceName, mRepository).getItem(nodePath);
                String nodetype = dialogNode.getPrimaryNodeType().getName();
                try {
                    Class<?> clazz = Class.forName("org.exoplatform.contentvalidation.webui.UIDocumentForm");
                    UIComponent uiComponent = this.createUIComponent(clazz, null, null);
                    Method[] methods = clazz.getDeclaredMethods();
                    int count = 0;
                    for (Method m : methods) {
                        if (m.getName().trim().equals("setNodePath")) {
                            m.invoke((Object)uiComponent, nodePath);
                            ++count;
                        } else if (m.getName().trim().equals("setTemplateNode")) {
                            m.invoke((Object)uiComponent, nodetype);
                            ++count;
                        } else if (m.getName().trim().equals("setRepositoryName")) {
                            m.invoke((Object)uiComponent, repository);
                            ++count;
                        } else if (m.getName().trim().equals("setWorkspace")) {
                            m.invoke((Object)uiComponent, workspaceName);
                            ++count;
                        }
                        if (count == 4) break;
                    }
                    Task task = this.serviceContainer.getTask(this.identification_);
                    this.form = this.formsService.getForm(task.getProcessId(), task.getTaskName(), locale);
                    uiTaskManager.addChild(uiComponent);
                    uiComponent.setRendered(false);
                }
                catch (ClassNotFoundException e) {}
            } else if (NODE_VIEW.equals(component)) {
                nodePath = (String)variablesForService.get(NODE_PATH_VARIABLE);
                Node viewNode = (Node)sessionProvider.getSession(workspaceName, mRepository).getItem(nodePath);
                try {
                    Method[] methods;
                    Class<?> clazz = Class.forName("org.exoplatform.contentvalidation.webui.UIDocumentContent");
                    UIComponent uiComponent = this.createUIComponent(clazz, null, null);
                    for (Method m : methods = clazz.getDeclaredMethods()) {
                        if (!m.getName().trim().equals("setNode")) continue;
                        m.invoke((Object)uiComponent, viewNode);
                        break;
                    }
                    uiTaskManager.addChild(uiComponent);
                    uiComponent.setRendered(false);
                }
                catch (ClassNotFoundException e) {}
            } else {
                String property;
                String baseKey;
                if (component == null || TEXT.equals(component)) {
                    input = new UIFormStringInput(name, (String)value);
                    input.setEditable(editable);
                } else if (TEXTAREA.equals(component)) {
                    input = new UIFormTextAreaInput(name, null, (String)value);
                    ((UIFormTextAreaInput)input).setEditable(editable);
                } else if (WYSIWYG.equals(component)) {
                    input = new UIFormWYSIWYGInput(name, name, (String)value);
                    ((UIFormWYSIWYGInput)input).setToolBarName(UIFormWYSIWYGInput.DEFAULT_TOOLBAR);
                    ((UIFormWYSIWYGInput)input).setEditable(editable);
                } else if (DATE.equals(component) || DATE_TIME.equals(component)) {
                    if (value == null) {
                        input = new UIFormDateTimeInput(name, null, new Date(), DATE_TIME.equals(component));
                    } else if (value instanceof String) {
                        if (value.toString().length() > 0) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                            input = new UIFormDateTimeInput(name, null, dateFormat.parse(value.toString()), DATE_TIME.equals(component));
                        } else {
                            input = new UIFormDateTimeInput(name, null, new Date(), DATE_TIME.equals(component));
                        }
                    } else {
                        input = new UIFormDateTimeInput(name, null, (Date)value, DATE_TIME.equals(component));
                    }
                    if (!visiable) {
                        input.setValue((Object)"");
                    }
                    input.addValidator(DateTimeValidator.class, new Object[0]);
                } else if (SELECT.equals(component)) {
                    ArrayList<SelectItemOption> options;
                    block65: {
                        baseKey = name + ".select-";
                        String baseKeyValue = name + ".valueselect-";
                        options = new ArrayList<SelectItemOption>();
                        int j = 0;
                        String select0 = (String)variablesForService.get(baseKey + j);
                        if (select0 == null) {
                            ResourceBundle bundle = this.form.getResourceBundle();
                            while (true) {
                                String property2 = null;
                                String propertyValue = null;
                                try {
                                    property2 = bundle.getString(baseKey + j);
                                    propertyValue = bundle.getString(baseKeyValue + j);
                                }
                                catch (MissingResourceException e) {
                                    // empty catch block
                                }
                                if (property2 != null) {
                                    if (propertyValue != null && propertyValue.length() != 0) {
                                        options.add(new SelectItemOption(property2, (Object)propertyValue));
                                    } else {
                                        options.add(new SelectItemOption(property2, (Object)property2));
                                    }
                                    ++j;
                                    continue;
                                }
                                break block65;
                                break;
                            }
                        }
                        while (true) {
                            property = (String)variablesForService.get(baseKey + j);
                            String propertyValue = (String)variablesForService.get(baseKeyValue + j);
                            if (property == null) break;
                            if (propertyValue != null && propertyValue.length() != 0) {
                                options.add(new SelectItemOption(property, (Object)propertyValue));
                            } else {
                                options.add(new SelectItemOption(property, (Object)property));
                            }
                            ++j;
                        }
                    }
                    input = new UIFormSelectBox(name, (String)value, options);
                    ((UIFormSelectBox)input).setEditable(editable);
                } else if (CHECK_BOX.equals(component)) {
                    ResourceBundle bundle = this.form.getResourceBundle();
                    String key = name + ".checkbox";
                    input = value instanceof Boolean ? new UIFormCheckBoxInput(name, bundle.getString(key), (Object)((Boolean)value)) : new UIFormCheckBoxInput(name, bundle.getString(key), (Object)Boolean.valueOf((String)value));
                    ((UIFormCheckBoxInput)input).setEditable(editable);
                } else if (UPLOAD.equals(component)) {
                    input = new UIFormUploadInput(name, name);
                } else if (RADIO_BOX.equals(component)) {
                    baseKey = name + ".radiobox-";
                    ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
                    int j = 0;
                    String select0 = (String)variablesForService.get(baseKey + j);
                    if (select0 == null) {
                        ResourceBundle bundle = this.form.getResourceBundle();
                        try {
                            while (true) {
                                property = bundle.getString(baseKey + j);
                                options.add(new SelectItemOption(property, (Object)property));
                                ++j;
                            }
                        }
                        catch (MissingResourceException e) {}
                    } else {
                        String property3;
                        while ((property3 = (String)variablesForService.get(baseKey + j)) != null) {
                            options.add(new SelectItemOption(property3, (Object)property3));
                            ++j;
                        }
                    }
                    input = new UIFormRadioBoxInput(name, (String)value, options);
                }
                ResourceBundle res = this.form.getResourceBundle();
                String inputName = name;
                try {
                    inputName = res.getString(name + LABEL_ENCODING);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.inputInfo_.add(new InputInfo("", "", inputName, (UIFormInput)input, mandatory));
                if (mandatory) {
                    input.addValidator(MandatoryValidator.class, new Object[0]);
                }
                this.addUIFormInput((UIFormInput)input);
            }
            ++i;
        }
    }

    public void setIsStart(boolean b) {
        this.isStart_ = b;
    }

    public boolean isStart() {
        return this.isStart_;
    }

    public ResourceBundle getWorkflowBundle() {
        return this.form.getResourceBundle();
    }

    public List getInputInfo() {
        return this.inputInfo_;
    }

    public List getSubmitButtons() {
        return this.form.getSubmitButtons();
    }

    public boolean isCustomizedView() {
        return this.form.isCustomizedView();
    }

    public String getCustomizedView() {
        return this.form.getCustomizedView();
    }

    public void setIdentification(String identification) {
        this.identification_ = identification;
    }

    public String getIdentification() {
        return this.identification_;
    }

    public VariableMaps prepareVariables(String decision) throws Exception {
        VariableMaps maps = this.prepareWorkflowVariables(this.getChildren(), decision);
        return maps;
    }

    public VariableMaps prepareWorkflowVariables(Collection inputs, String decision) throws Exception {
        HashMap map;
        String variable;
        HashMap<String, Object> workflowVariables = new HashMap<String, Object>();
        HashMap jcrVariables = new HashMap();
        String name = "";
        for (UIFormInput input : inputs) {
            name = input.getName();
            Object value = "";
            if (input instanceof UIFormStringInput) {
                value = ((UIFormStringInput)input).getValue();
            } else if (input instanceof UIFormDateTimeInput) {
                Calendar calendar = ((UIFormDateTimeInput)input).getCalendar();
                value = calendar == null ? (name.equals("startDate") ? new GregorianCalendar().getTime() : "") : calendar.getTime();
            } else if (input instanceof UIFormWYSIWYGInput) {
                value = ((UIFormWYSIWYGInput)input).getValue();
            } else if (input instanceof UIFormTextAreaInput) {
                value = ((UIFormTextAreaInput)input).getValue();
            } else if (input instanceof UIFormCheckBoxInput) {
                value = new Boolean(((UIFormCheckBoxInput)input).isChecked()).toString();
            } else if (input instanceof UIFormSelectBox) {
                value = ((UIFormSelectBox)input).getValue();
            } else if (input instanceof UIFormRadioBoxInput) {
                value = ((UIFormRadioBoxInput)input).getValue();
            } else if (input instanceof UIFormUploadInput) {
                value = ((UIFormUploadInput)input).getUploadDataAsStream();
            }
            if (value == null) {
                value = "";
            }
            workflowVariables.put(name, value);
        }
        if (this.form.getSubmitButtons().size() > 0 && (variable = (String)(map = (HashMap)this.form.getSubmitButtons().get(0)).get("variable")) != null && variable.length() != 0) {
            workflowVariables.put(variable, decision);
        }
        if ("delegate".equals(decision)) {
            workflowVariables.put("delegate", "true");
        }
        String repository = this.jcrService.getCurrentRepository().getConfiguration().getName();
        workflowVariables.put(REPOSITORY_VARIABLE, repository);
        return new VariableMaps(workflowVariables, jcrVariables);
    }

    public void clean() {
        UITaskManager uiTaskManager = (UITaskManager)this.getParent();
        try {
            Class<?> clazz1 = Class.forName("org.exoplatform.contentvalidation.webui.UIDocumentForm");
            Class<?> clazz2 = Class.forName("org.exoplatform.contentvalidation.webui.UIDocumentContent");
            uiTaskManager.removeChild(clazz2);
            uiTaskManager.removeChild(clazz1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.inputInfo_.clear();
    }

    private Node getAction(Node node, String actionName) throws Exception {
        if (node.hasNode("exo:actions/" + actionName)) {
            return node.getNode("exo:actions/" + actionName);
        }
        return null;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        for (UIComponent uiInput : this.getChildren()) {
            if (!((UIFormInput)uiInput).getName().equals(selectField)) continue;
            ((UIFormStringInput)uiInput).setValue((Object)value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectUserActionListener
    extends EventListener<UITask> {
        public void execute(Event<UITask> event) throws Exception {
            UITask uiTask = (UITask)event.getSource();
            UITaskManager uiTaskManager = (UITaskManager)uiTask.getParent();
            uiTaskManager.initPopupSelectUser(UITask.DELEGATE_FIELD);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaskManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransitionActionListener
    extends EventListener<UITask> {
        public void execute(Event<UITask> event) throws Exception {
            UITask uiTask = (UITask)event.getSource();
            List submitButtons = uiTask.form.getSubmitButtons();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            VariableMaps maps = uiTask.prepareVariables(objectId);
            Task task = uiTask.serviceContainer.getTask(uiTask.identification_);
            String processInstanceId = task.getProcessInstanceId();
            Map variablesForService = uiTask.serviceContainer.getVariables(processInstanceId, uiTask.identification_);
            String nodePath = (String)variablesForService.get(UITask.NODE_PATH_VARIABLE);
            String srcPath = (String)variablesForService.get("srcPath");
            String srcWorkspace = (String)variablesForService.get(UITask.WORKSPACE_VARIABLE);
            RepositoryService repositoryService = (RepositoryService)uiTask.getApplicationComponent(RepositoryService.class);
            if (objectId.equals("delegate")) {
                String delegate = (String)maps.getWorkflowVariables().get(UITask.DELEGATE_FIELD);
                UIApplication uiApp = (UIApplication)((UITask)event.getSource()).getAncestorOfType(UIApplication.class);
                if (delegate.length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UITask.msg.has-not-got-delegate", null, 1));
                    return;
                }
                OrganizationService organizationService = (OrganizationService)uiTask.getApplicationComponent(OrganizationService.class);
                if (organizationService.getUserHandler().findUserByName(delegate) == null) {
                    uiApp.addMessage(new ApplicationMessage("UITask.msg.user-not-exist", null, 1));
                    return;
                }
            }
            SessionProviderService sessionProviderService = (SessionProviderService)Util.getUIPortal().getApplicationComponent(SessionProviderService.class);
            SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
            for (Map attributes : submitButtons) {
                String name = (String)attributes.get("name");
                if (!objectId.equals(name)) continue;
                String transition = (String)attributes.get("transition");
                try {
                    Session session;
                    Node node;
                    if (nodePath != null && (node = (Node)(session = sessionProvider.getSession(srcWorkspace, repositoryService.getCurrentRepository())).getItem(nodePath)).isLocked() && node.hasProperty(UITask.DEST_PATH) && node.hasProperty(UITask.DEST_WORKSPACE)) {
                        String actionName = (String)variablesForService.get("actionName");
                        Node actionNode = uiTask.getAction((Node)session.getItem(srcPath), actionName);
                        String destPath = actionNode.getProperty(UITask.DEST_PATH).getString() + nodePath.substring(nodePath.lastIndexOf("/"));
                        String destWorkspace = actionNode.getProperty(UITask.DEST_WORKSPACE).getString();
                        Session desSession = sessionProvider.getSession(destWorkspace, repositoryService.getCurrentRepository());
                        Node destNode = (Node)desSession.getItem(destPath);
                        LockUtil.changeLockToken(nodePath, destNode);
                    }
                    Map variables = maps.getWorkflowVariables();
                    uiTask.serviceContainer.endTask(uiTask.identification_, variables, transition);
                    ((UIPopupContainer)uiTask.getAncestorOfType(UIPopupContainer.class)).deActivate();
                    return;
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITask> {
        public void execute(Event<UITask> event) throws Exception {
            UIPopupContainer uiPopup = (UIPopupContainer)((UITask)event.getSource()).getAncestorOfType(UIPopupContainer.class);
            uiPopup.deActivate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EndOfStateActionListener
    extends EventListener<UITask> {
        public void execute(Event<UITask> event) throws Exception {
            UITask uiTask = (UITask)event.getSource();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            VariableMaps maps = uiTask.prepareVariables(objectId);
            try {
                Map variables = maps.getWorkflowVariables();
                uiTask.serviceContainer.endTask(uiTask.identification_, variables);
            }
            catch (Exception ex) {
                LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            ((UIPopupContainer)uiTask.getAncestorOfType(UIPopupContainer.class)).deActivate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StartProcessActionListener
    extends EventListener<UITask> {
        public void execute(Event<UITask> event) throws Exception {
            UITask uiTask = (UITask)event.getSource();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            String remoteUser = pcontext.getRemoteUser();
            if (remoteUser == null) {
                remoteUser = "anonymous";
            }
            VariableMaps maps = uiTask.prepareVariables(objectId);
            Map variables = maps.getWorkflowVariables();
            uiTask.serviceContainer.startProcess(remoteUser, uiTask.identification_, variables);
            ((UIPopupContainer)uiTask.getAncestorOfType(UIPopupContainer.class)).deActivate();
        }
    }
}

