/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeCreateChild;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeWorkingArea;
import org.exoplatform.ecm.webui.tree.UINodeTree;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyTree.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UITaxonomyTreeBrowser
extends UIContainer {
    private NodeLocation currentNode_;
    private NodeLocation rootNode_ = null;
    private String rootPath_;
    private String[] acceptedNodeTypes = new String[0];

    public UITaxonomyTreeBrowser() throws Exception {
        UINodeTree tree = (UINodeTree)this.addChild(UINodeTree.class, null, "UITaxonomyTreeBrowser");
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
    }

    public void update() throws Exception {
        UITaxonomyTreeCreateChild uiManager = (UITaxonomyTreeCreateChild)this.getParent();
        this.rootNode_ = NodeLocation.getNodeLocationByNode((Node)uiManager.getRootNode());
        this.rootPath_ = this.rootNode_.getPath();
    }

    public Node getRootNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.rootNode_);
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public boolean matchNodeType(Node node) throws Exception {
        if (this.acceptedNodeTypes == null || this.acceptedNodeTypes.length == 0) {
            return true;
        }
        for (String nodeType : this.acceptedNodeTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        Object children = null;
        UITaxonomyTreeCreateChild uiManager = (UITaxonomyTreeCreateChild)this.getParent();
        ArrayList<Node> taxonomyList = new ArrayList<Node>();
        if (this.rootNode_ == null) {
            this.update();
            this.currentNode_ = this.rootNode_;
            children = this.getRootNode().getNodes();
            this.changeNode(this.getRootNode());
        }
        UINodeTree tree = (UINodeTree)this.getChildById("UITaxonomyTreeBrowser");
        Node nodeSelected = this.getSelectedNode();
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            children = nodeSelected.getNodes();
        }
        tree.setSelected((Object)nodeSelected);
        if (nodeSelected.getDepth() > 0) {
            tree.setParentSelected((Object)nodeSelected.getParent());
            sibbling = nodeSelected.getParent().getNodes();
            children = nodeSelected.getNodes();
        } else {
            tree.setParentSelected((Object)nodeSelected);
            sibbling = nodeSelected.getNodes();
        }
        ArrayList<Node> sibblingList = new ArrayList<Node>();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        if (nodeSelected.getPath().equals(uiManager.getTaxonomyTreeNode().getPath())) {
            sibbling = nodeSelected.getNodes();
        }
        while (sibbling.hasNext()) {
            Node sibblingNode = (Node)sibbling.next();
            if (!this.matchNodeType(sibblingNode) || !PermissionUtil.canRead((Node)sibblingNode) || sibblingNode.isNodeType("exo:hiddenable")) continue;
            sibblingList.add(sibblingNode);
        }
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            taxonomyList.add(uiManager.getTaxonomyTreeNode());
            children = taxonomyList.iterator();
        }
        if (children != null) {
            while (children.hasNext()) {
                Node childrenNode = (Node)children.next();
                if (!this.matchNodeType(childrenNode) || !PermissionUtil.canRead((Node)childrenNode) || childrenNode.isNodeType("exo:hiddenable")) continue;
                childrenList.add(childrenNode);
            }
        }
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            tree.setSibbling(childrenList);
        } else {
            tree.setSibbling(sibblingList);
        }
        tree.setChildren(childrenList);
    }

    public void renderChildren() throws Exception {
        this.buildTree();
        super.renderChildren();
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setNodeSelect(String path) throws Exception {
        UITaxonomyTreeCreateChild uiManager = (UITaxonomyTreeCreateChild)this.getParent();
        this.currentNode_ = NodeLocation.getNodeLocationByNode((Node)uiManager.getNodeByPath(path));
        if (!this.rootNode_.getPath().equals("/") && this.getRootNode().getParent().getPath().equals(path)) {
            this.currentNode_ = this.rootNode_;
        }
        uiManager.setSelectedPath(this.currentNode_.getPath());
        this.changeNode(NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_));
    }

    public void changeNode(Node nodeSelected) throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator nodeIter = nodeSelected.getNodes();
        ArrayList<Node> rootTaxonomyList = new ArrayList<Node>();
        UITaxonomyTreeCreateChild uiTaxonomyManager = (UITaxonomyTreeCreateChild)this.getParent();
        while (nodeIter.hasNext()) {
            nodes.add(nodeIter.nextNode());
        }
        if (nodeSelected.getPath().equals(this.rootPath_)) {
            rootTaxonomyList.add(uiTaxonomyManager.getTaxonomyTreeNode());
            nodes = rootTaxonomyList;
        }
        UITaxonomyTreeCreateChild uiManager = (UITaxonomyTreeCreateChild)this.getParent();
        UITaxonomyTreeWorkingArea uiTreeWorkingArea = (UITaxonomyTreeWorkingArea)uiManager.getChild(UITaxonomyTreeWorkingArea.class);
        ArrayList<Node> lstNode = new ArrayList<Node>();
        for (Node node : nodes) {
            if (!uiTreeWorkingArea.matchNodeType(node)) continue;
            lstNode.add(node);
        }
        uiTreeWorkingArea.setNodeList(lstNode);
        uiTreeWorkingArea.updateGrid();
    }

    public Node getSelectedNode() {
        if (this.currentNode_ == null) {
            return this.getRootNode();
        }
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode_);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UITaxonomyTreeBrowser> {
        public void execute(Event<UITaxonomyTreeBrowser> event) throws Exception {
            UITaxonomyTreeBrowser uiTaxonomyTreeBrowser = (UITaxonomyTreeBrowser)((Object)event.getSource());
            String uri = event.getRequestContext().getRequestParameter("objectId");
            uiTaxonomyTreeBrowser.setNodeSelect(uri);
            UITaxonomyTreeCreateChild uiTaxonomyTreeCreateChild = (UITaxonomyTreeCreateChild)uiTaxonomyTreeBrowser.getParent();
            uiTaxonomyTreeCreateChild.onChange(uiTaxonomyTreeBrowser.getSelectedNode());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyTreeCreateChild);
        }
    }
}

