/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.connection.impl;

import com.sun.mail.pop3.POP3Store;
import com.sun.mail.util.MailSSLSocketFactory;
import java.util.Properties;
import javax.mail.Session;
import org.exoplatform.mail.connection.impl.BaseConnector;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Utils;

public class Pop3Connector
extends BaseConnector {
    protected POP3Store pop3Store;

    public Pop3Connector(Account account, MailSSLSocketFactory sslSocket) throws Exception {
        Session session = this.getSession(account, sslSocket);
        String protocolName = "pop3";
        String emailAddr = account.getIncomingUser();
        if (Utils.isGmailAccount(emailAddr)) {
            protocolName = "pop3s";
        }
        this.store_ = session.getStore(protocolName);
        this.openStore(account);
        this.pop3Store = (POP3Store)this.store_;
    }

    public Session getSession(Account account, MailSSLSocketFactory sslSocket) throws Exception {
        Properties props = System.getProperties();
        props.put("mail.mime.base64.ignoreerrors", "true");
        props.put("mail.pop3.host", account.getIncomingHost());
        props.put("mail.pop3.user", account.getIncomingUser());
        props.put("mail.pop3.port", account.getIncomingPort());
        props.put("mail.pop3.auth", "true");
        props.put("mail.pop3.socketFactory.port", account.getIncomingPort());
        props.put("mail.pop3.socketFactory.class", "javax.net.SocketFactory");
        if (account.isIncomingSsl() && sslSocket != null) {
            props.put("mail.pop3.socketFactory.fallback", "false");
            props.put("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.put(Utils.POP3_SSL_FACTORY, sslSocket);
            if (account.getSecureAuthsIncoming().equalsIgnoreCase("starttls")) {
                props.put(Utils.POP3_SSL_STARTTLS_ENABLE, (Object)true);
            } else {
                props.put(Utils.MAIL_POP3_SSL_ENABLE, (Object)true);
            }
        }
        return Session.getInstance((Properties)props, null);
    }
}

