/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import javax.jcr.RepositoryException;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.mail.service.CheckingInfo;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class CheckMailJob
implements Job,
InterruptableJob {
    public static final String CHECKMAIL_GROUP = "CollaborationSuite-webmail";
    public static final String USERNAME = "userName";
    public static final String ACCOUNTID = "acountId";
    public static final String FOLDERID = "folderId";
    public static final String REPO_NAME = "repository";
    private static Log log = ExoLogger.getLogger((String)"cs.service.job");
    private String username;
    private String accountId;
    private String folderId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        SessionProviderService sessionProviderService;
        block33: {
            String currentRepo;
            RepositoryService repoService;
            MailService mailService;
            block30: {
                PortalContainer container = CheckMailJob.getPortalContainer(context);
                mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
                repoService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                currentRepo = null;
                JobDetail jobDetail = context.getJobDetail();
                JobDataMap dataMap = jobDetail.getJobDataMap();
                sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
                sessionProviderService.getSystemSessionProvider(null);
                try {
                    currentRepo = repoService.getCurrentRepository().getConfiguration().getName();
                }
                catch (RepositoryException e) {
                    log.warn((Object)"Can't get current repository name", (Throwable)e);
                }
                this.username = dataMap.getString(USERNAME);
                this.accountId = dataMap.getString(ACCOUNTID);
                this.folderId = dataMap.getString(FOLDERID);
                String repoName = dataMap.getString(REPO_NAME);
                if (repoName != null) {
                    try {
                        repoService.setCurrentRepositoryName(repoName);
                    }
                    catch (RepositoryConfigurationException ex) {
                        log.error((Object)String.format("Can't set current repository name as %s", repoName), (Throwable)ex);
                    }
                }
                if (this.username != null && this.accountId != null) {
                    mailService.checkNewMessage(this.username, this.accountId, this.folderId);
                }
                if (currentRepo == null) break block30;
                try {
                    repoService.setCurrentRepositoryName(currentRepo);
                }
                catch (RepositoryConfigurationException e) {
                    log.error((Object)String.format("Can't set current repository name as %s", currentRepo), (Throwable)e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished "));
            }
            break block33;
            catch (InterruptedException ie) {
                block31: {
                    log.warn((Object)"checking new mail message failed", (Throwable)ie);
                    this.getMailService().stopCheckMail(this.username, this.accountId);
                    if (currentRepo == null) break block31;
                    try {
                        repoService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        log.error((Object)String.format("Can't set current repository name as %s", currentRepo), (Throwable)e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished "));
                }
            }
            catch (Exception e) {
                block32: {
                    log.error((Object)"checking new mail message failed", (Throwable)e);
                    CheckingInfo info = null;
                    try {
                        info = mailService.getCheckingInfo(this.username, this.accountId);
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                    }
                    if (info != null) {
                        info.setStatusCode(102);
                        mailService.updateCheckingMailStatusByCometd(this.username, this.accountId, info);
                    }
                    if (currentRepo == null) break block32;
                    {
                        catch (Throwable throwable) {
                            if (currentRepo != null) {
                                try {
                                    repoService.setCurrentRepositoryName(currentRepo);
                                }
                                catch (RepositoryConfigurationException e2) {
                                    log.error((Object)String.format("Can't set current repository name as %s", currentRepo), (Throwable)e2);
                                }
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished "));
                            }
                            throw throwable;
                        }
                    }
                    try {
                        repoService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e3) {
                        log.error((Object)String.format("Can't set current repository name as %s", currentRepo), (Throwable)e3);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\n\n####  Checking mail of " + context.getJobDetail().getName() + " finished "));
                }
            }
        }
        try {
            sessionProviderService.removeSessionProvider(null);
        }
        catch (Exception e) {
            log.warn((Object)"An error occured while cleaning the ThreadLocal", (Throwable)e);
        }
    }

    private MailService getMailService() {
        MailService mailService = (MailService)PortalContainer.getInstance().getComponentInstanceOfType(MailService.class);
        return mailService;
    }

    private static String getJobName(String userId, String accountId) {
        return userId + ":" + accountId;
    }

    public static JobInfo getJobInfo(String userId, String accountId) {
        String name = CheckMailJob.getJobName(userId, accountId);
        JobInfo info = new JobInfo(name, CHECKMAIL_GROUP, CheckMailJob.class);
        info.setDescription("Check emails for user " + userId + " on acount " + accountId);
        return info;
    }

    public void interrupt() throws UnableToInterruptJobException {
        this.getMailService().stopCheckMail(this.username, this.accountId);
    }

    public static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = context.getJobDetail().getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(":") > 0) {
            portalName = portalName.substring(0, portalName.indexOf(":"));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }
}

