/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.common.webui.WebUIUtils;
import org.exoplatform.ks.ext.impl.BaseKSActivity;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ks/social-integration/plugin/space/AnswerUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={PostCommentActionListener.class})})
public class AnswerUIActivity
extends BaseKSActivity {
    protected void refresh() throws ActivityStorageException {
        block4: {
            super.refresh();
            if (this.isQuestionActivity()) {
                List comments = this.getAllComments();
                FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
                try {
                    Comment[] commentObjs;
                    for (Comment comment : commentObjs = faqService.getComments(this.getActivityParamValue("QuestionId"))) {
                        ExoSocialActivity act = this.toActivity(comment);
                        if (act == null) continue;
                        comments.add(act);
                    }
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)String.format("Failed to get comments of question: %s", this.getActivityParamValue("QuestionId")), (Throwable)e);
                }
            }
        }
    }

    private ExoSocialActivity toActivity(Comment comment) {
        ExoSocialActivityImpl activity = null;
        if (comment != null) {
            activity = new ExoSocialActivityImpl();
            IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            Identity userIdentity = identityM.getOrCreateIdentity("organization", comment.getCommentBy(), false);
            activity.setUserId(userIdentity.getId());
            activity.setTitle(comment.getComments());
            activity.setPostedTime(Long.valueOf(comment.getDateComment().getTime()));
            activity.setId(comment.getId());
        }
        return activity;
    }

    private String getTitle(WebuiBindingContext _ctx) throws Exception {
        String title = "";
        if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("QuestionAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.question-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("QuestionUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.question-update");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("AnswerAdd")) {
            title = _ctx.appRes("AnswerUIActivity.label.answer-add");
        } else if (this.getActivityParamValue("ActivityType").equalsIgnoreCase("AnswerUpdate")) {
            title = _ctx.appRes("AnswerUIActivity.label.answer-update");
        }
        title = StringUtils.replaceOnce((String)title, (String)"{0}", (String)this.getUriOfAuthor());
        title = StringUtils.replaceOnce((String)title, (String)"{1}", (String)new StringBuffer().append("<a href=").append(this.getActivityParamValue("Link")).append(">").append(this.getActivityParamValue("Name")).append("</a>").toString());
        return title;
    }

    public boolean isCommentDeletable(String activityUserId) throws SpaceException {
        return !this.isQuestionActivity() && super.isCommentDeletable(activityUserId);
    }

    public boolean isQuestionActivity() {
        String value = this.getActivityParamValue("ActivityType");
        return value.indexOf("Question") >= 0;
    }

    public static String getFullName(String userName) throws Exception {
        try {
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            User user = organizationService.getUserHandler().findUserByName(userName);
            String fullName = user.getFullName();
            if (fullName == null || fullName.trim().length() <= 0) {
                fullName = userName;
            }
            return fullName;
        }
        catch (Exception e) {
            return userName;
        }
    }

    public static String getLinkDiscuss(String topicId) throws Exception {
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        String link = portalContext.getRequest().getRequestURL().toString();
        String selectedNode = Util.getUIPortal().getSelectedUserNode().getURI();
        String portalName = "/" + Util.getUIPortal().getName();
        if (link.indexOf(portalName) > 0 && link.indexOf(portalName + "/" + selectedNode) < 0) {
            link = link.replaceFirst(portalName, portalName + "/" + selectedNode);
        }
        link = link.substring(0, link.indexOf(selectedNode) + selectedNode.length());
        link = link.replaceAll(selectedNode, "forum") + "/" + Utils.TOPIC + "/" + topicId;
        return link;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PostCommentActionListener
    extends BaseUIActivity.PostCommentActionListener {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            ForumService forumService;
            Topic topic;
            AnswerUIActivity uiActivity = (AnswerUIActivity)((Object)event.getSource());
            if (!uiActivity.isQuestionActivity()) {
                super.execute(event);
                return;
            }
            WebuiRequestContext context = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            if (message == null || message.trim().length() == 0) {
                context.getUIApplication().addMessage(new ApplicationMessage("AnswerUIActivity.msg.content-empty", null, 1));
                return;
            }
            FAQService faqService = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            Question question = faqService.getQuestionById(uiActivity.getActivityParamValue("QuestionId"));
            Comment comment = new Comment();
            comment.setNew(true);
            comment.setCommentBy(context.getRemoteUser());
            comment.setComments(message);
            comment.setFullName(AnswerUIActivity.getFullName(context.getRemoteUser()));
            comment.setDateComment(new Date());
            String topicId = question.getTopicIdDiscuss();
            if (topicId != null && topicId.length() > 0 && (topic = (Topic)(forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class)).getObjectNameById(topicId, Utils.TOPIC)) != null) {
                String remoteAddr = WebUIUtils.getRemoteIP();
                String[] ids = topic.getPath().split("/");
                int t = ids.length;
                String linkForum = AnswerUIActivity.getLinkDiscuss(topicId);
                String postId = comment.getPostId();
                if (postId == null || postId.length() == 0) {
                    Post post = new Post();
                    post.setOwner(context.getRemoteUser());
                    post.setIcon("ViewIcon");
                    post.setName("Re: " + question.getQuestion());
                    post.setMessage(comment.getComments());
                    post.setLink(linkForum);
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setRemoteAddr(remoteAddr);
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, true, new MessageBuilder());
                    comment.setPostId(post.getId());
                } else {
                    Post post = forumService.getPost(ids[t - 3], ids[t - 2], topicId, postId);
                    boolean isNew = false;
                    if (post == null) {
                        post = new Post();
                        isNew = true;
                        post.setOwner(context.getRemoteUser());
                        post.setIcon("ViewIcon");
                        post.setName("Re: " + question.getQuestion());
                        comment.setPostId(post.getId());
                        post.setLink(linkForum);
                        post.setRemoteAddr(remoteAddr);
                    } else {
                        post.setModifiedBy(context.getRemoteUser());
                    }
                    post.setIsApproved(!topic.getIsModeratePost());
                    post.setMessage(comment.getComments());
                    forumService.savePost(ids[t - 3], ids[t - 2], topicId, post, isNew, new MessageBuilder());
                }
            }
            faqService.saveComment(question.getPath(), comment, uiActivity.getActivityParamValue("Language"));
            ExoSocialActivity act = uiActivity.toActivity(comment);
            if (act != null) {
                uiActivity.getAllComments().add(act);
            }
            uiFormComment.reset();
            uiActivity.setCommentFormFocused(true);
            context.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

