/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.panel;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.macro.panel.PanelMacroParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="panel")
public class PanelMacro
extends AbstractMacro<PanelMacroParameters> {
    private static final String DESCRIPTION = "Embraces a block of text within a fully customizable panel";
    private static final String CONTENT_DESCRIPTION = "The content to put in the panel";
    private static final String PANEL_BLOCK = "panel";
    private static final String PANEL_HEADER_BLOCK = "panelHeader";
    private static final String PANEL_CONTENT_BLOCK = "panelContent";
    @Requirement
    private ComponentManager componentManager;

    public PanelMacro() {
        super("Panel", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), PanelMacroParameters.class);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(PanelMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (content != null) {
            LinkedHashMap<String, String> panelParameters = new LinkedHashMap<String, String>();
            panelParameters.put("class", PANEL_BLOCK);
            GroupBlock panelBlock = new GroupBlock(panelParameters);
            String titleParameter = parameters.getTitle();
            if (!StringUtils.isEmpty((String)titleParameter)) {
                LinkedHashMap<String, String> panelHeaderParameters = new LinkedHashMap<String, String>();
                panelHeaderParameters.put("class", PANEL_HEADER_BLOCK);
                GroupBlock panelHeaderBlock = new GroupBlock(panelHeaderParameters);
                Parser parser = this.getSyntaxParser(context);
                List<Block> titleBlocks = this.parseTitle(parser, titleParameter);
                panelHeaderBlock.addChildren(titleBlocks);
                panelBlock.addChild((Block)panelHeaderBlock);
            }
            LinkedHashMap<String, String> panelContentParameters = new LinkedHashMap<String, String>();
            panelContentParameters.put("class", PANEL_CONTENT_BLOCK);
            GroupBlock panelContentBlock = new GroupBlock(panelContentParameters);
            List<Block> contentBlocks = this.parseContent(parameters, content, context);
            panelContentBlock.addChildren(contentBlocks);
            panelBlock.addChild((Block)panelContentBlock);
            return Collections.singletonList(panelBlock);
        }
        return Collections.emptyList();
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected List<Block> parseTitle(Parser parser, String titleParameter) throws MacroExecutionException {
        try {
            List children;
            List titleBlocks = parser.parse((Reader)new StringReader(titleParameter)).getChildren();
            if (titleBlocks.size() == 1 && titleBlocks.get(0) instanceof ParagraphBlock && (children = ((Block)titleBlocks.get(0)).getChildren()).size() > 0) {
                titleBlocks = children;
            }
            return titleBlocks;
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse the box's title [" + titleParameter + "]", (Throwable)e);
        }
    }

    protected List<Block> parseContent(PanelMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.parseSourceSyntax(content, context);
    }

    protected List<Block> parseSourceSyntax(String content, MacroTransformationContext context) throws MacroExecutionException {
        Parser parser = this.getSyntaxParser(context);
        try {
            List blocks = parser.parse((Reader)new StringReader(content)).getChildren();
            if (context.isInline()) {
                ParserUtils parseUtils = new ParserUtils();
                parseUtils.removeTopLevelParagraph(blocks);
            }
            return blocks;
        }
        catch (ParseException e) {
            throw new MacroExecutionException("Failed to parse content [" + content + "] with Syntax parser [" + parser.getSyntax() + "]", (Throwable)e);
        }
    }

    protected Parser getSyntaxParser(MacroTransformationContext context) throws MacroExecutionException {
        try {
            return (Parser)this.getComponentManager().lookup(Parser.class, context.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException("Failed to find source parser for syntax [" + context.getSyntax() + "]", (Throwable)e);
        }
    }
}

