/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class MSSQLMultiDbJDBCConnection
extends MultiDbJDBCConnection {
    public static final String FIND_NODES_AND_PROPERTIES_TEMPLATE = "select J.*, P.ID AS P_ID, P.NAME AS P_NAME, P.VERSION AS P_VERSION, P.P_TYPE, P.P_MULTIVALUED, V.DATA, V.ORDER_NUM, V.STORAGE_DESC from JCR_MVALUE V WITH (INDEX (JCR_IDX_MVALUE_PROPERTY)), JCR_MITEM P  join (select TOP ${TOP} I.ID, I.PARENT_ID, I.NAME, I.VERSION, I.I_INDEX, I.N_ORDER_NUM from JCR_MITEM I WITH (INDEX (JCR_PK_MITEM)) where I.I_CLASS=1 AND I.ID > ? order by I.ID) J on P.PARENT_ID = J.ID where P.I_CLASS=2 and V.PROPERTY_ID=P.ID order by J.ID";

    public MSSQLMultiDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected void prepareQueries() throws SQLException {
        super.prepareQueries();
    }

    protected ResultSet findNodesAndProperties(String lastNodeId, int offset, int limit) throws SQLException {
        if (this.findNodesAndProperties != null) {
            this.findNodesAndProperties.close();
        }
        this.findNodesAndProperties = this.dbConnection.prepareStatement(FIND_NODES_AND_PROPERTIES_TEMPLATE.replace("${TOP}", new Integer(offset + limit).toString()));
        this.findNodesAndProperties.setString(1, this.getInternalId(lastNodeId));
        return this.findNodesAndProperties.executeQuery();
    }

    protected boolean needToSkipOffsetNodes() {
        return true;
    }

    protected String fixEscapeSymbols(String pattern) {
        char[] chars = pattern.toCharArray();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    sb.append('%');
                    continue block4;
                }
                case '%': 
                case '[': 
                case ']': 
                case '_': {
                    sb.append(this.getWildcardEscapeSymbold());
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }
}

