/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.internal.converter;

import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="enum")
public class EnumConverter
extends AbstractConverter {
    @Override
    protected <T> T convertToType(Class<T> type, Object value) {
        if (value != null) {
            Object[] enumValues = type.getEnumConstants();
            String testValue = value.toString();
            for (T t : enumValues) {
                if (!t.toString().equalsIgnoreCase(testValue)) continue;
                return type.cast(t);
            }
            throw new ConversionException(this.generateInvalidErrorMessage(enumValues, testValue));
        }
        return null;
    }

    private String generateInvalidErrorMessage(Object[] enumValues, String testValue) {
        StringBuffer errorMessage = new StringBuffer("Unable to convert value [" + testValue + "].");
        errorMessage.append(" Allowed values are (case insensitive) ");
        StringBuffer valueList = new StringBuffer();
        int index = 1;
        for (Object enumValue : enumValues) {
            if (valueList.length() > 0) {
                if (++index == enumValues.length) {
                    valueList.append(" or ");
                } else {
                    valueList.append(", ");
                }
            }
            valueList.append('\"');
            valueList.append(enumValue);
            valueList.append('\"');
        }
        errorMessage.append(valueList);
        errorMessage.append('.');
        return errorMessage.toString();
    }
}

