/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.rss.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEnclosureImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import com.totsp.xml.syndication.itunes.EntryInformationImpl;
import com.totsp.xml.syndication.itunes.FeedInformationImpl;
import com.totsp.xml.syndication.itunes.types.Category;
import com.totsp.xml.syndication.itunes.types.Duration;
import com.totsp.xml.syndication.itunes.types.Subcategory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.cms.rss.RSSService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RSSServiceImpl
implements RSSService {
    private static String SRC_WORKSPACE = "srcWorkspace";
    private static String RSS_VERSION = "exo:rssVersion";
    private static String FEED_TITLE = "exo:feedTitle";
    private static String FEED_TYPE = "exo:feedType";
    private static String DESCRIPTION = "exo:description";
    private static String STORE_PATH = "exo:storePath";
    private static String KEYWORDS = "exo:keywords";
    private static String TITLE = "exo:title";
    private static String LINK = "exo:link";
    private static String LANGUAGE = "exo:language";
    private static String COPYRIGHT = "exo:copyright";
    private static String PUBDATE = "exo:pubDate";
    private static String OWNER_NAME = "exo:ownerName";
    private static String OWNER_MAIL = "exo:ownerEmail";
    private static String IMAGE_URL = "exo:imageURL";
    private static String CATEGORY = "exo:podcastCategory";
    private static String PUBLISHED_DATE = "exo:publishedDate";
    private static String AUTHOR = "exo:author";
    private static String EXPLICIT = "exo:explicit";
    private static String FEED_NAME = "exo:feedName";
    private static String QUERY_PATH = "exo:queryPath";
    private static String URL = "exo:url";
    private static String SUMMARY = "exo:summary";
    private static String LENGTH = "exo:length";
    private static String JCR_CONTENT = "jcr:content";
    private static String JCR_DATA = "jcr:data";
    private static String JCR_MIMETYPE = "jcr:mimeType";
    private static String JCR_LASTMODIFIED = "jcr:lastModified";
    private static String NT_UNSTRUCTURED = "nt:unstructured";
    private static String NT_FILE = "nt:file";
    private static String NT_RESOURCE = "nt:resource";
    private static String MIX_VERSIONABLE = "mix:versionable";
    private RepositoryService repositoryService_;
    private static final Log LOG = ExoLogger.getLogger(RSSServiceImpl.class);

    public RSSServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator) {
        this.repositoryService_ = repositoryService;
    }

    public void generateFeed(Map context) {
        String feedType = (String)context.get(FEED_TYPE);
        if (feedType.equals("rss")) {
            this.generateRSS(context);
        } else if (feedType.equals("podcast") || feedType.equals("video podcast")) {
            this.generatePodcast(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateRSS(Map context) {
        Date pubDate;
        String actionName = (String)context.get("actionName");
        String srcWorkspace = (String)context.get(SRC_WORKSPACE);
        String rssVersion = (String)context.get(RSS_VERSION);
        String feedTitle = (String)context.get(FEED_TITLE);
        String summary = (String)context.get(SUMMARY);
        String feedType = (String)context.get(FEED_TYPE);
        String feedDescription = (String)context.get(DESCRIPTION);
        String storePath = (String)context.get(STORE_PATH) + "/" + feedType;
        String feedName = (String)context.get(FEED_NAME);
        String queryPath = (String)context.get(QUERY_PATH);
        String rssUrl = (String)context.get(URL);
        String title = (String)context.get(TITLE);
        String feedLink = (String)context.get(LINK);
        try {
            pubDate = ((GregorianCalendar)context.get(PUBDATE)).getTime();
        }
        catch (Exception e) {
            pubDate = new Date();
        }
        if (feedName == null || feedName.length() == 0) {
            feedName = actionName;
        }
        if (feedTitle == null || feedTitle.length() == 0) {
            feedTitle = actionName;
        }
        Session session = null;
        try {
            session = this.repositoryService_.getCurrentRepository().getSystemSession(srcWorkspace);
            session.refresh(true);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryPath, "sql");
            QueryResult queryResult = query.execute();
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssVersion);
            feed.setTitle(feedTitle.replaceAll("&nbsp;", " "));
            feed.setPublishedDate(pubDate);
            feed.setLink(feedLink);
            feed.setDescription(feedDescription.replaceAll("&nbsp;", " "));
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                if (!child.isNodeType("exo:rss-enable")) continue;
                String url = rssUrl + child.getPath();
                SyndEntryImpl entry = new SyndEntryImpl();
                try {
                    entry.setTitle(child.getProperty(title).getString());
                }
                catch (PathNotFoundException path) {
                    entry.setTitle("");
                }
                entry.setLink(url);
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                try {
                    if (child.hasProperty(summary)) {
                        description.setValue(child.getProperty(summary).getString().replaceAll("&nbsp;", " "));
                    }
                }
                catch (PathNotFoundException path) {
                    description.setValue("");
                }
                entry.setDescription((SyndContent)description);
                try {
                    Date udate = child.getProperty(PUBLISHED_DATE).getDate().getTime();
                    entry.setPublishedDate(udate);
                }
                catch (Exception e) {
                    entry.setPublishedDate(new Date());
                }
                entries.add(entry);
                entry.getEnclosures();
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, storePath, feedName);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePodcast(Map context) {
        Session session = null;
        try {
            Date pubDate;
            String actionName = (String)context.get("actionName");
            String srcWorkspace = (String)context.get(SRC_WORKSPACE);
            String feedTitle = (String)context.get(FEED_TITLE);
            String feedLink = (String)context.get(LINK);
            String feedType = (String)context.get(FEED_TYPE);
            String feedDescription = (String)context.get(DESCRIPTION);
            String language = (String)context.get(LANGUAGE);
            String copyright = (String)context.get(COPYRIGHT);
            String title = (String)context.get(TITLE);
            String summary = (String)context.get(SUMMARY);
            try {
                pubDate = ((GregorianCalendar)context.get(PUBDATE)).getTime();
            }
            catch (Exception e) {
                pubDate = new Date();
            }
            String ownerName = (String)context.get(OWNER_NAME);
            String ownerEmail = (String)context.get(OWNER_MAIL);
            String imageURL = (String)context.get(IMAGE_URL);
            String categories = (String)context.get(CATEGORY);
            String keywords = (String)context.get(KEYWORDS);
            String storePath = (String)context.get(STORE_PATH) + "/" + feedType;
            String feedName = (String)context.get(FEED_NAME);
            String rssVersion = (String)context.get(RSS_VERSION);
            String queryPath = (String)context.get(QUERY_PATH);
            String rssUrl = (String)context.get(URL);
            if (feedName == null || feedName.length() == 0) {
                feedName = actionName;
            }
            if (feedTitle == null || feedTitle.length() == 0) {
                feedTitle = actionName;
            }
            session = this.repositoryService_.getCurrentRepository().getSystemSession(srcWorkspace);
            session.refresh(true);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryPath, "sql");
            QueryResult queryResult = query.execute();
            SyndFeedImpl feed = new SyndFeedImpl();
            FeedInformationImpl infor = new FeedInformationImpl();
            infor.setExplicit(false);
            Category cat = new Category();
            if (categories != null && categories.length() > 0) {
                if (categories.indexOf(",") > -1) {
                    String[] arrCategories = categories.split(",");
                    cat.setName(arrCategories[0].trim());
                    for (int i = 1; i < arrCategories.length; ++i) {
                        Subcategory subCat = new Subcategory();
                        subCat.setName(arrCategories[i].trim());
                        cat.setSubcategory(subCat);
                    }
                } else {
                    cat.setName(categories);
                }
                infor.setCategory(cat);
            }
            if (imageURL != null) {
                try {
                    URL url = new URL(imageURL);
                    infor.setImage(url);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (keywords != null) {
                String[] arrKeywords = keywords.split(" ");
                infor.setKeywords(arrKeywords);
            }
            infor.setOwnerEmailAddress(ownerEmail);
            infor.setOwnerName(ownerName);
            infor.setSummary(feedDescription);
            infor.setSubtitle(feedDescription);
            ArrayList<FeedInformationImpl> modules = new ArrayList<FeedInformationImpl>();
            modules.add(infor);
            feed.setModules(modules);
            feed.setCopyright(copyright);
            feed.setDescription(feedDescription.replaceAll("&nbsp;", " "));
            feed.setFeedType(rssVersion);
            feed.setLanguage(language);
            feed.setLink(feedLink);
            feed.setPublishedDate(pubDate);
            feed.setTitle(feedTitle);
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            MimeTypeResolver resolver = new MimeTypeResolver();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node child = iter.nextNode();
                SyndEntryImpl entry = new SyndEntryImpl();
                try {
                    if (child.hasProperty(title)) {
                        entry.setTitle(child.getProperty(title).getString().replaceAll("&nbsp;", " "));
                    }
                }
                catch (PathNotFoundException path) {
                    entry.setTitle("");
                }
                ArrayList<SyndEnclosureImpl> enclosureList = new ArrayList<SyndEnclosureImpl>();
                SyndEnclosureImpl enc = new SyndEnclosureImpl();
                Node content = child.getNode(JCR_CONTENT);
                String mimeType = content.getProperty(JCR_MIMETYPE).getString();
                String ext = resolver.getExtension(mimeType);
                enc.setType(mimeType);
                String path = child.getPath().trim() + "." + ext.trim();
                if (child.hasProperty(LENGTH)) {
                    enc.setLength(child.getProperty(LENGTH).getLong());
                }
                String encUrl = rssUrl + path;
                enc.setUrl(encUrl);
                enclosureList.add(enc);
                entry.setEnclosures(enclosureList);
                entry.setLink(encUrl);
                EntryInformationImpl entryInfo = new EntryInformationImpl();
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                try {
                    if (child.hasProperty(summary)) {
                        String summaryValue = child.getProperty(summary).getString();
                        description.setValue(summaryValue);
                        entryInfo.setSubtitle(summaryValue);
                        entryInfo.setSummary(summaryValue);
                    }
                }
                catch (PathNotFoundException pnf) {
                    description.setValue("");
                    entryInfo.setSubtitle("");
                    entryInfo.setSummary("");
                }
                entry.setDescription((SyndContent)description);
                try {
                    Date pdate = child.getProperty(PUBLISHED_DATE).getDate().getTime();
                    entry.setPublishedDate(pdate);
                }
                catch (Exception e) {
                    entry.setPublishedDate(new Date());
                }
                if (child.hasProperty(AUTHOR)) {
                    entryInfo.setAuthor(child.getProperty(AUTHOR).getString());
                } else {
                    entryInfo.setAuthor("");
                }
                if (child.hasProperty(CATEGORY)) {
                    Category itemCat = new Category();
                    String itemCategories = child.getProperty(CATEGORY).getString();
                    if (itemCategories != null && itemCategories.length() > 0) {
                        if (itemCategories.indexOf(",") > -1) {
                            String[] arrCategories = itemCategories.split(",");
                            itemCat.setName(arrCategories[0].trim());
                            for (int i = 1; i < arrCategories.length; ++i) {
                                Subcategory subCat = new Subcategory();
                                subCat.setName(arrCategories[i].trim());
                                itemCat.setSubcategory(subCat);
                            }
                        } else {
                            itemCat.setName(itemCategories);
                        }
                        entryInfo.setCategory(itemCat);
                    }
                }
                Duration dura = new Duration();
                dura.setMilliseconds(enc.getLength());
                entryInfo.setDuration(dura);
                if (child.getProperty(EXPLICIT).getString().equals("no")) {
                    entryInfo.setExplicit(false);
                } else {
                    entryInfo.setExplicit(true);
                }
                if (child.hasProperty(KEYWORDS)) {
                    String keys = child.getProperty(KEYWORDS).getString();
                    if (keys != null) {
                        String[] arrKeywords = keys.split(" ");
                        entryInfo.setKeywords(arrKeywords);
                    }
                } else {
                    entryInfo.setKeywords(new String[0]);
                }
                ArrayList<EntryInformationImpl> entryList = new ArrayList<EntryInformationImpl>();
                entryList.add(entryInfo);
                entry.setModules(entryList);
                entries.add(entry);
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            this.storeXML(feedXML, storePath, feedName);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeXML(String feedXML, String rssStoredPath, String rssNodeName) {
        Session session = null;
        try {
            String[] arrayPaths;
            ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
            session = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getDefaultWorkspaceName());
            Node rootNode = session.getRootNode();
            for (String path : arrayPaths = rssStoredPath.split("/")) {
                if (path.trim().length() <= 0) continue;
                try {
                    rootNode = rootNode.getNode(path.trim());
                }
                catch (PathNotFoundException pe) {
                    rootNode.addNode(path.trim(), NT_UNSTRUCTURED);
                    rootNode.save();
                    rootNode = rootNode.getNode(path.trim());
                }
            }
            session.save();
            String mimeType = "application/rss+xml";
            Node rss = null;
            if (!rootNode.hasNode(rssNodeName)) {
                rss = rootNode.addNode(rssNodeName, NT_FILE);
                Node contentNode = rss.addNode(JCR_CONTENT, NT_RESOURCE);
                contentNode.setProperty(JCR_DATA, (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
                contentNode.setProperty(JCR_MIMETYPE, mimeType);
                contentNode.setProperty(JCR_LASTMODIFIED, (Calendar)new GregorianCalendar());
                session.save();
            } else {
                rss = rootNode.getNode(rssNodeName);
                boolean isEnabledVersion = false;
                NodeType[] mixinTypes = rss.getMixinNodeTypes();
                for (int i = 0; i < mixinTypes.length; ++i) {
                    if (!mixinTypes[i].getName().equals(MIX_VERSIONABLE)) continue;
                    isEnabledVersion = true;
                    break;
                }
                if (isEnabledVersion) {
                    rss.checkout();
                } else {
                    rss.addMixin(MIX_VERSIONABLE);
                }
                Node contentNode = rss.getNode(JCR_CONTENT);
                contentNode.setProperty(JCR_DATA, (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
                contentNode.setProperty(JCR_MIMETYPE, mimeType);
                contentNode.setProperty(JCR_LASTMODIFIED, (Calendar)new GregorianCalendar());
                rss.save();
                rss.checkin();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

