/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivity.gtmpl", events={@EventConfig(listeners={DownloadDocumentActionListener.class}), @EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class UIDocActivity
extends BaseUIActivity {
    private static final String IMAGE_PATTERN = "([^\\s]+(\\.(?i)(jpeg|jpg|png|gif|bmp))$)";
    public static final String ACTIVITY_TYPE = "DOC_ACTIVITY";
    public static final String DOCLINK = "DOCLINK";
    public static final String MESSAGE = "MESSAGE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCNAME = "DOCNAME";
    public static final String DOCPATH = "DOCPATH";
    public String docLink;
    public String message;
    public String docName;
    public String docPath;
    private Node docNode;

    public void setDocNode(Node docNode) {
        this.docNode = docNode;
    }

    public Node getDocNode() {
        return this.docNode;
    }

    protected boolean isImageFile(String fileName) {
        Pattern pattern = Pattern.compile(IMAGE_PATTERN);
        Matcher matcher = pattern.matcher(StringUtils.deleteWhitespace((String)fileName));
        return matcher.matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity uiComp = (UIDocActivity)((Object)event.getSource());
            String downloadLink = Utils.getDownloadLink((Node)uiComp.getDocNode());
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity docActivity = (UIDocActivity)((Object)event.getSource());
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)docActivity.getParent();
            UIPopupWindow popupWindow = activitiesContainer.getPopupWindow();
            if (docActivity.getChild(UIDocViewer.class) != null) {
                docActivity.removeChild(UIDocViewer.class);
            }
            UIDocViewer docViewer = (UIDocViewer)popupWindow.createUIComponent(UIDocViewer.class, null, "DocViewer");
            Node docNode = docActivity.getDocNode();
            docViewer.setOriginalNode(docNode);
            docViewer.setNode(docNode);
            popupWindow.setUIComponent((UIComponent)docViewer);
            popupWindow.setWindowSize(800, 600);
            popupWindow.setShow(true);
            popupWindow.setResizable(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)activitiesContainer);
        }
    }
}

