/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import java.util.Stack;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackingComponentEventManager
implements ComponentEventManager {
    private ObservationManager observationManager;
    private Stack<ComponentEventEntry> events = new Stack();
    private boolean shouldStack = true;

    public void notifyComponentRegistered(ComponentDescriptor<?> descriptor) {
        this.notifyComponentEvent((Event)new ComponentDescriptorAddedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor);
    }

    public void notifyComponentUnregistered(ComponentDescriptor<?> descriptor) {
        this.notifyComponentEvent((Event)new ComponentDescriptorRemovedEvent(descriptor.getRole(), descriptor.getRoleHint()), descriptor);
    }

    public synchronized void flushEvents() {
        for (ComponentEventEntry entry : this.events) {
            this.sendEvent(entry.event, entry.descriptor);
        }
    }

    public void shouldStack(boolean shouldStack) {
        this.shouldStack = shouldStack;
    }

    public void setObservationManager(ObservationManager observationManager) {
        this.observationManager = observationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyComponentEvent(Event event, ComponentDescriptor<?> descriptor) {
        if (this.shouldStack) {
            StackingComponentEventManager stackingComponentEventManager = this;
            synchronized (stackingComponentEventManager) {
                this.events.push(new ComponentEventEntry(event, descriptor));
            }
        } else {
            this.sendEvent(event, descriptor);
        }
    }

    private void sendEvent(Event event, ComponentDescriptor<?> descriptor) {
        if (this.observationManager != null) {
            this.observationManager.notify(event, (Object)this, descriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComponentEventEntry {
        public Event event;
        public ComponentDescriptor<?> descriptor;

        public ComponentEventEntry(Event event, ComponentDescriptor<?> descriptor) {
            this.event = event;
            this.descriptor = descriptor;
        }
    }
}

