/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.io.File;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class DB2ConnectionFactory
extends GenericCQConnectionFactory {
    private Boolean isReindexingSupport;

    public DB2ConnectionFactory(String dbDriver, String dbUrl, String dbUserName, String dbPassword, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws RepositoryException {
        super(dbDriver, dbUrl, dbUserName, dbPassword, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public DB2ConnectionFactory(DataSource dbDataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) {
        super(dbDataSource, containerName, multiDb, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.multiDb) {
                return new DB2MultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            return new DB2SingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerName, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isIDNeededForPaging() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean isReindexingSupport() {
        if (this.isReindexingSupport == null) {
            block24: {
                con = null;
                try {
                    block23: {
                        con = this.getJdbcConnection();
                        metaData = con.getMetaData();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("DB Major version = " + metaData.getDatabaseMajorVersion() + ", DB Minor version = " + metaData.getDatabaseMinorVersion() + ", DB Product version = " + metaData.getDatabaseProductVersion()));
                        }
                        if (metaData.getDatabaseMajorVersion() > 9) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"RDBMS indexing enabled as the major version is greater than 9.");
                            }
                            this.isReindexingSupport = true;
                            break block23;
                        }
                        if (metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() > 7) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"RDBMS indexing enabled as the major version is 9 and the minor version is greater than 7.");
                            }
                            this.isReindexingSupport = true;
                            break block23;
                        }
                        if (metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() == 7) {
                            value = metaData.getDatabaseProductVersion();
                            maintenanceVersion = Integer.parseInt(value.substring(value.length() - 1));
                            this.isReindexingSupport = maintenanceVersion >= 2;
                            if (this.log.isDebugEnabled()) {
                                if (this.isReindexingSupport.booleanValue()) {
                                    this.log.debug((Object)("RDBMS indexing enabled as the major version is 9, the minor version is 7 and the maintenance version is greater or equals to 2 knowing that the extracted value is " + maintenanceVersion + "."));
                                } else {
                                    this.log.debug((Object)("RDBMS indexing disabled as the major version is 9, the minor version is 7 and the maintenance version is lower than 2 knowing that the extracted value is " + maintenanceVersion + "."));
                                }
                            }
                            break block23;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"RDBMS indexing disabled as the major version is lower than 9 or the minor version is lower than 7.");
                        }
                        this.isReindexingSupport = false;
                    }
                    var6_6 = null;
                    ** if (con == null) goto lbl-1000
                }
                catch (Throwable var5_12) {
                    var6_8 = null;
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    throw var5_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block24;
                    catch (Exception e) {
                        this.isReindexingSupport = false;
                        this.log.error((Object)"Error checking product version.", (Throwable)e);
                        var6_7 = null;
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e) {}
                        }
                    }
                }
            }
            if (!this.isReindexingSupport.booleanValue()) {
                this.log.debug((Object)"The version of DB2 is prior to 9.7.2, so the old indexing mechanism will be used");
            }
        }
        return this.isReindexingSupport;
    }
}

