/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.Properties;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AsyncCacheLoader;

public class AsyncCacheLoaderConfig
extends CacheLoaderConfig.IndividualCacheLoaderConfig {
    private static final long serialVersionUID = 5038037589485991681L;
    private int batchSize = 100;
    private boolean returnOld = true;
    private int queueSize = 0;
    private boolean useAsyncPut = true;
    private int threadPoolSize = 1;

    public AsyncCacheLoaderConfig() {
        this.setClassName(AsyncCacheLoader.class.getName());
    }

    AsyncCacheLoaderConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.setClassName(AsyncCacheLoader.class.getName());
        this.populateFromBaseConfig(base);
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.testImmutability("threadPoolSize");
        this.threadPoolSize = threadPoolSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.testImmutability("batchSize");
        this.batchSize = batchSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.testImmutability("queueSize");
        this.queueSize = queueSize;
    }

    public boolean getReturnOld() {
        return this.returnOld;
    }

    public void setReturnOld(boolean returnOld) {
        this.testImmutability("returnOld");
        this.returnOld = returnOld;
    }

    public boolean getUseAsyncPut() {
        return this.useAsyncPut;
    }

    public void setUseAsyncPut(boolean useAsyncPut) {
        this.testImmutability("useAsyncPut");
        this.useAsyncPut = useAsyncPut;
    }

    public void setProperties(Properties props) {
        super.setProperties(props);
        String s = props.getProperty("cache.async.batchSize");
        if (s != null) {
            this.batchSize = Integer.parseInt(s);
        }
        if (this.batchSize <= 0) {
            throw new IllegalArgumentException("Invalid batch size: " + this.batchSize);
        }
        s = props.getProperty("cache.async.threadPoolSize");
        if (s != null) {
            this.threadPoolSize = Integer.parseInt(s);
        }
        if (this.threadPoolSize <= 0) {
            throw new IllegalArgumentException("Invalid thread pool size: " + this.threadPoolSize);
        }
        s = props.getProperty("cache.async.returnOld");
        if (s != null) {
            this.returnOld = Boolean.valueOf(s);
        }
        if ((s = props.getProperty("cache.async.queueSize")) != null) {
            this.queueSize = Integer.parseInt(s);
        }
        if ((s = props.getProperty("cache.async.put")) != null) {
            this.useAsyncPut = Boolean.valueOf(s);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsyncCacheLoaderConfig && this.equalsExcludingProperties(obj)) {
            AsyncCacheLoaderConfig other = (AsyncCacheLoaderConfig)obj;
            return this.batchSize == other.batchSize && this.queueSize == other.queueSize && this.returnOld == other.returnOld && this.useAsyncPut == other.useAsyncPut;
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingProperties();
        result = 31 * result + this.batchSize;
        result = 31 * result + this.queueSize;
        result = 31 * result + (this.returnOld ? 0 : 1);
        result = 31 * result + (this.useAsyncPut ? 0 : 1);
        return result;
    }

    public AsyncCacheLoaderConfig clone() throws CloneNotSupportedException {
        return (AsyncCacheLoaderConfig)super.clone();
    }
}

