/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.io.Serializable;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeImpl;

public class TermAttributeImpl
extends AttributeImpl
implements TermAttribute,
Cloneable,
Serializable {
    private static int MIN_BUFFER_SIZE;
    private char[] termBuffer;
    private int termLength;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String term() {
        this.initTermBuffer();
        return new String(this.termBuffer, 0, this.termLength);
    }

    public void setTermBuffer(char[] buffer, int offset, int length) {
        this.growTermBuffer(length);
        System.arraycopy(buffer, offset, this.termBuffer, 0, length);
        this.termLength = length;
    }

    public void setTermBuffer(String buffer) {
        int length = buffer.length();
        this.growTermBuffer(length);
        buffer.getChars(0, length, this.termBuffer, 0);
        this.termLength = length;
    }

    public void setTermBuffer(String buffer, int offset, int length) {
        if (!$assertionsDisabled && offset > buffer.length()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && offset + length > buffer.length()) {
            throw new AssertionError();
        }
        this.growTermBuffer(length);
        buffer.getChars(offset, offset + length, this.termBuffer, 0);
        this.termLength = length;
    }

    public char[] termBuffer() {
        this.initTermBuffer();
        return this.termBuffer;
    }

    public char[] resizeTermBuffer(int newSize) {
        if (this.termBuffer == null) {
            this.termBuffer = new char[ArrayUtil.getNextSize(newSize < MIN_BUFFER_SIZE ? MIN_BUFFER_SIZE : newSize)];
        } else if (this.termBuffer.length < newSize) {
            char[] newCharBuffer = new char[ArrayUtil.getNextSize(newSize)];
            System.arraycopy(this.termBuffer, 0, newCharBuffer, 0, this.termBuffer.length);
            this.termBuffer = newCharBuffer;
        }
        return this.termBuffer;
    }

    private void growTermBuffer(int newSize) {
        if (this.termBuffer == null) {
            this.termBuffer = new char[ArrayUtil.getNextSize(newSize < MIN_BUFFER_SIZE ? MIN_BUFFER_SIZE : newSize)];
        } else if (this.termBuffer.length < newSize) {
            this.termBuffer = new char[ArrayUtil.getNextSize(newSize)];
        }
    }

    private void initTermBuffer() {
        if (this.termBuffer == null) {
            this.termBuffer = new char[ArrayUtil.getNextSize(MIN_BUFFER_SIZE)];
            this.termLength = 0;
        }
    }

    public int termLength() {
        return this.termLength;
    }

    public void setTermLength(int length) {
        this.initTermBuffer();
        if (length > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + length + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = length;
    }

    public int hashCode() {
        this.initTermBuffer();
        int code = this.termLength;
        code = code * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return code;
    }

    public void clear() {
        this.termLength = 0;
    }

    public Object clone() {
        TermAttributeImpl t = (TermAttributeImpl)super.clone();
        if (this.termBuffer != null) {
            t.termBuffer = new char[this.termLength];
            System.arraycopy(this.termBuffer, 0, t.termBuffer, 0, this.termLength);
        }
        return t;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TermAttribute) {
            this.initTermBuffer();
            TermAttributeImpl o = (TermAttributeImpl)other;
            o.initTermBuffer();
            if (this.termLength != o.termLength) {
                return false;
            }
            for (int i = 0; i < this.termLength; ++i) {
                if (this.termBuffer[i] == o.termBuffer[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        this.initTermBuffer();
        return "term=" + new String(this.termBuffer, 0, this.termLength);
    }

    public void copyTo(AttributeImpl target) {
        this.initTermBuffer();
        TermAttribute t = (TermAttribute)((Object)target);
        t.setTermBuffer(this.termBuffer, 0, this.termLength);
    }

    static {
        $assertionsDisabled = !TermAttributeImpl.class.desiredAssertionStatus();
        MIN_BUFFER_SIZE = 10;
    }
}

