/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.symlink;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.symlink.UISymLinkManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.selector.content.one.UIContentBrowsePanelOne;
import org.exoplatform.wcm.webui.selector.content.one.UIContentSelectorOne;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormMultiValueInputSet.class, id="SymLinkMultipleInputset", events={@EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE)})})
public class UISymLinkForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.symlink.UISymLinkForm");
    public static final String FIELD_NAME = "symLinkName";
    public static final String FIELD_PATH = "pathNode";
    public static final String FIELD_SYMLINK = "fieldPathNode";
    public static final String POPUP_SYMLINK = "UIPopupSymLink";
    public static final byte DRIVE_SELECTOR_MODE = 0;
    public static final byte WORSPACE_SELECTOR_MODE = 1;
    private byte selectorMode = 0;
    private boolean localizationMode = false;

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void initFieldInput() throws Exception {
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, "SymLinkMultipleInputset", null);
        uiFormMultiValue.setId(FIELD_PATH);
        uiFormMultiValue.setName(FIELD_PATH);
        uiFormMultiValue.setEditable(false);
        uiFormMultiValue.setType(UIFormStringInput.class);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
        if (!this.localizationMode) {
            this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        }
    }

    public void enableLocalizationMode() {
        this.localizationMode = true;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String valueNodeName = String.valueOf(value).trim();
        String workspaceName = valueNodeName.substring(0, valueNodeName.lastIndexOf(":/"));
        valueNodeName = valueNodeName.substring(workspaceName.lastIndexOf(":") + 1);
        ArrayList<String> listNodeName = new ArrayList<String>();
        listNodeName.add(valueNodeName);
        UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)this.getChild(UIFormMultiValueInputSet.class);
        uiFormMultiValueInputSet.setValue(listNodeName);
        String symLinkName = valueNodeName.substring(valueNodeName.lastIndexOf("/") + 1);
        int squareBracketIndex = symLinkName.indexOf(91);
        if (squareBracketIndex > -1) {
            symLinkName = symLinkName.substring(0, squareBracketIndex);
        }
        if (symLinkName.indexOf(".lnk") < 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(symLinkName).append(".lnk");
            symLinkName = sb.toString();
        }
        symLinkName = Text.unescapeIllegalJcrChars((String)symLinkName);
        if (!this.localizationMode) {
            this.getUIStringInput(FIELD_NAME).setValue((Object)symLinkName);
        }
        UISymLinkManager uiSymLinkManager = (UISymLinkManager)this.getParent();
        uiSymLinkManager.removeChildById(POPUP_SYMLINK);
    }

    public void useWorkspaceSelector() {
        this.selectorMode = 1;
    }

    public void useDriveSelector() {
        this.selectorMode = 0;
    }

    public boolean isUseWorkspaceSelector() {
        return this.selectorMode == 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        private String fixPath(String path, String driveName, String repo, UISymLinkForm uiSymlinkForm) throws Exception {
            if (path == null || path.length() == 0 || driveName == null || driveName.length() == 0 || repo == null || repo.length() == 0) {
                return "";
            }
            ManageDriveService managerDriveService = (ManageDriveService)uiSymlinkForm.getApplicationComponent(ManageDriveService.class);
            DriveData driveData = managerDriveService.getDriveByName(driveName, repo);
            if (!path.startsWith(driveData.getHomePath())) {
                return "";
            }
            if ("/".equals(driveData.getHomePath())) {
                return path;
            }
            return path.substring(driveData.getHomePath().length());
        }

        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            UISymLinkForm uiSymLinkForm = (UISymLinkForm)uiSet.getParent();
            UISymLinkManager uiSymLinkManager = (UISymLinkManager)uiSymLinkForm.getParent();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSymLinkForm.getAncestorOfType(UIJCRExplorer.class);
            String workspaceName = uiExplorer.getCurrentWorkspace();
            String param = "returnField=fieldPathNode";
            UIPopupWindow uiPopupWindow = uiSymLinkManager.initPopupTaxonomy(UISymLinkForm.POPUP_SYMLINK);
            if (uiSymLinkForm.isUseWorkspaceSelector()) {
                UIOneNodePathSelector uiNodePathSelector = (UIOneNodePathSelector)uiSymLinkManager.createUIComponent(UIOneNodePathSelector.class, null, null);
                uiPopupWindow.setUIComponent((UIComponent)uiNodePathSelector);
                uiNodePathSelector.setIsDisable(workspaceName, false);
                uiNodePathSelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:symlink"});
                uiNodePathSelector.setRootNodeLocation(uiExplorer.getRepositoryName(), workspaceName, "/");
                uiNodePathSelector.setIsShowSystem(false);
                uiNodePathSelector.init(WCMCoreUtils.getUserSessionProvider());
                uiNodePathSelector.setSourceComponent((UIComponent)uiSymLinkForm, new String[]{param});
            } else {
                Node node = uiExplorer.getCurrentNode();
                UIContentSelectorOne uiNodePathSelector = (UIContentSelectorOne)uiSymLinkForm.createUIComponent(UIContentSelectorOne.class, null, null);
                uiPopupWindow.setUIComponent((UIComponent)uiNodePathSelector);
                uiNodePathSelector.init(uiExplorer.getDriveData().getName(), this.fixPath(node == null ? "" : node.getPath(), uiExplorer.getDriveData().getName(), uiExplorer.getRepositoryName(), uiSymLinkForm));
                ((UIContentBrowsePanelOne)uiNodePathSelector.getChild(UIContentBrowsePanelOne.class)).setSourceComponent((UIComponent)uiSymLinkForm, new String[]{param});
            }
            uiPopupWindow.setRendered(true);
            uiPopupWindow.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSymLinkManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            UIComponent uiComponent = uiSet.getParent();
            if (uiComponent instanceof UISymLinkForm) {
                UISymLinkForm uiSymLinkForm = (UISymLinkForm)uiComponent;
                String id = event.getRequestContext().getRequestParameter("objectId");
                UIFormStringInput uiInput = uiSymLinkForm.getUIStringInput(UISymLinkForm.FIELD_NAME);
                if (uiInput != null) {
                    uiInput.setValue((Object)"");
                }
                uiSet.removeChildById(id);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSymLinkForm);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISymLinkForm> {
        public void execute(Event<UISymLinkForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UISymLinkForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISymLinkForm> {
        public void execute(Event<UISymLinkForm> event) throws Exception {
            UISymLinkForm uiSymLinkForm = (UISymLinkForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSymLinkForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiSymLinkForm.getAncestorOfType(UIApplication.class);
            String symLinkName = "";
            if (!uiSymLinkForm.localizationMode) {
                symLinkName = (String)uiSymLinkForm.getUIStringInput(UISymLinkForm.FIELD_NAME).getValue();
            }
            String pathNode = "";
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)uiSymLinkForm.getChild(UIFormMultiValueInputSet.class);
            List listChildren = uiSet.getChildren();
            for (UIComponent component : listChildren) {
                UIFormStringInput uiStringInput = (UIFormStringInput)component;
                if (uiStringInput.getValue() == null) continue;
                pathNode = ((String)uiStringInput.getValue()).trim();
            }
            Node node = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null));
                return;
            }
            if (!(uiSymLinkForm.localizationMode || symLinkName != null && symLinkName.length() != 0)) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.name-invalid", null));
                return;
            }
            if (pathNode == null || pathNode.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.path-node-invalid", null));
                return;
            }
            String workspaceName = pathNode.substring(0, pathNode.lastIndexOf(":/"));
            pathNode = pathNode.substring(pathNode.lastIndexOf(":/") + 1);
            NodeFinder nodeFinder = (NodeFinder)uiSymLinkForm.getApplicationComponent(NodeFinder.class);
            try {
                nodeFinder.getItem(workspaceName, pathNode);
            }
            catch (ItemNotFoundException e) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.non-node", null, 1));
                return;
            }
            catch (RepositoryException re) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.non-node", null, 1));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.non-node", null, 1));
                return;
            }
            try {
                Node targetNode = (Node)nodeFinder.getItem(workspaceName, pathNode);
                if (uiSymLinkForm.localizationMode) {
                    MultiLanguageService langService = (MultiLanguageService)uiSymLinkForm.getApplicationComponent(MultiLanguageService.class);
                    langService.addLinkedLanguage(node, targetNode);
                } else {
                    LinkManager linkManager = (LinkManager)uiSymLinkForm.getApplicationComponent(LinkManager.class);
                    linkManager.createLink(node, "exo:symlink", targetNode, symLinkName);
                }
                uiExplorer.updateAjax(event);
            }
            catch (AccessControlException ace) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.repository-exception", null, 1));
                return;
            }
            catch (AccessDeniedException ade) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.repository-exception", null, 1));
                return;
            }
            catch (NumberFormatException nume) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.numberformat-exception", null, 1));
                return;
            }
            catch (ConstraintViolationException cve) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.cannot-save", null, 1));
                return;
            }
            catch (ItemExistsException iee) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.item-exists-exception", null, 1));
                return;
            }
            catch (UnsupportedRepositoryOperationException unOperationException) {
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.UnsupportedRepositoryOperationException", null, 1));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                uiApp.addMessage(new ApplicationMessage("UISymLinkForm.msg.cannot-save", null, 1));
                return;
            }
        }
    }
}

