/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableByteArrayInputStream;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.graphics.ExtGState;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.PatternColor;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.TextState;
import org.icepdf.core.pobjects.graphics.TilingPattern;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.PageText;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

public class ContentParser {
    private static final Logger logger = Logger.getLogger(ContentParser.class.toString());
    public static final float OVERPAINT_ALPHA = 0.4f;
    private GraphicsState graphicState;
    private Library library;
    private Resources resources;
    private boolean inTextBlock;
    private AffineTransform textBlockBase;

    public ContentParser(Library l, Resources r) {
        this.library = l;
        this.resources = r;
    }

    public GraphicsState getGraphicsState() {
        return this.graphicState;
    }

    public void setGraphicsState(GraphicsState graphicState) {
        this.graphicState = graphicState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Shapes parse(InputStream source) throws InterruptedException {
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        } else {
            this.graphicState.setCTM(new AffineTransform());
            this.graphicState.setClip(null);
            ContentParser.setStroke(shapes, this.graphicState);
            this.graphicState.setShapes(shapes);
        }
        if (logger.isLoggable(Level.FINER)) {
            String content;
            if (source instanceof SeekableInput) {
                content = Utils.getContentFromSeekableInput((SeekableInput)((Object)source), false);
            } else {
                InputStream[] inArray = new InputStream[]{source};
                content = Utils.getContentAndReplaceInputStream(inArray, false);
                source = inArray[0];
            }
            logger.finer("Content = " + content);
        }
        Parser parser = new Parser(source);
        Stack<Object> stack = new Stack<Object>();
        float yBTstart = 0.0f;
        try {
            GeneralPath geometricPath = null;
            while (true) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("ContentParser thread interrupted");
                }
                Object tok = parser.getStreamObject();
                if (!(tok instanceof String)) {
                    stack.push(tok);
                    continue;
                }
                if (tok.equals("l")) {
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    geometricPath.lineTo(x, y);
                    continue;
                }
                if (tok.equals("m")) {
                    if (geometricPath == null) {
                        geometricPath = new GeneralPath();
                    }
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    geometricPath.moveTo(x, y);
                    continue;
                }
                if (tok.equals("c")) {
                    float y3 = ((Number)stack.pop()).floatValue();
                    float x3 = ((Number)stack.pop()).floatValue();
                    float y2 = ((Number)stack.pop()).floatValue();
                    float x2 = ((Number)stack.pop()).floatValue();
                    float y1 = ((Number)stack.pop()).floatValue();
                    float x1 = ((Number)stack.pop()).floatValue();
                    geometricPath.curveTo(x1, y1, x2, y2, x3, y3);
                    continue;
                }
                if (tok.equals("S")) {
                    if (geometricPath == null) continue;
                    ContentParser.commonStroke(this.graphicState, shapes, geometricPath);
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("Tf")) {
                    ContentParser.consume_Tf(this.graphicState, stack, this.resources);
                    continue;
                }
                if (tok.equals("BT")) {
                    ContentParser.setAlpha(shapes, 1.0f);
                    yBTstart = this.parseText(parser, shapes, yBTstart);
                    continue;
                }
                if (tok.equals("F") || tok.equals("f")) {
                    if (geometricPath != null) {
                        geometricPath.setWindingRule(1);
                        this.commonFill(shapes, geometricPath);
                    }
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("q")) {
                    this.graphicState = ContentParser.consume_q(this.graphicState);
                    continue;
                }
                if (tok.equals("Q")) {
                    this.graphicState = ContentParser.consume_Q(this.graphicState, shapes);
                    continue;
                }
                if (tok.equals("re")) {
                    if (geometricPath == null) {
                        geometricPath = new GeneralPath();
                    }
                    float h = ((Number)stack.pop()).floatValue();
                    float w = ((Number)stack.pop()).floatValue();
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    geometricPath.moveTo(x, y);
                    geometricPath.lineTo(x + w, y);
                    geometricPath.lineTo(x + w, y + h);
                    geometricPath.lineTo(x, y + h);
                    geometricPath.lineTo(x, y);
                    continue;
                }
                if (tok.equals("cm")) {
                    ContentParser.consume_cm(this.graphicState, stack, this.inTextBlock, this.textBlockBase);
                    continue;
                }
                if (tok.equals("h")) {
                    if (geometricPath == null) continue;
                    geometricPath.closePath();
                    continue;
                }
                if (tok.equals("BDC")) {
                    stack.pop();
                    stack.pop();
                    continue;
                }
                if (tok.equals("EMC")) continue;
                if (tok.equals("Do")) {
                    String xobjectName = ((Name)stack.pop()).getName();
                    if (this.resources.isForm(xobjectName)) {
                        this.graphicState = this.graphicState.save();
                        Form formXObject = this.resources.getForm(xobjectName);
                        if (formXObject != null) {
                            formXObject.setGraphicsState(new GraphicsState(this.graphicState));
                            formXObject.setParentResources(this.resources);
                            formXObject.init();
                            AffineTransform af = new AffineTransform(this.graphicState.getCTM());
                            af.concatenate(formXObject.getMatrix());
                            shapes.add(af);
                            if (this.graphicState.getClip() != null) {
                                AffineTransform matrix = formXObject.getMatrix();
                                Rectangle2D bbox = formXObject.getBBox();
                                Rectangle2D clip = this.graphicState.getClip().getBounds2D();
                                matrix = matrix.createInverse();
                                Shape shape = matrix.createTransformedShape(clip);
                                Rectangle2D formClip = bbox.createIntersection(shape.getBounds2D());
                                shapes.add(formClip);
                            } else {
                                shapes.add(formXObject.getBBox());
                            }
                            shapes.addClipCommand();
                            shapes.add(formXObject.getShapes());
                            if (formXObject.getShapes() != null) {
                                shapes.add(formXObject.getShapes().getImages());
                            }
                            if (formXObject.getShapes() != null && formXObject.getShapes().getPageText() != null) {
                                formXObject.getShapes().getPageText().applyXObjectTransform(this.graphicState.getCTM());
                            }
                            shapes.addNoClipCommand();
                            formXObject.completed();
                        }
                        this.graphicState = this.graphicState.restore();
                        continue;
                    }
                    Image im = this.resources.getImage(xobjectName, this.graphicState.getFillColor());
                    if (im == null) continue;
                    AffineTransform af = new AffineTransform(this.graphicState.getCTM());
                    this.graphicState.scale(1.0, -1.0);
                    this.graphicState.translate(0.0, -1.0);
                    shapes.add(im);
                    this.graphicState.set(af);
                    continue;
                }
                if (tok.equals("f*")) {
                    if (geometricPath != null) {
                        geometricPath.setWindingRule(0);
                        this.commonFill(shapes, geometricPath);
                    }
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("gs")) {
                    ContentParser.consume_gs(this.graphicState, stack, this.resources);
                    continue;
                }
                if (tok.equals("n")) {
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("w") || tok.equals("LW")) {
                    ContentParser.consume_w(this.graphicState, stack, shapes);
                    continue;
                }
                if (tok.equals("W")) {
                    if (geometricPath == null) continue;
                    geometricPath.setWindingRule(1);
                    geometricPath.closePath();
                    this.graphicState.setClip(geometricPath);
                    continue;
                }
                if (tok.equals("sc") || tok.equals("scn")) {
                    ContentParser.consume_sc(this.graphicState, stack, this.library, this.resources);
                    continue;
                }
                if (tok.equals("b")) {
                    if (geometricPath != null) {
                        geometricPath.setWindingRule(1);
                        geometricPath.closePath();
                        ContentParser.commonStroke(this.graphicState, shapes, geometricPath);
                        this.commonFill(shapes, geometricPath);
                    }
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("k")) {
                    ContentParser.consume_k(this.graphicState, stack, this.library);
                    continue;
                }
                if (tok.equals("g")) {
                    ContentParser.consume_g(this.graphicState, stack, this.library);
                    continue;
                }
                if (tok.equals("i")) {
                    ContentParser.consume_i(stack);
                    continue;
                }
                if (tok.equals("M")) {
                    ContentParser.consume_M(this.graphicState, stack, shapes);
                    continue;
                }
                if (tok.equals("J")) {
                    ContentParser.consume_J(this.graphicState, stack, shapes);
                    continue;
                }
                if (tok.equals("rg")) {
                    ContentParser.consume_rg(this.graphicState, stack, this.library);
                    continue;
                }
                if (tok.equals("d")) {
                    ContentParser.consume_d(this.graphicState, stack, shapes);
                    continue;
                }
                if (tok.equals("v")) {
                    float y3 = ((Number)stack.pop()).floatValue();
                    float x3 = ((Number)stack.pop()).floatValue();
                    float y2 = ((Number)stack.pop()).floatValue();
                    float x2 = ((Number)stack.pop()).floatValue();
                    geometricPath.curveTo((float)geometricPath.getCurrentPoint().getX(), (float)geometricPath.getCurrentPoint().getY(), x2, y2, x3, y3);
                    continue;
                }
                if (tok.equals("j")) {
                    ContentParser.consume_j(this.graphicState, stack, shapes);
                    continue;
                }
                if (tok.equals("y")) {
                    float y3 = ((Number)stack.pop()).floatValue();
                    float x3 = ((Number)stack.pop()).floatValue();
                    float y1 = ((Number)stack.pop()).floatValue();
                    float x1 = ((Number)stack.pop()).floatValue();
                    geometricPath.curveTo(x1, y1, x3, y3, x3, y3);
                    continue;
                }
                if (tok.equals("cs")) {
                    ContentParser.consume_cs(this.graphicState, stack, this.resources);
                    continue;
                }
                if (tok.equals("ri")) {
                    stack.pop();
                    continue;
                }
                if (tok.equals("SC") || tok.equals("SCN")) {
                    ContentParser.consume_SC(this.graphicState, stack, this.library, this.resources);
                    continue;
                }
                if (tok.equals("B")) {
                    if (geometricPath != null) {
                        geometricPath.setWindingRule(1);
                        ContentParser.commonStroke(this.graphicState, shapes, geometricPath);
                        this.commonFill(shapes, geometricPath);
                    }
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("K")) {
                    ContentParser.consume_K(this.graphicState, stack, this.library);
                    continue;
                }
                if (tok.equals("d0")) {
                    this.graphicState = this.graphicState.save();
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    TextState textState = this.graphicState.getTextState();
                    textState.setType3HorizontalDisplacement(new Point2D.Float(x, y));
                    continue;
                }
                if (tok.equals("s")) {
                    if (geometricPath == null) continue;
                    geometricPath.closePath();
                    ContentParser.commonStroke(this.graphicState, shapes, geometricPath);
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("G")) {
                    ContentParser.consume_G(this.graphicState, stack, this.library);
                    continue;
                }
                if (tok.equals("b*")) {
                    if (geometricPath != null) {
                        geometricPath.setWindingRule(0);
                        geometricPath.closePath();
                        ContentParser.commonStroke(this.graphicState, shapes, geometricPath);
                        this.commonFill(shapes, geometricPath);
                    }
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("RG")) {
                    ContentParser.consume_RG(this.graphicState, stack, this.library);
                    continue;
                }
                if (tok.equals("CS")) {
                    ContentParser.consume_CS(this.graphicState, stack, this.resources);
                    continue;
                }
                if (tok.equals("d1")) {
                    this.graphicState = this.graphicState.save();
                    float x2 = ((Number)stack.pop()).floatValue();
                    float y2 = ((Number)stack.pop()).floatValue();
                    float x1 = ((Number)stack.pop()).floatValue();
                    float y1 = ((Number)stack.pop()).floatValue();
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    TextState textState = this.graphicState.getTextState();
                    textState.setType3HorizontalDisplacement(new Point2D.Float(x, y));
                    textState.setType3BBox(new PRectangle(new Point2D.Float(x1, y1), new Point2D.Float(x2, y2)));
                    continue;
                }
                if (tok.equals("B*")) {
                    if (geometricPath != null) {
                        geometricPath.setWindingRule(0);
                        ContentParser.commonStroke(this.graphicState, shapes, geometricPath);
                        this.commonFill(shapes, geometricPath);
                    }
                    geometricPath = null;
                    continue;
                }
                if (tok.equals("BMC")) {
                    stack.pop();
                    continue;
                }
                if (tok.equals("BI")) {
                    this.parseInlineImage(parser, shapes);
                    continue;
                }
                if (tok.equals("BX") || tok.equals("EX")) continue;
                if (tok.equals("W*")) {
                    if (geometricPath == null) continue;
                    geometricPath.setWindingRule(0);
                    geometricPath.closePath();
                    this.graphicState.setClip(geometricPath);
                    continue;
                }
                if (tok.equals("DP")) {
                    stack.pop();
                    stack.pop();
                    continue;
                }
                if (tok.equals("MP")) {
                    stack.pop();
                    continue;
                }
                if (tok.equals("sh")) {
                    Name patternName;
                    ShadingPattern pattern;
                    Object o = stack.peek();
                    if (!(o instanceof Name) || (pattern = this.resources.getShading((patternName = (Name)stack.pop()).toString())) == null) continue;
                    pattern.init();
                    ContentParser.setAlpha(shapes, this.graphicState.getFillAlpha());
                    shapes.add(pattern.getPaint());
                    shapes.add(this.graphicState.getClip());
                    shapes.addFillCommand();
                    continue;
                }
                if (tok.equals("Tc")) {
                    ContentParser.consume_Tc(this.graphicState, stack);
                    continue;
                }
                if (tok.equals("Tw")) {
                    ContentParser.consume_Tw(this.graphicState, stack);
                    continue;
                }
                if (tok.equals("TL")) {
                    ContentParser.consume_TL(this.graphicState, stack);
                    continue;
                }
                if (tok.equals("Tr")) {
                    ContentParser.consume_Tr(this.graphicState, stack);
                    continue;
                }
                if (tok.equals("Tz")) {
                    ContentParser.consume_Tz(this.graphicState, stack);
                    continue;
                }
                if (!tok.equals("Ts")) continue;
                ContentParser.consume_Ts(this.graphicState, stack);
            }
        }
        catch (IOException e) {
            logger.finer("End of Content Stream");
            ContentParser.setAlpha(shapes, 1.0f);
        }
        catch (NoninvertibleTransformException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                ContentParser.setAlpha(shapes, 1.0f);
            }
        }
        while (!stack.isEmpty()) {
            String tmp = stack.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("STACK=" + tmp);
        }
        shapes.contract();
        return shapes;
    }

    public Shapes parseTextBlocks(InputStream source) {
        Parser parser = new Parser(source);
        Shapes shapes = new Shapes();
        if (this.graphicState == null) {
            this.graphicState = new GraphicsState(shapes);
        }
        try {
            Object tok = parser.getStreamObject();
            Stack<Object> stack = new Stack<Object>();
            double yBTstart = 0.0;
            while (tok != null) {
                if (tok instanceof String) {
                    if (tok.equals("BT")) {
                        yBTstart = this.parseText(parser, shapes, yBTstart);
                        stack.clear();
                    } else if (tok.equals("Tf")) {
                        ContentParser.consume_Tf(this.graphicState, stack, this.resources);
                        stack.clear();
                    }
                } else {
                    stack.push(tok);
                }
                tok = parser.getStreamObject();
            }
            stack.clear();
        }
        catch (IOException e) {
            logger.finer("End of Content Stream");
        }
        shapes.contract();
        return shapes;
    }

    float parseText(Parser parser, Shapes shapes, double previousBTStart) throws IOException {
        Stack<Object> stack = new Stack<Object>();
        this.inTextBlock = true;
        float shift = 0.0f;
        float previousAdvance = 0.0f;
        Point2D.Float advance = new Point2D.Float(0.0f, 0.0f);
        this.textBlockBase = new AffineTransform(this.graphicState.getCTM());
        this.graphicState.getTextState().tmatrix = new AffineTransform();
        this.graphicState.getTextState().tlmatrix = new AffineTransform();
        this.graphicState.scale(1.0, -1.0);
        PageText pageText = shapes.getPageText();
        boolean isYstart = true;
        float yBTStart = 0.0f;
        Object nextToken = parser.getStreamObject();
        while (!nextToken.equals("ET")) {
            if (nextToken instanceof String) {
                TextState textState;
                StringObject stringObject;
                if (nextToken.equals("Tj")) {
                    Object tjValue = stack.pop();
                    if (tjValue instanceof StringObject) {
                        stringObject = (StringObject)tjValue;
                        textState = this.graphicState.getTextState();
                        ContentParser.applyTextScaling(this.graphicState);
                        Point2D.Float d = (Point2D.Float)this.drawString(stringObject.getLiteralStringBuffer(textState.font.getSubTypeFormat(), textState.font.getFont()), advance, previousAdvance, this.graphicState.getTextState(), shapes);
                        this.graphicState.translate(d.x, 0.0);
                        shift += d.x;
                        previousAdvance = 0.0f;
                        advance.setLocation(0.0f, 0.0f);
                    }
                } else if (nextToken.equals("Tc")) {
                    this.graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
                } else if (nextToken.equals("Tw")) {
                    this.graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
                } else if (nextToken.equals("Td")) {
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    double oldY = this.graphicState.getCTM().getTranslateY();
                    this.graphicState.translate(-shift, 0.0);
                    shift = 0.0f;
                    previousAdvance = 0.0f;
                    advance.setLocation(0.0f, 0.0f);
                    this.graphicState.translate(x, -y);
                    float newY = (float)this.graphicState.getCTM().getTranslateY();
                    if (isYstart) {
                        yBTStart = newY;
                        isYstart = false;
                        if (previousBTStart != (double)yBTStart) {
                            pageText.newLine();
                        }
                    }
                    if (y != 0.0f && (double)newY != oldY) {
                        pageText.newLine();
                    }
                } else if (nextToken.equals("Tm")) {
                    shift = 0.0f;
                    previousAdvance = 0.0f;
                    advance.setLocation(0.0f, 0.0f);
                    float f6 = ((Number)stack.pop()).floatValue();
                    float f5 = ((Number)stack.pop()).floatValue();
                    float f4 = ((Number)stack.pop()).floatValue();
                    float f3 = ((Number)stack.pop()).floatValue();
                    float f2 = ((Number)stack.pop()).floatValue();
                    float f1 = ((Number)stack.pop()).floatValue();
                    AffineTransform af = new AffineTransform(this.textBlockBase);
                    double oldTransY = this.graphicState.getCTM().getTranslateY();
                    double oldScaleY = this.graphicState.getCTM().getScaleY();
                    this.graphicState.getTextState().tmatrix = new AffineTransform(f1, f2, f3, f4, f5, f6);
                    af.concatenate(this.graphicState.getTextState().tmatrix);
                    this.graphicState.set(af);
                    this.graphicState.scale(1.0, -1.0);
                    if (isYstart) {
                        yBTStart = f6;
                        isYstart = false;
                        if (previousBTStart != (double)yBTStart) {
                            pageText.newLine();
                        }
                    }
                    double newTransY = this.graphicState.getCTM().getTranslateY();
                    double newScaleY = this.graphicState.getCTM().getScaleY();
                    if (oldTransY != newTransY) {
                        pageText.newLine();
                    } else if (Math.abs(oldScaleY) != Math.abs(newScaleY)) {
                        pageText.newLine();
                    }
                } else if (nextToken.equals("Tf")) {
                    ContentParser.consume_Tf(this.graphicState, stack, this.resources);
                } else if (nextToken.equals("TJ")) {
                    ContentParser.applyTextScaling(this.graphicState);
                    Vector v = (Vector)stack.pop();
                    float lastTextAdvance = previousAdvance;
                    for (Object currentObject : v) {
                        if (currentObject instanceof StringObject) {
                            stringObject = (StringObject)currentObject;
                            textState = this.graphicState.getTextState();
                            advance = (Point2D.Float)this.drawString(stringObject.getLiteralStringBuffer(textState.font.getSubTypeFormat(), textState.font.getFont()), advance, previousAdvance, this.graphicState.getTextState(), shapes);
                            lastTextAdvance = advance.x;
                        } else if (currentObject instanceof Number) {
                            Number f = (Number)currentObject;
                            advance.x = (float)((double)advance.x - (double)(f.floatValue() * this.graphicState.getTextState().currentfont.getSize()) / 1000.0);
                        }
                        previousAdvance = advance.x;
                    }
                } else if (nextToken.equals("TD")) {
                    float y = ((Number)stack.pop()).floatValue();
                    float x = ((Number)stack.pop()).floatValue();
                    this.graphicState.translate(-shift, 0.0);
                    shift = 0.0f;
                    previousAdvance = 0.0f;
                    advance.setLocation(0.0f, 0.0f);
                    this.graphicState.translate(x, -y);
                    this.graphicState.getTextState().leading = -y;
                    if (isYstart) {
                        yBTStart = y;
                        isYstart = false;
                    }
                    if (y != 0.0f) {
                        pageText.newLine();
                    }
                } else if (nextToken.equals("TL")) {
                    this.graphicState.getTextState().leading = ((Number)stack.pop()).floatValue();
                } else if (nextToken.equals("q")) {
                    this.graphicState = ContentParser.consume_q(this.graphicState);
                } else if (nextToken.equals("Q")) {
                    this.graphicState = ContentParser.consume_Q(this.graphicState, shapes);
                } else if (nextToken.equals("cm")) {
                    ContentParser.consume_cm(this.graphicState, stack, this.inTextBlock, this.textBlockBase);
                } else if (nextToken.equals("T*")) {
                    this.graphicState.translate(-shift, 0.0);
                    shift = 0.0f;
                    previousAdvance = 0.0f;
                    advance.setLocation(0.0f, 0.0f);
                    this.graphicState.translate(0.0, this.graphicState.getTextState().leading);
                    pageText.newLine();
                } else if (nextToken.equals("BDC")) {
                    stack.pop();
                    stack.pop();
                } else if (!nextToken.equals("EMC")) {
                    if (nextToken.equals("gs")) {
                        ContentParser.consume_gs(this.graphicState, stack, this.resources);
                    } else if (nextToken.equals("w") || nextToken.equals("LW")) {
                        ContentParser.consume_w(this.graphicState, stack, shapes);
                    } else if (nextToken.equals("sc") || nextToken.equals("scn")) {
                        ContentParser.consume_sc(this.graphicState, stack, this.library, this.resources);
                    } else if (nextToken.equals("k")) {
                        ContentParser.consume_k(this.graphicState, stack, this.library);
                    } else if (nextToken.equals("g")) {
                        ContentParser.consume_g(this.graphicState, stack, this.library);
                    } else if (nextToken.equals("i")) {
                        ContentParser.consume_i(stack);
                    } else if (nextToken.equals("M")) {
                        ContentParser.consume_M(this.graphicState, stack, shapes);
                    } else if (nextToken.equals("J")) {
                        ContentParser.consume_J(this.graphicState, stack, shapes);
                    } else if (nextToken.equals("rg")) {
                        ContentParser.consume_rg(this.graphicState, stack, this.library);
                    } else if (nextToken.equals("d")) {
                        ContentParser.consume_d(this.graphicState, stack, shapes);
                    } else if (nextToken.equals("d")) {
                        ContentParser.consume_d(this.graphicState, stack, shapes);
                    } else if (nextToken.equals("j")) {
                        ContentParser.consume_j(this.graphicState, stack, shapes);
                    } else if (nextToken.equals("cs")) {
                        ContentParser.consume_cs(this.graphicState, stack, this.resources);
                    } else if (nextToken.equals("ri")) {
                        stack.pop();
                    } else if (nextToken.equals("SC") || nextToken.equals("SCN")) {
                        ContentParser.consume_SC(this.graphicState, stack, this.library, this.resources);
                    } else if (nextToken.equals("K")) {
                        ContentParser.consume_K(this.graphicState, stack, this.library);
                    } else if (nextToken.equals("G")) {
                        ContentParser.consume_G(this.graphicState, stack, this.library);
                    } else if (nextToken.equals("RG")) {
                        ContentParser.consume_RG(this.graphicState, stack, this.library);
                    } else if (nextToken.equals("CS")) {
                        ContentParser.consume_CS(this.graphicState, stack, this.resources);
                    } else if (nextToken.equals("Tr")) {
                        this.graphicState.getTextState().rmode = (int)((Number)stack.pop()).floatValue();
                    } else if (nextToken.equals("Tz")) {
                        ContentParser.consume_Tz(this.graphicState, stack);
                    } else if (nextToken.equals("Ts")) {
                        this.graphicState.getTextState().trise = ((Number)stack.pop()).floatValue();
                    } else if (!nextToken.equals("BX") && !nextToken.equals("EX")) {
                        Point2D.Float d;
                        TextState textState2;
                        if (nextToken.equals("'")) {
                            this.graphicState.translate(-shift, this.graphicState.getTextState().leading);
                            ContentParser.applyTextScaling(this.graphicState);
                            shift = 0.0f;
                            previousAdvance = 0.0f;
                            advance.setLocation(0.0f, 0.0f);
                            StringObject stringObject2 = (StringObject)stack.pop();
                            textState2 = this.graphicState.getTextState();
                            d = (Point2D.Float)this.drawString(stringObject2.getLiteralStringBuffer(textState2.font.getSubTypeFormat(), textState2.font.getFont()), new Point2D.Float(0.0f, 0.0f), 0.0f, this.graphicState.getTextState(), shapes);
                            this.graphicState.translate(d.x, 0.0);
                            shift += d.x;
                        } else if (nextToken.equals("\"")) {
                            StringObject stringObject3 = (StringObject)stack.pop();
                            this.graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
                            this.graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
                            this.graphicState.translate(-shift, this.graphicState.getTextState().leading);
                            ContentParser.applyTextScaling(this.graphicState);
                            shift = 0.0f;
                            previousAdvance = 0.0f;
                            advance.setLocation(0.0f, 0.0f);
                            textState2 = this.graphicState.getTextState();
                            d = (Point2D.Float)this.drawString(stringObject3.getLiteralStringBuffer(textState2.font.getSubTypeFormat(), textState2.font.getFont()), new Point2D.Float(0.0f, 0.0f), 0.0f, this.graphicState.getTextState(), shapes);
                            this.graphicState.translate(d.x, 0.0);
                            shift += d.x;
                        }
                    }
                }
            } else {
                stack.push(nextToken);
            }
            nextToken = parser.getStreamObject();
        }
        while (!stack.isEmpty()) {
            String tmp = stack.pop().toString();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.warning("Text=" + tmp);
        }
        this.graphicState.set(this.textBlockBase);
        this.inTextBlock = false;
        return yBTStart;
    }

    void parseInlineImage(Parser p, Shapes shapes) throws IOException {
        try {
            Hashtable<Object, Object> iih = new Hashtable<Object, Object>();
            Object tok = p.getStreamObject();
            while (!tok.equals("ID")) {
                if (tok.equals("BPC")) {
                    tok = new Name("BitsPerComponent");
                } else if (tok.equals("CS")) {
                    tok = new Name("ColorSpace");
                } else if (tok.equals("D")) {
                    tok = new Name("Decode");
                } else if (tok.equals("DP")) {
                    tok = new Name("DecodeParms");
                } else if (tok.equals("F")) {
                    tok = new Name("Filter");
                } else if (tok.equals("H")) {
                    tok = new Name("Height");
                } else if (tok.equals("IM")) {
                    tok = new Name("ImageMask");
                } else if (tok.equals("I")) {
                    tok = new Name("Indexed");
                } else if (tok.equals("W")) {
                    tok = new Name("Width");
                }
                Object tok1 = p.getStreamObject();
                iih.put(tok, tok1);
                tok = p.getStreamObject();
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream(4096);
            tok = p.peek2();
            boolean ateEI = false;
            while (tok != null && !tok.equals(" EI") && !(ateEI = p.readLineForInlineImage(buf))) {
                tok = p.peek2();
            }
            if (!ateEI) {
                p.getToken();
            }
            buf.flush();
            buf.close();
            byte[] data = buf.toByteArray();
            SeekableByteArrayInputStream sbais = new SeekableByteArrayInputStream(data);
            SeekableInputConstrainedWrapper streamInputWrapper = new SeekableInputConstrainedWrapper(sbais, 0L, data.length, true);
            Stream st = new Stream(this.library, iih, streamInputWrapper);
            st.setInlineImage(true);
            BufferedImage im = st.getImage(this.graphicState.getFillColor(), this.resources, true);
            st.dispose(false);
            AffineTransform af = new AffineTransform(this.graphicState.getCTM());
            this.graphicState.scale(1.0, -1.0);
            this.graphicState.translate(0.0, -1.0);
            shapes.add(im);
            this.graphicState.set(af);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Error parsing inline image.", e);
        }
    }

    private static void consume_G(GraphicsState graphicState, Stack stack, Library library) {
        float gray = ((Number)stack.pop()).floatValue();
        graphicState.setStrokeColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceGray")));
        graphicState.setStrokeColor(new Color(gray, gray, gray));
    }

    private static void consume_g(GraphicsState graphicState, Stack stack, Library library) {
        float gray = ((Number)stack.pop()).floatValue();
        graphicState.setFillColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceGray")));
        graphicState.setFillColor(new Color(gray, gray, gray));
    }

    private static void consume_RG(GraphicsState graphicState, Stack stack, Library library) {
        float b = ((Number)stack.pop()).floatValue();
        float gg = ((Number)stack.pop()).floatValue();
        float r = ((Number)stack.pop()).floatValue();
        b = Math.max(0.0f, Math.min(1.0f, b));
        gg = Math.max(0.0f, Math.min(1.0f, gg));
        r = Math.max(0.0f, Math.min(1.0f, r));
        graphicState.setStrokeColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceRGB")));
        graphicState.setStrokeColor(new Color(r, gg, b));
    }

    private static void consume_rg(GraphicsState graphicState, Stack stack, Library library) {
        float b = ((Number)stack.pop()).floatValue();
        float gg = ((Number)stack.pop()).floatValue();
        float r = ((Number)stack.pop()).floatValue();
        b = Math.max(0.0f, Math.min(1.0f, b));
        gg = Math.max(0.0f, Math.min(1.0f, gg));
        r = Math.max(0.0f, Math.min(1.0f, r));
        graphicState.setFillColorSpace(PColorSpace.getColorSpace(library, new Name("DeviceRGB")));
        graphicState.setFillColor(new Color(r, gg, b));
    }

    private static void consume_K(GraphicsState graphicState, Stack stack, Library library) {
        float k = ((Number)stack.pop()).floatValue();
        float y = ((Number)stack.pop()).floatValue();
        float m = ((Number)stack.pop()).floatValue();
        float c = ((Number)stack.pop()).floatValue();
        PColorSpace pColorSpace = PColorSpace.getColorSpace(library, new Name("DeviceCMYK"));
        graphicState.setStrokeColorSpace(pColorSpace);
        graphicState.setStrokeColor(pColorSpace.getColor(PColorSpace.reverse(new float[]{c, m, y, k})));
    }

    private static void consume_k(GraphicsState graphicState, Stack stack, Library library) {
        float k = ((Number)stack.pop()).floatValue();
        float y = ((Number)stack.pop()).floatValue();
        float m = ((Number)stack.pop()).floatValue();
        float c = ((Number)stack.pop()).floatValue();
        PColorSpace pColorSpace = PColorSpace.getColorSpace(library, new Name("DeviceCMYK"));
        graphicState.setFillColorSpace(pColorSpace);
        graphicState.setFillColor(pColorSpace.getColor(PColorSpace.reverse(new float[]{c, m, y, k})));
    }

    private static void consume_CS(GraphicsState graphicState, Stack stack, Resources resources) {
        Name n = (Name)stack.pop();
        graphicState.setStrokeColorSpace(resources.getColorSpace(n));
    }

    private static void consume_cs(GraphicsState graphicState, Stack stack, Resources resources) {
        Name n = (Name)stack.pop();
        graphicState.setFillColorSpace(resources.getColorSpace(n));
    }

    private static void consume_SC(GraphicsState graphicState, Stack stack, Library library, Resources resources) {
        Object o = stack.peek();
        if (o instanceof Name) {
            TilingPattern tilingPattern;
            PatternColor pc;
            Name patternName = (Name)stack.pop();
            Pattern pattern = resources.getPattern(patternName.toString());
            if (graphicState.getStrokeColorSpace() instanceof PatternColor) {
                pc = (PatternColor)graphicState.getStrokeColorSpace();
                pc.setPattern(pattern);
            } else {
                pc = new PatternColor(null, null);
                pc.setPattern(pattern);
                graphicState.setStrokeColorSpace(pc);
            }
            if (pattern instanceof TilingPattern && (tilingPattern = (TilingPattern)pattern).getPaintType() == 2) {
                int compLength = graphicState.getStrokeColorSpace().getNumComponents();
                float[] colour = new float[compLength];
                for (int nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                    colour[nCount] = ((Number)stack.pop()).floatValue();
                }
                tilingPattern.setUnColored(graphicState.getStrokeColorSpace().getColor(colour));
            }
        } else if (o instanceof Number) {
            int nCount;
            int colorSpaceN = graphicState.getStrokeColorSpace().getNumComponents();
            int compLength = 4;
            float[] colour = new float[compLength];
            for (nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                colour[nCount] = ((Number)stack.pop()).floatValue();
            }
            if (nCount != colorSpaceN) {
                graphicState.setStrokeColorSpace(PColorSpace.getColorSpace(library, nCount));
            }
            float[] f = new float[nCount];
            System.arraycopy(colour, 0, f, 0, nCount);
            graphicState.setStrokeColor(graphicState.getStrokeColorSpace().getColor(f));
        }
    }

    private static void consume_sc(GraphicsState graphicState, Stack stack, Library library, Resources resources) {
        Object o = stack.peek();
        if (o instanceof Name) {
            TilingPattern tilingPattern;
            PatternColor pc;
            Name patternName = (Name)stack.pop();
            Pattern pattern = resources.getPattern(patternName.toString());
            if (graphicState.getFillColorSpace() instanceof PatternColor) {
                pc = (PatternColor)graphicState.getFillColorSpace();
                pc.setPattern(pattern);
            } else {
                pc = new PatternColor(library, null);
                pc.setPattern(pattern);
                graphicState.setFillColorSpace(pc);
            }
            if (pattern instanceof TilingPattern && (tilingPattern = (TilingPattern)pattern).getPaintType() == 2) {
                int compLength = graphicState.getFillColorSpace().getNumComponents();
                float[] colour = new float[compLength];
                for (int nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                    colour[nCount] = ((Number)stack.pop()).floatValue();
                }
                graphicState.setFillColor(graphicState.getFillColorSpace().getColor(colour));
            }
        } else if (o instanceof Number) {
            int nCount;
            int colorSpaceN = graphicState.getFillColorSpace().getNumComponents();
            int compLength = 4;
            float[] colour = new float[compLength];
            for (nCount = 0; !stack.isEmpty() && stack.peek() instanceof Number && nCount < compLength; ++nCount) {
                colour[nCount] = ((Number)stack.pop()).floatValue();
            }
            if (nCount != colorSpaceN) {
                graphicState.setFillColorSpace(PColorSpace.getColorSpace(library, nCount));
            }
            float[] f = new float[nCount];
            System.arraycopy(colour, 0, f, 0, nCount);
            graphicState.setFillColor(graphicState.getFillColorSpace().getColor(f));
        }
    }

    private static GraphicsState consume_q(GraphicsState graphicState) {
        return graphicState.save();
    }

    private static GraphicsState consume_Q(GraphicsState graphicState, Shapes shapes) {
        GraphicsState gs1 = graphicState.restore();
        if (gs1 != null) {
            graphicState = gs1;
        } else {
            graphicState = new GraphicsState(shapes);
            graphicState.set(new AffineTransform());
            shapes.addNoClipCommand();
        }
        return graphicState;
    }

    private static void consume_cm(GraphicsState graphicState, Stack stack, boolean inTextBlock, AffineTransform textBlockBase) {
        float f = ((Number)stack.pop()).floatValue();
        float e = ((Number)stack.pop()).floatValue();
        float d = ((Number)stack.pop()).floatValue();
        float c = ((Number)stack.pop()).floatValue();
        float b = ((Number)stack.pop()).floatValue();
        float a = ((Number)stack.pop()).floatValue();
        if (!inTextBlock) {
            AffineTransform af = new AffineTransform(graphicState.getCTM());
            af.concatenate(new AffineTransform(a, b, c, d, e, f));
            graphicState.set(af);
            graphicState.updateClipCM(new AffineTransform(a, b, c, d, e, f));
        } else {
            textBlockBase.concatenate(new AffineTransform(a, b, c, d, e, f));
        }
    }

    private static void consume_i(Stack stack) {
        stack.pop();
    }

    private static void consume_J(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setLineCap((int)((Number)stack.pop()).floatValue());
        if (graphicState.getLineCap() == 0) {
            graphicState.setLineCap(0);
        } else if (graphicState.getLineCap() == 1) {
            graphicState.setLineCap(1);
        } else if (graphicState.getLineCap() == 2) {
            graphicState.setLineCap(2);
        }
        ContentParser.setStroke(shapes, graphicState);
    }

    private static void consume_d(GraphicsState graphicState, Stack stack, Shapes shapes) {
        try {
            float[] dashArray;
            float dashPhase = ((Number)stack.pop()).floatValue();
            Vector dashVector = (Vector)stack.pop();
            if (dashVector.size() > 0) {
                int sz = dashVector.size();
                dashArray = new float[sz];
                for (int i = 0; i < sz; ++i) {
                    dashArray[i] = ((Number)dashVector.get(i)).floatValue();
                }
            } else {
                dashPhase = 0.0f;
                dashArray = null;
            }
            graphicState.setDashArray(dashArray);
            graphicState.setDashPhase(dashPhase);
        }
        catch (ClassCastException e) {
            logger.log(Level.FINE, "Dash pattern syntax error: ", e);
        }
        ContentParser.setStroke(shapes, graphicState);
    }

    private static void consume_j(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setLineJoin((int)((Number)stack.pop()).floatValue());
        if (graphicState.getLineJoin() == 0) {
            graphicState.setLineJoin(0);
        } else if (graphicState.getLineJoin() == 1) {
            graphicState.setLineJoin(1);
        } else if (graphicState.getLineJoin() == 2) {
            graphicState.setLineJoin(2);
        }
        ContentParser.setStroke(shapes, graphicState);
    }

    private static void consume_w(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setLineWidth(((Number)stack.pop()).floatValue());
        ContentParser.setStroke(shapes, graphicState);
    }

    private static void consume_M(GraphicsState graphicState, Stack stack, Shapes shapes) {
        graphicState.setMiterLimit(((Number)stack.pop()).floatValue());
        ContentParser.setStroke(shapes, graphicState);
    }

    private static void consume_gs(GraphicsState graphicState, Stack stack, Resources resources) {
        ExtGState extGState;
        Object gs = stack.pop();
        if (gs instanceof Name && (extGState = resources.getExtGState(((Name)gs).getName())) != null) {
            graphicState.concatenate(extGState);
        }
    }

    private static void consume_Tf(GraphicsState graphicState, Stack stack, Resources resources) {
        float size = ((Number)stack.pop()).floatValue();
        Name name2 = (Name)stack.pop();
        graphicState.getTextState().font = resources.getFont(name2.getName());
        graphicState.getTextState().currentfont = graphicState.getTextState().font.getFont().deriveFont(size);
    }

    private static void consume_Tc(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().cspace = ((Number)stack.pop()).floatValue();
    }

    private static void consume_Tz(GraphicsState graphicState, Stack stack) {
        Object ob = stack.pop();
        if (ob instanceof Number) {
            float hScaling = ((Number)ob).floatValue();
            graphicState.getTextState().hScalling = hScaling / 100.0f;
        }
    }

    private static void consume_Tw(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().wspace = ((Number)stack.pop()).floatValue();
    }

    private static void consume_Tr(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().rmode = (int)((Number)stack.pop()).floatValue();
    }

    private static void consume_TL(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().leading = ((Number)stack.pop()).floatValue();
    }

    private static void consume_Ts(GraphicsState graphicState, Stack stack) {
        graphicState.getTextState().trise = ((Number)stack.pop()).floatValue();
    }

    private Point2D drawString(StringBuilder displayText, Point2D advance, float previousAdvance, TextState textState, Shapes shapes) {
        float advanceX = ((Point2D.Float)advance).x;
        float advanceY = ((Point2D.Float)advance).y;
        if (displayText.length() == 0) {
            return new Point2D.Float(0.0f, 0.0f);
        }
        float lastx = 0.0f;
        float lasty = 0.0f;
        char currentChar = displayText.charAt(0);
        float firstCharWidth = (float)textState.currentfont.echarAdvance(currentChar).getX();
        if (advanceX + firstCharWidth < previousAdvance) {
            advanceX = previousAdvance;
        }
        FontFile currentFont = textState.currentfont;
        boolean isVerticalWriting = textState.font.isVerticalWriting();
        float textRise = textState.trise;
        float charcterSpace = textState.cspace;
        float whiteSpace = textState.wspace;
        int textLength = displayText.length();
        TextSprite textSprites = new TextSprite(currentFont, textLength, new AffineTransform(this.graphicState.getCTM()));
        for (int i = 0; i < textLength; ++i) {
            float currentY;
            float currentX;
            float newAdvanceX;
            currentChar = displayText.charAt(i);
            float newAdvanceY = newAdvanceX = (float)currentFont.echarAdvance(currentChar).getX();
            if (!isVerticalWriting) {
                currentX = advanceX + lastx;
                currentY = lasty - textRise;
                lastx += newAdvanceX;
                lastx += charcterSpace;
                if (displayText.charAt(i) == ' ') {
                    lastx += whiteSpace;
                }
            } else {
                currentX = advanceX - newAdvanceX / 2.0f;
                currentY = advanceY + (lasty += newAdvanceY - textRise);
            }
            char charValue = textState.currentfont.toUnicode(currentChar);
            GlyphText glyphText = textSprites.addText(currentChar, charValue, currentX, currentY, newAdvanceX);
            shapes.getPageText().addGlyph(glyphText);
        }
        advanceX += lastx;
        advanceY += lasty;
        int rmode = textState.rmode;
        switch (rmode) {
            case 0: {
                this.drawModeFill(textSprites, shapes, rmode);
                break;
            }
            case 1: {
                this.drawModeStroke(textSprites, textState, shapes, rmode);
                break;
            }
            case 2: {
                this.drawModeFillStroke(textSprites, textState, shapes, rmode);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.drawModeFill(textSprites, shapes, rmode);
                break;
            }
            case 5: {
                this.drawModeStroke(textSprites, textState, shapes, rmode);
                break;
            }
            case 6: {
                this.drawModeFillStroke(textSprites, textState, shapes, rmode);
                break;
            }
            case 7: {
                textSprites.setRMode(rmode);
                shapes.add(textSprites);
            }
        }
        return new Point2D.Float(advanceX, advanceY);
    }

    private void drawModeFill(TextSprite textSprites, Shapes shapes, int rmode) {
        textSprites.setRMode(rmode);
        shapes.add(this.graphicState.getFillColor());
        shapes.add(textSprites);
    }

    private void drawModeStroke(TextSprite textSprites, TextState textState, Shapes shapes, int rmode) {
        textSprites.setRMode(rmode);
        textSprites.setStrokeColor(this.graphicState.getStrokeColor());
        float old = this.graphicState.getLineWidth();
        float lineWidth = this.graphicState.getLineWidth();
        lineWidth = (float)((double)lineWidth / textState.tmatrix.getScaleX());
        this.graphicState.setLineWidth(lineWidth);
        ContentParser.setStroke(shapes, this.graphicState);
        shapes.add(this.graphicState.getStrokeColor());
        shapes.add(textSprites);
        this.graphicState.setLineWidth(old);
        ContentParser.setStroke(shapes, this.graphicState);
    }

    private void drawModeFillStroke(TextSprite textSprites, TextState textState, Shapes shapes, int rmode) {
        textSprites.setRMode(rmode);
        textSprites.setStrokeColor(this.graphicState.getStrokeColor());
        float old = this.graphicState.getLineWidth();
        float lineWidth = this.graphicState.getLineWidth();
        lineWidth = (float)((double)lineWidth / textState.tmatrix.getScaleX());
        this.graphicState.setLineWidth(lineWidth);
        ContentParser.setStroke(shapes, this.graphicState);
        shapes.add(this.graphicState.getFillColor());
        shapes.add(textSprites);
        this.graphicState.setLineWidth(old);
        ContentParser.setStroke(shapes, this.graphicState);
    }

    private static void commonStroke(GraphicsState graphicState, Shapes shapes, GeneralPath geometricPath) {
        if (graphicState.isOverprintStroking()) {
            ContentParser.setAlpha(shapes, ContentParser.commonOverPrintAlpha(graphicState.getStrokeAlpha()));
        }
        if (graphicState.getFillColorSpace() instanceof PatternColor) {
            PatternColor patternColor = (PatternColor)graphicState.getFillColorSpace();
            Pattern pattern = patternColor.getPattern();
            if (pattern != null && pattern.getPatternType() == 1) {
                TilingPattern tilingPattern = (TilingPattern)pattern;
                if (tilingPattern.getPaintType() == 2) {
                    ContentParser.setAlpha(shapes, graphicState.getFillAlpha());
                    shapes.add(tilingPattern.getUnColored());
                    shapes.add(geometricPath);
                    shapes.addDrawCommand();
                } else if (tilingPattern.getPaintType() == 1) {
                    ContentParser.setAlpha(shapes, graphicState.getFillAlpha());
                    shapes.add(tilingPattern.getFirstColor());
                    shapes.add(geometricPath);
                    shapes.addDrawCommand();
                }
            } else if (pattern != null && pattern.getPatternType() == 2) {
                pattern.init();
                ContentParser.setAlpha(shapes, graphicState.getFillAlpha());
                shapes.add(pattern.getPaint());
                shapes.add(geometricPath);
                shapes.addDrawCommand();
            }
        } else {
            ContentParser.setAlpha(shapes, graphicState.getStrokeAlpha());
            shapes.add(graphicState.getStrokeColor());
            shapes.add(geometricPath);
            shapes.addDrawCommand();
        }
        if (graphicState.isOverprintStroking()) {
            ContentParser.setAlpha(shapes, graphicState.getFillAlpha());
        }
    }

    private static float commonOverPrintAlpha(float alpha) {
        if (alpha != 1.0f && alpha > 0.4f) {
            alpha -= 0.4f;
        } else if (!(alpha < 0.4f)) {
            alpha = 0.4f;
        }
        return alpha;
    }

    private void commonFill(Shapes shapes, GeneralPath geometricPath) {
        if (this.graphicState.isOverprintOther()) {
            ContentParser.setAlpha(shapes, ContentParser.commonOverPrintAlpha(this.graphicState.getFillAlpha()));
        } else {
            ContentParser.setAlpha(shapes, this.graphicState.getFillAlpha());
        }
        if (this.graphicState.getFillColorSpace() instanceof PatternColor) {
            PatternColor patternColor = (PatternColor)this.graphicState.getFillColorSpace();
            Pattern pattern = patternColor.getPattern();
            if (pattern != null && pattern.getPatternType() == 1) {
                TilingPattern tilingPattern = (TilingPattern)pattern;
                if (tilingPattern.getPaintType() == 2) {
                    shapes.add(tilingPattern.getUnColored());
                    shapes.add(geometricPath);
                    shapes.addFillCommand();
                } else if (tilingPattern.getPaintType() == 1) {
                    tilingPattern.init();
                    shapes.add(tilingPattern.getFirstColor());
                    shapes.add(geometricPath);
                    shapes.addFillCommand();
                }
            } else if (pattern != null && pattern.getPatternType() == 2) {
                pattern.init();
                shapes.add(pattern.getPaint());
                shapes.add(geometricPath);
                shapes.addFillCommand();
            }
        } else {
            shapes.add(this.graphicState.getFillColor());
            shapes.add(geometricPath);
            shapes.addFillCommand();
        }
        if (this.graphicState.isOverprintOther()) {
            ContentParser.setAlpha(shapes, this.graphicState.getFillAlpha());
        }
    }

    static void setStroke(Shapes shapes, GraphicsState graphicState) {
        shapes.add(new BasicStroke(graphicState.getLineWidth(), graphicState.getLineCap(), graphicState.getLineJoin(), graphicState.getMiterLimit(), graphicState.getDashArray(), graphicState.getDashPhase()));
    }

    private static void applyTextScaling(GraphicsState graphicState) {
        AffineTransform horizontalScalingTransform = new AffineTransform(graphicState.getTextState().hScalling, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        AffineTransform af = new AffineTransform(graphicState.getCTM());
        af.concatenate(horizontalScalingTransform);
        graphicState.set(af);
    }

    static void setAlpha(Shapes shapes, float alpha) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, alpha);
        shapes.add(alphaComposite);
    }
}

