/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.svc.Services;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ProcessUtil {
    public static final String CURRENT_STATE = "exo:currentState";
    public static final String CURRENT_LOCATION = "exo:currentLocation";
    public static final String REQUEST_FOR_VALIDATION = "Request For Validation";
    public static final String VALIDATED = "Validated";
    public static final String PENDING = "Waiting For Publishing";
    public static final String REFUSED = "Refused";
    public static final String DISAPPROVED = "Disapproved";
    public static final String DELEGATED = "Delegated";
    public static final String ABORTED = "Aborted";
    public static final String EXPIRED = "Expired";
    public static final String LIVE = "Live";
    public static final String BACKUP = "Backup";
    public static final String IN_TRASH = "In Trash";
    public static final String EXO_PUBLISH_LOCATION = "exo:publishLocation";
    public static final String EXO_PENDING_LOCATION = "exo:pendingLocation";
    public static final String EXO_BACKUP_LOCATION = "exo:backupLocation";
    public static final String EXO_TRASH_LOCATION = "exo:trashLocation";
    public static final String ACTION_REASON = "exo:actionComment";
    public static final int REPOSITORY_INDEX = 0;
    public static final int WORKSPACE_INDEX = 1;
    public static final int PATH_INDEX = 2;
    public static final String EXO_VALIDATIONREQUEST = "exo:validationRequest";
    public static final String EXO_CONENT_STATE = "exo:publishingState";
    public static final String CURRENT_STATE_PROP = "exo:currentState";
    public static final String CURRENT_WORKSPACE_PROP = "exo:currentWorkspace";
    public static final String CURRENT_REPOSITORY_PROP = "exo:currentRepository";
    public static final String CURRENT_PATH_PROP = "exo:currentPath";
    private static Log log = ExoLogger.getLogger(ProcessUtil.class);

    public static void createTimer(ExecutionContext context, Timer timer) {
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService((String)"scheduler");
        schedulerService.createTimer(timer);
    }

    public static void deleteTimer(ExecutionContext context, String timer, Token token) {
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService((String)"scheduler");
        schedulerService.deleteTimersByName(timer, token);
    }

    public static void requestForValidation(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Request For Validation");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        try {
            Node requestNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)WCMCoreUtils.getUserSessionProvider());
            if (!requestNode.isNodeType("exo:publishingState")) {
                requestNode.addMixin("exo:publishingState");
            }
            if (requestNode.isNodeType("exo:publishingState")) {
                requestNode.setProperty("exo:currentState", "Request For Validation");
            }
            if (!requestNode.isNodeType("exo:validationRequest")) {
                requestNode.addMixin("exo:validationRequest");
            }
            if (requestNode.isNodeType("exo:validationRequest")) {
                String requester = ((ExtendedNode)requestNode).getProperty("exo:owner").getString();
                requestNode.setProperty("exo:requester", requester);
                requestNode.setProperty("exo:requestDate", (Calendar)new GregorianCalendar());
            }
            requestNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static void approve(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Validated");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        try {
            Node validatedNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)WCMCoreUtils.getUserSessionProvider());
            if (!validatedNode.isNodeType("exo:approved")) {
                validatedNode.addMixin("exo:approved");
            }
            if (validatedNode.isNodeType("exo:approved")) {
                validatedNode.setProperty("exo:approver", ProcessUtil.getActorId((ExecutionContext)context));
                validatedNode.setProperty("exo:approvedDate", (Calendar)new GregorianCalendar());
                String approveComment = (String)context.getVariable("exo:actionComment");
                if (approveComment != null && approveComment.length() != 0) {
                    validatedNode.setProperty("exo:approvedComment", approveComment);
                }
            }
            validatedNode.setProperty("exo:currentState", "Approved");
            validatedNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public static void disapprove(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Disapproved");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        try {
            Node disapprovedNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)WCMCoreUtils.getUserSessionProvider());
            if (!disapprovedNode.isNodeType("exo:disapproved")) {
                disapprovedNode.addMixin("exo:disapproved");
            }
            if (disapprovedNode.isNodeType("exo:disapproved")) {
                disapprovedNode.setProperty("exo:contradictor", ProcessUtil.getActorId((ExecutionContext)context));
                disapprovedNode.setProperty("exo:disaprovedDate", (Calendar)new GregorianCalendar());
                String approveComment = (String)context.getVariable("exo:actionComment");
                if (approveComment != null && approveComment.length() != 0) {
                    disapprovedNode.setProperty("exo:disapprovedReason", approveComment);
                }
                disapprovedNode.setProperty("exo:currentState", "Disapproved");
            }
            disapprovedNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publish(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Disapproved");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node publishedNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!publishedNode.isNodeType("exo:published")) {
                publishedNode.addMixin("exo:published");
            }
            if (publishedNode.isNodeType("exo:published")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                Date startDate = dateFormat.parse(context.getVariable("startDate").toString());
                Date endDate = dateFormat.parse(context.getVariable("endDate").toString());
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(startDate);
                publishedNode.setProperty("exo:startPublication", (Calendar)calendar);
                if (endDate != null) {
                    calendar.setTime(endDate);
                    publishedNode.setProperty("exo:endPublication", (Calendar)new GregorianCalendar());
                }
            }
            publishedNode.setProperty("exo:currentState", "Live");
            publishedNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForPublish(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Waiting For Publishing");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node pendingNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!pendingNode.isNodeType("exo:pending")) {
                pendingNode.addMixin("exo:pending");
            }
            if (pendingNode.isNodeType("exo:pending")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                Date startDate = dateFormat.parse(context.getVariable("startDate").toString());
                pendingNode.setProperty("exo:pendingStart", (Calendar)new GregorianCalendar());
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(startDate);
                pendingNode.setProperty("exo:pendingEnd", (Calendar)calendar);
                pendingNode.setProperty("exo:currentState", "Waiting For Publishing");
            }
            pendingNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            provider.close();
        }
    }

    public static void delegate(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Delegated");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = WCMCoreUtils.getRepository().getConfiguration().getName();
        String workspace = location[1];
        String path = location[2];
        try {
            Node delegateNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)WCMCoreUtils.getUserSessionProvider());
            if (!delegateNode.isNodeType("exo:delegated")) {
                delegateNode.addMixin("exo:delegated");
            }
            if (delegateNode.isNodeType("exo:delegated")) {
                delegateNode.setProperty("exo:assigner", ProcessUtil.getActorId((ExecutionContext)context));
                delegateNode.setProperty("exo:delegatedDate", (Calendar)new GregorianCalendar());
                String delegator = (String)context.getVariable("delegator");
                delegateNode.setProperty("exo:delegator", delegator);
                String delegatedComment = (String)context.getVariable("exo:actionComment");
                if (delegatedComment != null && delegatedComment.length() != 0) {
                    delegateNode.setProperty("exo:delegatedComment", delegatedComment);
                }
            }
            delegateNode.setProperty("exo:currentState", "Delegated");
            delegateNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backup(ExecutionContext context) {
        context.setVariable("exo:currentState", (Object)"Backup");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node backupNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!backupNode.isNodeType("exo:backup")) {
                backupNode.addMixin("exo:backup");
            }
            if (backupNode.isNodeType("exo:backup")) {
                backupNode.setProperty("exo:backupDate", (Calendar)new GregorianCalendar());
                backupNode.setProperty("exo:backupReason", "DOCUMENT EXPIRED");
            }
            backupNode.setProperty("exo:currentState", "Backup");
            backupNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveTrash(ExecutionContext context) {
        String sourceTransition = (String)context.getVariable("exo:currentState");
        context.setVariable("exo:currentState", (Object)"In Trash");
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String workspace = location[1];
        String path = location[2];
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node trashNode = ProcessUtil.getNode((ExecutionContext)context, (String)repository, (String)workspace, (String)path, (SessionProvider)provider);
            if (!trashNode.isNodeType("exo:trashMovement")) {
                trashNode.addMixin("exo:trashMovement");
            }
            if (trashNode.isNodeType("exo:trashMovement")) {
                trashNode.setProperty("exo:moveDate", (Calendar)new GregorianCalendar());
                trashNode.setProperty("exo:moveReason", sourceTransition);
            }
            trashNode.setProperty("exo:currentState", "In Trash");
            trashNode.getSession().save();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            provider.close();
        }
    }

    @Deprecated
    public static Node getNode(ExecutionContext context, String repositoryName, String workspace, String path, SessionProvider provider) throws Exception {
        RepositoryService repositoryService = (RepositoryService)ProcessUtil.getService((ExecutionContext)context, RepositoryService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        Session session = provider.getSession(workspace, repository);
        return (Node)session.getItem(path);
    }

    public static Node getNode(ExecutionContext context, String workspace, String path, SessionProvider provider) throws Exception {
        RepositoryService repositoryService = (RepositoryService)ProcessUtil.getService((ExecutionContext)context, RepositoryService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        Session session = provider.getSession(workspace, repository);
        return (Node)session.getItem(path);
    }

    public static String getActorId(ExecutionContext context) {
        return (String)context.getVariable("initiator");
    }

    public static void setCurrentLocation(ExecutionContext context, String currentWorkspace, String currentPath) {
        String repository = (String)context.getVariable("repository");
        StringBuilder locationBuilder = new StringBuilder();
        locationBuilder.append(repository).append("::").append(currentWorkspace).append("::").append(currentPath);
        context.setVariable("exo:currentLocation", (Object)locationBuilder.toString());
    }

    public static String[] getCurrentLocation(ExecutionContext context) {
        String currentLocation = (String)context.getVariable("exo:currentLocation");
        return currentLocation.split("::");
    }

    public static <T> T getService(ExecutionContext context, Class<T> type) {
        ContextInstance contextInstance = context.getContextInstance();
        ExoContainer container = ExoContainerContext.getContainerByName((String)((String)contextInstance.getVariable("exocontainer")));
        return type.cast(container.getComponentInstanceOfType(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAuthor(ExecutionContext context) {
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Node node = ProcessUtil.getNode((ExecutionContext)context, (String)location[0], (String)location[1], (String)location[2], (SessionProvider)provider);
            String string = node.getProperty("exo:owner").getString();
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            provider.close();
        }
        return ProcessUtil.getActorId((ExecutionContext)context);
    }

    public static String computeDestinationPath(ExecutionContext context, String srcPath, String destPath) {
        String datePath = ProcessUtil.getDateLocation((ExecutionContext)context);
        String nodeName = srcPath.substring(srcPath.lastIndexOf("/") + 1);
        String realDestPath = destPath.endsWith("/") ? destPath.concat(datePath).concat(nodeName) : destPath.concat("/").concat(datePath).concat(nodeName);
        return realDestPath;
    }

    public static String getDateLocation(ExecutionContext context) {
        LocaleConfigService configService = (LocaleConfigService)ProcessUtil.getService((ExecutionContext)context, LocaleConfigService.class);
        Locale locale = configService.getDefaultLocaleConfig().getLocale();
        GregorianCalendar calendar = new GregorianCalendar(locale);
        String[] monthNames = new DateFormatSymbols().getMonths();
        String currentYear = Integer.toString(calendar.get(1));
        String currentMonth = monthNames[calendar.get(2)];
        int weekday = calendar.get(7);
        int diff = 2 - weekday;
        ((Calendar)calendar).add(5, diff);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        String startDateOfWeek = dateFormat.format(calendar.getTime());
        String[] arrStartDate = startDateOfWeek.split("/");
        String startWeekDay = arrStartDate[0];
        ((Calendar)calendar).add(5, 6);
        String endDateOfWeek = dateFormat.format(calendar.getTime());
        String[] arrEndDate = endDateOfWeek.split("/");
        String endWeekDay = arrEndDate[0];
        StringBuilder builder = new StringBuilder();
        builder.append(currentYear).append("/").append(currentMonth).append("/").append(startWeekDay).append(" ").append(currentMonth).append("-").append(endWeekDay).append(" ").append(currentMonth).append(" ").append(currentYear).append("/");
        return builder.toString();
    }
}

