/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.div;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.wiki.rendering.macro.MacroUtils;
import org.exoplatform.wiki.rendering.macro.div.DivParameters;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="div")
public class DivMacro
extends AbstractMacro<DivParameters> {
    private static final String CLASS_ATT = "class";
    private static final String STYLE_ATT = "style";
    private static final String DESCRIPTION = "Decorate paragraph line";
    @Requirement
    private ComponentManager componentManager;

    public DivMacro() {
        super("Div", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(), DivParameters.class);
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(DivParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (content != null) {
            String cssClass = parameters.getCssClass();
            String cssContent = parameters.getStyle();
            HashMap<String, String> params = new HashMap<String, String>();
            if (!StringUtils.isEmpty((String)cssClass) && !StringUtils.isEmpty((String)cssClass)) {
                params.put(CLASS_ATT, cssClass);
            }
            if (!StringUtils.isEmpty((String)cssContent)) {
                params.put(STYLE_ATT, cssContent);
            }
            List<Block> contentBlocks = MacroUtils.parseSourceSyntax(this.getComponentManager(), content, context);
            new ParserUtils().removeTopLevelParagraph(contentBlocks);
            ParagraphBlock spanBlock = new ParagraphBlock(contentBlocks, params);
            return Collections.singletonList(spanBlock);
        }
        return Collections.emptyList();
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }
}

