/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.jcr;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Value;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Log LOG = ExoLogger.getLogger(Util.class);
    private static final String SLASH_STR = "/";

    public static String getPropertiesNamePattern(String[] propertyNames) {
        Validate.notEmpty((Object[])propertyNames, (String)"propertyNames must not be empty");
        StringBuilder sb = new StringBuilder(256);
        sb.append(propertyNames[0]);
        for (int i = 1; i < propertyNames.length; ++i) {
            sb.append('|').append(propertyNames[i]);
        }
        return sb.toString();
    }

    public static String[] convertValuesToStrings(Value[] values) throws Exception {
        if (values.length == 1) {
            return new String[]{values[0].getString()};
        }
        String[] strArray = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strArray[i] = values[i].getString();
        }
        return strArray;
    }

    public static String[] convertMapToStrings(Map<String, String> templateParams) {
        if (templateParams == null) {
            return null;
        }
        Set<String> keys = templateParams.keySet();
        String[] result = new String[keys.size()];
        int i = 0;
        for (String key : keys) {
            result[i++] = key + "=" + templateParams.get(key);
        }
        return result;
    }

    public static Map<String, String> convertValuesToMap(Value[] values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Value value : values) {
            try {
                String val = value.getString();
                int equalIndex = val.indexOf("=");
                if (equalIndex <= 0) continue;
                result.put(val.split("=")[0], val.substring(equalIndex + 1));
            }
            catch (Exception e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static <T> T[] convertListToArray(List<T> list, Class<T> type) {
        return list.toArray((Object[])Array.newInstance(type, list.size()));
    }
}

