/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.stack.Protocol;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ReconciliationTest
extends ChannelTestBase {
    private JChannel c1;
    private JChannel c2;
    private List<JChannel> channels;
    private List<MyReceiver> receivers;

    public ReconciliationTest() {
    }

    public ReconciliationTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    @Override
    public void tearDown() throws Exception {
        if (this.channels != null) {
            for (JChannel channel : this.channels) {
                channel.close();
            }
        }
        Util.sleep(500L);
        super.tearDown();
    }

    @Override
    public boolean useBlocking() {
        return true;
    }

    public void testReconciliationFlushTriggeredByNewMemberJoin() throws Exception {
        FlushTrigger t = new FlushTrigger(){

            @Override
            public void triggerFlush() {
                ReconciliationTest.this.log.info((Object)"Joining D, this will trigger FLUSH and a subsequent view change to {A,B,C,D}");
                try {
                    JChannel newChannel = ReconciliationTest.this.createChannel();
                    newChannel.connect("x");
                    ReconciliationTest.this.channels.add(newChannel);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        String[] apps = this.createApplicationNames(3);
        this.reconciliationHelper(apps, t);
    }

    public void testReconciliationFlushTriggeredByManualFlush() throws Exception {
        FlushTrigger t = new FlushTrigger(){

            @Override
            public void triggerFlush() {
                JChannel channel = (JChannel)ReconciliationTest.this.channels.get(0);
                boolean rc = Util.startFlush(channel);
                ReconciliationTest.this.log.info((Object)("manual flush success=" + rc));
                channel.stopFlush();
            }
        };
        String[] apps = this.createApplicationNames(3);
        this.reconciliationHelper(apps, t);
    }

    public void testReconciliationFlushTriggeredByMemberCrashing() throws Exception {
        FlushTrigger t = new FlushTrigger(){

            @Override
            public void triggerFlush() {
                JChannel channel = (JChannel)ReconciliationTest.this.channels.remove(ReconciliationTest.this.channels.size() - 1);
                channel.shutdown();
            }
        };
        String[] apps = this.createApplicationNames(3);
        this.reconciliationHelper(apps, t);
    }

    public void reconciliationHelper(String[] names, FlushTrigger ft) throws Exception {
        View v;
        int channelCount = names.length;
        this.channels = new ArrayList<JChannel>(names.length);
        this.receivers = new ArrayList<MyReceiver>(names.length);
        for (int i = 0; i < channelCount; ++i) {
            JChannel channel = this.createChannel();
            MyReceiver r = new MyReceiver(channel, names[i]);
            this.receivers.add(r);
            this.channels.add(channel);
            channel.setReceiver(r);
            channel.connect("x");
            Util.sleep(250L);
        }
        JChannel last = this.channels.get(this.channels.size() - 1);
        JChannel nextToLast = this.channels.get(this.channels.size() - 2);
        ReconciliationTest.insertDISCARD(nextToLast, last.getLocalAddress());
        String lastsName = names[names.length - 1];
        String nextToLastName = names[names.length - 2];
        this.printDigests(this.channels, "\nDigests before " + lastsName + " sends any messages:");
        this.log.info((Object)("\n" + lastsName + " sending 5 messages;" + nextToLastName + " will ignore them, but others will receive them"));
        for (int i = 1; i <= 5; ++i) {
            last.send(null, null, new Integer(i));
        }
        Util.sleep(1500L);
        this.printDigests(this.channels, "\nDigests after " + lastsName + " sent messages:");
        MyReceiver lastReceiver = this.receivers.get(this.receivers.size() - 1);
        MyReceiver nextToLastReceiver = this.receivers.get(this.receivers.size() - 2);
        Map<Address, List<Integer>> map = lastReceiver.getMsgs();
        ReconciliationTest.assertEquals((String)"we should have only 1 sender, namely C at this time", (int)1, (int)map.size());
        List<Integer> list = map.get(last.getLocalAddress());
        this.log.info((Object)(lastsName + ": messages received from " + lastsName + ",list=" + list));
        ReconciliationTest.assertEquals((String)("correct msgs: " + list), (int)5, (int)list.size());
        map = nextToLastReceiver.getMsgs();
        ReconciliationTest.assertEquals((String)"we should have no sender at this time", (int)0, (int)map.size());
        list = map.get(last.getLocalAddress());
        this.log.info((Object)(nextToLastName + ": messages received from " + lastsName + " : " + list));
        ReconciliationTest.assertNull(list);
        List<MyReceiver> otherReceivers = this.receivers.subList(0, this.receivers.size() - 2);
        for (MyReceiver receiver : otherReceivers) {
            map = receiver.getMsgs();
            ReconciliationTest.assertEquals((String)"we should have only 1 sender", (int)1, (int)map.size());
            list = map.get(last.getLocalAddress());
            this.log.info((Object)(receiver.name + " messages received from " + lastsName + ":" + list));
            ReconciliationTest.assertEquals((String)("correct msgs" + list), (int)5, (int)list.size());
        }
        ReconciliationTest.removeDISCARD(nextToLast);
        Address address = last.getLocalAddress();
        ft.triggerFlush();
        for (int cnt = 1000; (v = this.channels.get(0).getView()) != null && cnt > 0; --cnt) {
            if (v.size() == this.channels.size()) break;
            Util.sleep(500L);
        }
        this.printDigests(this.channels, "");
        map = nextToLastReceiver.getMsgs();
        ReconciliationTest.assertEquals((String)"we should have 1 sender at this time", (int)1, (int)map.size());
        list = map.get(address);
        this.log.info((Object)(nextToLastName + ": messages received from " + lastsName + " : " + list));
        ReconciliationTest.assertEquals((int)5, (int)list.size());
    }

    private void printDigests(List<JChannel> channels, String message) {
        this.log.info((Object)message);
        for (JChannel channel : channels) {
            this.log.info(channel.downcall(Event.GET_DIGEST_EVT));
        }
    }

    private static void insertDISCARD(JChannel ch, Address exclude) throws Exception {
        Properties prop = new Properties();
        prop.setProperty("excludeitself", "true");
        DISCARD discard = new DISCARD();
        discard.setProperties(prop);
        discard.addIgnoreMember(exclude);
        ch.getProtocolStack().insertProtocol((Protocol)discard, 2, "NAKACK");
    }

    private static void removeDISCARD(JChannel ... channels) throws Exception {
        for (JChannel ch : channels) {
            ch.getProtocolStack().removeProtocol("DISCARD");
        }
    }

    public void testVirtualSynchrony() throws Exception {
        this.c1 = this.createChannel();
        Cache cache_1 = new Cache(this.c1, "cache-1");
        this.c1.connect("bla");
        this.c2 = this.createChannel();
        Cache cache_2 = new Cache(this.c2, "cache-2");
        this.c2.connect("bla");
        ReconciliationTest.assertEquals((String)("view: " + this.c1.getView()), (int)2, (int)this.c2.getView().size());
        ReconciliationTest.flush(this.c1, 5000L);
        for (int i = 1; i <= 20; ++i) {
            if (i % 2 == 0) {
                cache_1.put("key-" + i, Boolean.TRUE);
                continue;
            }
            cache_2.put("key-" + i, Boolean.TRUE);
        }
        ReconciliationTest.flush(this.c1, 5000L);
        System.out.println("cache_1 (" + cache_1.size() + " elements): " + cache_1 + "\ncache_2 (" + cache_2.size() + " elements): " + cache_2);
        ReconciliationTest.assertEquals((int)cache_1.size(), (int)cache_2.size());
        ReconciliationTest.assertEquals((int)20, (int)cache_1.size());
    }

    private static void flush(Channel channel, long timeout) {
        if (channel.flushSupported()) {
            boolean success = Util.startFlush(channel);
            System.out.println("startFlush(): " + success);
            channel.stopFlush();
            ReconciliationTest.assertTrue((boolean)success);
        } else {
            Util.sleep(timeout);
        }
    }

    public static Test suite() {
        return new TestSuite(ReconciliationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReconciliationTest.suite());
    }

    private static class Cache
    extends ExtendedReceiverAdapter {
        protected final Map<Object, Object> data = new HashMap<Object, Object>();
        Channel ch;
        String name;

        public Cache(Channel ch, String name) {
            this.ch = ch;
            this.name = name;
            this.ch.setReceiver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object get(Object key) {
            Map<Object, Object> map = this.data;
            synchronized (map) {
                return this.data.get(key);
            }
        }

        protected void put(Object key, Object val) throws Exception {
            Object[] buf = new Object[]{key, val};
            Message msg = new Message(null, null, (Serializable)buf);
            this.ch.send(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int size() {
            Map<Object, Object> map = this.data;
            synchronized (map) {
                return this.data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            Object[] modification = (Object[])msg.getObject();
            Object key = modification[0];
            Object val = modification[1];
            Map<Object, Object> map = this.data;
            synchronized (map) {
                this.data.put(key, val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getState() {
            byte[] state = null;
            Map<Object, Object> map = this.data;
            synchronized (map) {
                try {
                    state = Util.objectToByteBuffer(this.data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return state;
        }

        @Override
        public byte[] getState(String state_id) {
            return this.getState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(byte[] state) {
            try {
                Map m = (Map)Util.objectFromByteBuffer(state);
                Map<Object, Object> map = this.data;
                synchronized (map) {
                    this.data.clear();
                    this.data.putAll(m);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void setState(String state_id, byte[] state) {
            this.setState(state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                Map<Object, Object> map = this.data;
                synchronized (map) {
                    oos.writeObject(this.data);
                }
                oos.flush();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        @Override
        public void getState(String state_id, OutputStream ostream) {
            this.getState(ostream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(InputStream istream) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                Map m = (Map)ois.readObject();
                Map<Object, Object> map = this.data;
                synchronized (map) {
                    this.data.clear();
                    this.data.putAll(m);
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        @Override
        public void setState(String state_id, InputStream istream) {
            this.setState(istream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Map<Object, Object> map = this.data;
            synchronized (map) {
                this.data.clear();
            }
        }

        @Override
        public void viewAccepted(View new_view) {
            this.log("view is " + new_view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map<Object, Object> map = this.data;
            synchronized (map) {
                return this.data.toString();
            }
        }

        private void log(String msg) {
            System.out.println("-- [" + this.name + "] " + msg);
        }
    }

    private static class MyReceiver
    extends ExtendedReceiverAdapter {
        Map<Address, List<Integer>> msgs = new HashMap<Address, List<Integer>>(10);
        Channel channel;
        String name;

        public MyReceiver(Channel ch, String name) {
            this.channel = ch;
            this.name = name;
        }

        public Map<Address, List<Integer>> getMsgs() {
            return this.msgs;
        }

        public void reset() {
            this.msgs.clear();
        }

        @Override
        public void receive(Message msg) {
            List<Integer> list = this.msgs.get(msg.getSrc());
            if (list == null) {
                list = new ArrayList<Integer>();
                this.msgs.put(msg.getSrc(), list);
            }
            list.add((Integer)msg.getObject());
            System.out.println("[" + this.name + " / " + this.channel.getLocalAddress() + "]: received message from " + msg.getSrc() + ": " + msg.getObject());
        }

        @Override
        public void viewAccepted(View new_view) {
            System.out.println("[" + this.name + " / " + this.channel.getLocalAddress() + "]: " + new_view);
        }
    }

    private static interface FlushTrigger {
        public void triggerFlush();
    }
}

