/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.metadata;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.metadata.PageMetadataService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageMetadataServiceImpl
implements PageMetadataService {
    private static Log log = ExoLogger.getLogger((String)"wcm:PageMetadataService");
    private LivePortalManagerService livePortalManagerService;
    private TaxonomyService taxonomyService;
    private NewFolksonomyService folksonomyService;

    public PageMetadataServiceImpl(LivePortalManagerService livePortalManagerService, TaxonomyService taxonomyService, NewFolksonomyService folksonomyService) throws Exception {
        this.livePortalManagerService = livePortalManagerService;
        this.taxonomyService = taxonomyService;
        this.folksonomyService = folksonomyService;
    }

    @Override
    public HashMap<String, String> getPortalMetadata(SessionProvider sessionProvider, String uri) throws Exception {
        String portalName = uri.split("/")[1];
        try {
            Node portal = this.livePortalManagerService.getLivePortal(sessionProvider, portalName);
            return this.extractPortalMetadata(portal);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            return null;
        }
    }

    private HashMap<String, String> extractPortalMetadata(Node portalNode) throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        NodeTypeManager manager = portalNode.getSession().getWorkspace().getNodeTypeManager();
        NodeType siteMedata = manager.getNodeType("metadata:siteMetadata");
        for (PropertyDefinition pdef : siteMedata.getDeclaredPropertyDefinitions()) {
            String metadataName = pdef.getName();
            String metadataValue = this.getProperty(portalNode, metadataName);
            if (metadataValue == null) continue;
            metadata.put(metadataName, metadataValue);
        }
        HashMap<String, String> dcElementSet = this.extractDCElementSetMetadata(portalNode);
        metadata.putAll(dcElementSet);
        return metadata;
    }

    private HashMap<String, String> extractDCElementSetMetadata(Node node) throws Exception {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Node checkNode = node;
        if (node.isNodeType("nt:file")) {
            checkNode = (Node)node.getPrimaryItem();
        }
        if (!checkNode.isNodeType("dc:elementSet")) {
            return metadata;
        }
        NodeType dcElementSet = node.getSession().getWorkspace().getNodeTypeManager().getNodeType("dc:elementSet");
        for (PropertyDefinition pdef : dcElementSet.getDeclaredPropertyDefinitions()) {
            String metadataName = pdef.getName();
            String metadataValue = this.getValues(checkNode, metadataName);
            if (metadataValue == null || metadataValue.length() <= 0) continue;
            String metaTagName = metadataName.replaceFirst(":", ".");
            metaTagName = metaTagName.replace("dc", "DC");
            metadata.put(metaTagName, metadataValue);
        }
        return metadata;
    }

    @Override
    public HashMap<String, String> extractMetadata(Node node) throws Exception {
        String pageTitle;
        HashMap<Object, Object> medatata = new HashMap();
        Node portalNode = this.findPortal(node);
        String siteTitle = null;
        String portalKeywords = null;
        if (portalNode != null) {
            siteTitle = this.getProperty(portalNode, "siteTitle");
            if (siteTitle == null) {
                siteTitle = portalNode.getName();
            }
            medatata = this.extractPortalMetadata(portalNode);
            portalKeywords = (String)medatata.get("keywords");
        }
        if ((pageTitle = this.getProperty(node, "exo:title")) == null) {
            pageTitle = node.getName();
        }
        if (siteTitle != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(pageTitle).append("-").append(siteTitle);
            pageTitle = sb.toString();
        }
        String description = this.getProperty(node, "exo:summary");
        medatata.put("pageTitle", pageTitle);
        if (description != null) {
            medatata.put("description", description);
        }
        String keywords = this.computeContentKeywords(node, pageTitle);
        if (portalKeywords != null) {
            keywords = keywords.concat(",").concat(portalKeywords);
        }
        HashMap<String, String> dcElementSet = this.extractDCElementSetMetadata(node);
        medatata.put("keywords", keywords);
        medatata.putAll(dcElementSet);
        return medatata;
    }

    private String computeContentKeywords(Node node, String title) throws Exception {
        StringBuilder builder = new StringBuilder();
        NodeLocation nodeLocation = NodeLocation.make((Node)node);
        String repository = nodeLocation.getRepository();
        try {
            List iterator = this.taxonomyService.getCategories(node, repository);
            for (Node category : iterator) {
                builder.append(category.getName()).append(",");
            }
        }
        catch (Exception e) {
            return builder.toString();
        }
        for (Node tag : this.folksonomyService.getLinkedTagsOfDocument(node, nodeLocation.getWorkspace())) {
            builder.append(tag.getName()).append(",");
        }
        builder.append(title.replaceAll(" ", ","));
        return builder.toString();
    }

    private String getProperty(Node node, String propertyName) throws Exception {
        return node.hasProperty(propertyName) ? node.getProperty(propertyName).getString() : null;
    }

    private String getValues(Node node, String propertyName) throws Exception {
        try {
            Property property = node.getProperty(propertyName);
            PropertyDefinition definition = property.getDefinition();
            if (!definition.isMultiple()) {
                return property.getValue().getString();
            }
            int propertyType = definition.getRequiredType();
            if (2 == propertyType) {
                return null;
            }
            if (9 == propertyType) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            for (Value value : property.getValues()) {
                if (propertyType == 5) {
                    String v = ISO8601.format((Calendar)value.getDate());
                    builder.append(v).append(",");
                    continue;
                }
                builder.append(value.getString()).append(",");
            }
            if (builder.charAt(builder.length() - 1) == ',') {
                builder.deleteCharAt(builder.length() - 1);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Node findPortal(Node child) throws Exception {
        try {
            return this.livePortalManagerService.getLivePortalByChild(child);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Error when findPortal: ", (Throwable)e);
            }
            return null;
        }
    }
}

