/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.extras.migration.rw;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class RemoveManager {
    private int size;
    private int current;
    private Session session;
    private Set<String> names;

    public RemoveManager(int size, Session session) {
        this.size = size;
        this.session = session;
        this.current = 0;
        this.names = new HashSet<String>();
    }

    public void remove(Node node) throws RepositoryException {
        if (node.getName().contains(" ")) {
            return;
        }
        if (this.names.contains(node.getName())) {
            this.commit();
        }
        node.remove();
        ++this.current;
        this.names.add(node.getName());
        if (this.current >= this.size) {
            this.commit();
        }
    }

    public void complete() throws RepositoryException {
        this.commit();
    }

    private void commit() throws RepositoryException {
        this.session.save();
        this.current = 0;
        this.names.clear();
    }
}

