/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/ecm/webui/tree/selectone/UISelectPathPanel.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UISelectPathPanel
extends UIContainer {
    private UIPageIterator uiPageIterator_;
    public String[] acceptedMimeTypes = new String[0];
    protected NodeLocation parentNode;
    private String[] acceptedNodeTypes = new String[0];
    private String[] exceptedNodeTypes = new String[0];
    private String[] defaultExceptedNodeTypes = new String[0];
    private boolean allowPublish = false;
    private PublicationService publicationService_ = null;
    private List<String> templates_ = null;
    private boolean _showTrashHomeNode = true;

    public UISelectPathPanel() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UISelectPathIterate");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setShowTrashHomeNode(boolean value) {
        this._showTrashHomeNode = value;
    }

    public void setAllowPublish(boolean allowPublish, PublicationService publicationService, List<String> templates) {
        this.allowPublish = allowPublish;
        this.publicationService_ = publicationService;
        this.templates_ = templates;
    }

    private void addNodePublish(List<Node> listNode, Node node, PublicationService publicationService) throws Exception {
        if (this.isAllowPublish()) {
            NodeType nt = node.getPrimaryNodeType();
            if (this.templates_.contains(nt.getName())) {
                Node nodecheck = publicationService.getNodePublish(node, null);
                if (nodecheck != null) {
                    listNode.add(nodecheck);
                }
            } else {
                listNode.add(node);
            }
        } else {
            listNode.add(node);
        }
    }

    public void setParentNode(Node node) {
        this.parentNode = NodeLocation.getNodeLocationByNode((Node)node);
    }

    public Node getParentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.parentNode);
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public String[] getExceptedNodeTypes() {
        return this.exceptedNodeTypes;
    }

    public void setExceptedNodeTypes(String[] exceptedNodeTypes) {
        this.exceptedNodeTypes = exceptedNodeTypes;
    }

    public String[] getDefaultExceptedNodeTypes() {
        return this.defaultExceptedNodeTypes;
    }

    public void setDefaultExceptedNodeTypes(String[] defaultExceptedNodeTypes) {
        this.defaultExceptedNodeTypes = defaultExceptedNodeTypes;
    }

    public String[] getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedMimeTypes(String[] acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
    }

    public List getSelectableNodes() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.uiPageIterator_.getCurrentPageData());
    }

    public void updateGrid() throws Exception {
        ListAccessImpl selectableNodeList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.getListSelectableNodes()));
        LazyPageList objPageList = new LazyPageList((ListAccess)selectableNodeList, 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public List<Node> getListSelectableNodes() throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.parentNode == null) {
            return list;
        }
        Node realNode = Utils.getNodeSymLink(NodeLocation.getNodeByLocation((NodeLocation)this.parentNode));
        NodeIterator iterator = realNode.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable") || Utils.isTrashHomeNode(child) && !this._showTrashHomeNode || !this.matchMimeType(Utils.getNodeSymLink(child)) || !this.matchNodeType(Utils.getNodeSymLink(child))) continue;
            list.add(child);
        }
        ArrayList<Node> listNodeCheck = new ArrayList<Node>();
        for (Node node : list) {
            this.addNodePublish(listNodeCheck, node, this.publicationService_);
        }
        return listNodeCheck;
    }

    protected boolean matchNodeType(Node node) throws Exception {
        if (this.acceptedNodeTypes == null || this.acceptedNodeTypes.length == 0) {
            return true;
        }
        for (String nodeType : this.acceptedNodeTypes) {
            if (node == null || !node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExceptedNodeType(Node node) throws RepositoryException {
        if (this.defaultExceptedNodeTypes.length > 0) {
            for (String nodeType : this.defaultExceptedNodeTypes) {
                if (node == null || !node.isNodeType(nodeType)) continue;
                return true;
            }
        }
        if (this.exceptedNodeTypes == null || this.exceptedNodeTypes.length == 0) {
            return false;
        }
        for (String nodeType : this.exceptedNodeTypes) {
            if (node == null || !node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchMimeType(Node node) throws Exception {
        if (this.acceptedMimeTypes == null || this.acceptedMimeTypes.length == 0) {
            return true;
        }
        if (!node.isNodeType("nt:file")) {
            return true;
        }
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        for (String type : this.acceptedMimeTypes) {
            if (!type.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
    }

    public String getDisplayName(Node node) throws RepositoryException {
        return node.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UISelectPathPanel> {
        public void execute(Event<UISelectPathPanel> event) throws Exception {
            UISelectPathPanel uiSelectPathPanel = (UISelectPathPanel)((Object)event.getSource());
            UIContainer uiTreeSelector = (UIContainer)uiSelectPathPanel.getParent();
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)uiTreeSelector.getChild(UIBreadcumbs.class);
            StringBuffer breadcumbsPaths = new StringBuffer();
            for (UIBreadcumbs.LocalPath iterLocalPath : uiBreadcumbs.getPath()) {
                breadcumbsPaths.append("/").append(iterLocalPath.getId());
            }
            StringBuffer sbPath = new StringBuffer();
            String objectid = event.getRequestContext().getRequestParameter("objectId");
            sbPath.append(breadcumbsPaths).append(objectid.substring(objectid.lastIndexOf("/")));
            if (uiTreeSelector instanceof UIOneNodePathSelector && !((UIOneNodePathSelector)uiTreeSelector).isDisable()) {
                sbPath.insert(0, ":").insert(0, ((UIOneNodePathSelector)uiTreeSelector).getWorkspaceName());
            }
            String returnField = ((UIBaseNodeTreeSelector)uiTreeSelector).getReturnFieldName();
            ((UISelectable)((UIBaseNodeTreeSelector)uiTreeSelector).getSourceComponent()).doSelect(returnField, sbPath.toString());
            UIComponent uiOneNodePathSelector = uiSelectPathPanel.getParent();
            if (uiOneNodePathSelector instanceof UIOneNodePathSelector) {
                UIComponent component;
                UIComponent uiComponent = uiOneNodePathSelector.getParent();
                if (uiComponent instanceof UIPopupWindow) {
                    UIComponent uiParentOfPopup = uiComponent.getParent();
                    ((UIPopupWindow)uiComponent).setShow(false);
                    ((UIPopupWindow)uiComponent).setRendered(false);
                    if (uiParentOfPopup != null) {
                        event.getRequestContext().addUIComponentToUpdateByAjax(uiParentOfPopup);
                    }
                }
                if ((component = ((UIOneNodePathSelector)uiOneNodePathSelector).getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                }
            }
        }
    }
}

