/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.composer;

import org.exoplatform.social.webui.composer.UIActivityComposerManager;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIActivityComposer
extends UIContainer {
    private UIContainer activityDisplay;
    private UIActivityComposerManager activityComposerManager;
    private boolean isReady = false;
    private boolean isDisplayed = false;

    public boolean isDisplayed() {
        return this.isDisplayed;
    }

    public void setDisplayed(boolean isDisplayed) {
        this.isDisplayed = isDisplayed;
    }

    public boolean isReadyForPostingActivity() {
        return this.isReady;
    }

    public void setReadyForPostingActivity(boolean isReady) {
        this.isReady = isReady;
    }

    public void setActivityDisplay(UIContainer activityDisplay) {
        this.activityDisplay = activityDisplay;
    }

    public UIContainer getActivityDisplay() {
        return this.activityDisplay;
    }

    public void setActivityComposerManager(UIActivityComposerManager activityComposerManager) {
        this.activityComposerManager = activityComposerManager;
    }

    public UIActivityComposerManager getActivityComposerManager() {
        return this.activityComposerManager;
    }

    public void postActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
        this.onPostActivity(postContext, source, requestContext, postedMessage);
        this.setReadyForPostingActivity(false);
        this.setDisplayed(false);
        this.activityComposerManager.setDefaultActivityComposer();
    }

    protected abstract void onPostActivity(UIComposer.PostContext var1, UIComponent var2, WebuiRequestContext var3, String var4) throws Exception;

    protected abstract void onClose(Event<UIActivityComposer> var1);

    protected abstract void onSubmit(Event<UIActivityComposer> var1);

    protected abstract void onActivate(Event<UIActivityComposer> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActivateActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            UIActivityComposer activityComposer = (UIActivityComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = activityComposer.getActivityComposerManager();
            activityComposerManager.setCurrentActivityComposer(activityComposer);
            activityComposer.onActivate(event);
            activityComposer.setDisplayed(true);
            UIComposer composer = activityComposerManager.getUIComposer();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)composer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubmitContentActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            UIActivityComposer activityComposer = (UIActivityComposer)((Object)event.getSource());
            activityComposer.onSubmit(event);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIActivityComposer> {
        public void execute(Event<UIActivityComposer> event) throws Exception {
            UIActivityComposer activityComposer = (UIActivityComposer)((Object)event.getSource());
            UIActivityComposerManager activityComposerManager = activityComposer.getActivityComposerManager();
            activityComposerManager.setDefaultActivityComposer();
            activityComposer.onClose(event);
            activityComposer.setDisplayed(false);
            UIComposer composer = activityComposerManager.getUIComposer();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)composer);
        }
    }
}

