/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.ldap.ObjectClassAttribute;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.ldap.BaseDAO;

public class OrganizationLdapInitializer
extends BaseComponentPlugin
implements OrganizationServiceInitializer,
ComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.OrganizationLdapInitializer");
    protected static Pattern COMPACT_DN = Pattern.compile("\\b\\p{Space}*=\\p{Space}*", 2);
    private BaseDAO baseHandler;

    public void init(OrganizationService service) throws Exception {
        this.baseHandler = (BaseDAO)service.getUserHandler();
        this.createSubContextNew(this.baseHandler.ldapAttrMapping.baseURL, this.baseHandler.ldapAttrMapping.groupsURL);
        this.createSubContextNew(this.baseHandler.ldapAttrMapping.baseURL, this.baseHandler.ldapAttrMapping.userURL);
        this.createSubContextNew(this.baseHandler.ldapAttrMapping.baseURL, this.baseHandler.ldapAttrMapping.membershipTypeURL);
        this.createSubContextNew(this.baseHandler.ldapAttrMapping.baseURL, this.baseHandler.ldapAttrMapping.profileURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubContext(String dn) throws Exception {
        Pattern pattern = Pattern.compile("\\b\\p{Space}*=\\p{Space}*", 2);
        Matcher matcher = pattern.matcher(dn);
        dn = matcher.replaceAll("=");
        LdapContext context = this.baseHandler.ldapService.getLdapContext();
        try {
            int i;
            String[] explodeDN = this.baseHandler.explodeDN(dn, false);
            if (explodeDN.length < 1) {
                return;
            }
            dn = explodeDN[explodeDN.length - 1];
            for (i = explodeDN.length - 2; i > -1 && explodeDN[i].toLowerCase().startsWith("dc="); --i) {
                dn = explodeDN[i] + "," + dn;
            }
            this.createDN(dn, context);
            while (i > -1) {
                dn = explodeDN[i] + "," + dn;
                this.createDN(dn, context);
                --i;
            }
        }
        finally {
            this.baseHandler.ldapService.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDN(String dn, LdapContext context) throws Exception {
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls control = new SearchControls();
            control.setSearchScope(0);
            results = context.search(dn, "(objectClass=*)", control);
            if (results.hasMoreElements()) {
                return;
            }
        }
        catch (NamingException exp) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An exception occurred: " + exp.getMessage()));
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        String nameValue = dn.substring(dn.indexOf("=") + 1, dn.indexOf(","));
        BasicAttributes attrs = new BasicAttributes();
        if (dn.toLowerCase().startsWith("ou=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"top", "organizationalUnit"}));
            attrs.put("ou", nameValue);
        } else if (dn.toLowerCase().startsWith("cn=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"top", "organizationalRole"}));
            attrs.put("cn", nameValue);
        } else if (dn.toLowerCase().startsWith("c=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"country"}));
            attrs.put("c", nameValue);
        } else if (dn.toLowerCase().startsWith("o=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"organization"}));
            attrs.put("o", nameValue);
        } else if (dn.toLowerCase().startsWith("dc=")) {
            attrs.put((Attribute)new ObjectClassAttribute(new String[]{"top", "dcObject", "organization"}));
            attrs.put("dc", nameValue);
            attrs.put("o", nameValue);
        }
        attrs.put("description", nameValue);
        context.createSubcontext(dn, (Attributes)attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubContextNew(String basedn, String dn) throws Exception {
        Matcher matcher = COMPACT_DN.matcher(dn);
        dn = matcher.replaceAll("=");
        matcher = COMPACT_DN.matcher(basedn);
        basedn = matcher.replaceAll("=");
        LdapContext context = this.baseHandler.ldapService.getLdapContext();
        try {
            String[] edn = this.baseHandler.explodeDN(dn, false);
            String[] ebasedn = this.baseHandler.explodeDN(basedn, false);
            if (edn.length < 1) {
                throw new IllegalArgumentException("Zerro DN length, [" + dn + "]");
            }
            if (ebasedn.length < 1) {
                throw new IllegalArgumentException("Zerro Base DN length, [" + basedn + "]");
            }
            if (edn.length < ebasedn.length) {
                throw new IllegalArgumentException("DN length smaller Base DN [" + dn + " >= " + basedn + "]");
            }
            String rdn = basedn;
            for (int i = 1; i <= edn.length; ++i) {
                String n = edn[edn.length - i];
                if (i <= ebasedn.length) {
                    String bn = ebasedn[ebasedn.length - i];
                    if (n.equals(bn)) continue;
                    throw new IllegalArgumentException("DN does not starts with Base DN [" + dn + " != " + basedn + "]");
                }
                rdn = n + "," + rdn;
                this.createDN(rdn, context);
            }
        }
        finally {
            this.baseHandler.ldapService.release(context);
        }
    }
}

