/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.exoplatform.services.document.AdvancedDocumentReader;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.DocumentReader;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.HandlerNotFoundException;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.DateField;
import org.exoplatform.services.jcr.impl.core.query.lucene.DoubleField;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.LazyTextExtractorField;
import org.exoplatform.services.jcr.impl.core.query.lucene.LongField;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingletonTokenStream;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIndexer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"exo.jcr.component.core.NodeIndexer");
    protected static final float DEFAULT_BOOST = 1.0f;
    protected final NodeDataIndexing node;
    protected final ItemDataConsumer stateProvider;
    protected final NamespaceMappings mappings;
    protected final LocationFactory resolver;
    protected final DocumentReaderService extractor;
    protected IndexingConfiguration indexingConfig;
    protected boolean supportHighlighting = false;
    protected IndexFormatVersion indexFormatVersion = IndexFormatVersion.V1;
    protected List doNotUseInExcerpt = new ArrayList();
    private ValueFactoryImpl vFactory;

    public NodeIndexer(NodeDataIndexing node, ItemDataConsumer stateProvider, NamespaceMappings mappings, DocumentReaderService extractor) {
        this.node = node;
        this.stateProvider = stateProvider;
        this.mappings = mappings;
        this.resolver = new LocationFactory(mappings);
        this.extractor = extractor;
        this.vFactory = new ValueFactoryImpl(this.resolver);
    }

    public String getNodeId() {
        return this.node.getIdentifier();
    }

    public void setSupportHighlighting(boolean b) {
        this.supportHighlighting = b;
    }

    public void setIndexFormatVersion(IndexFormatVersion indexFormatVersion) {
        this.indexFormatVersion = indexFormatVersion;
    }

    public void setIndexingConfiguration(IndexingConfiguration config) {
        this.indexingConfig = config;
    }

    protected Document createDoc() throws RepositoryException {
        Collection<PropertyData> props;
        Document doc;
        block9: {
            this.doNotUseInExcerpt.clear();
            doc = new Document();
            doc.setBoost(this.getNodeBoost());
            doc.add((Fieldable)new Field(FieldNames.UUID, this.node.getIdentifier(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            try {
                if (this.node.getParentIdentifier() == null) {
                    doc.add((Fieldable)new Field(FieldNames.PARENT, "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
                    this.addNodeName(doc, "", "");
                } else {
                    this.addParentChildRelation(doc, this.node.getParentIdentifier());
                }
            }
            catch (NamespaceException e) {
                if (!LOG.isTraceEnabled()) break block9;
                LOG.trace("An exception occurred: " + e.getMessage());
            }
        }
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V4.getVersion()) {
            doc.add((Fieldable)new Field(FieldNames.INDEX, Integer.toString(this.node.getQPath().getIndex()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
            StringBuilder path = new StringBuilder(256);
            path.append(this.node.getParentIdentifier() == null ? "" : this.node.getParentIdentifier()).append('/').append(this.node.getQPath().getName().getAsString());
            doc.add((Fieldable)new Field(FieldNames.PATH, path.toString(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        if ((props = this.node.getChildPropertiesData()) == null) {
            props = this.stateProvider.listChildPropertiesData(this.node);
        }
        for (PropertyData prop : props) {
            if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V2.getVersion()) {
                this.addPropertyName(doc, prop.getQPath().getName());
            }
            this.addValues(doc, prop);
        }
        Iterator it = this.doNotUseInExcerpt.iterator();
        while (it.hasNext()) {
            doc.add((Fieldable)it.next());
        }
        return doc;
    }

    private void addMVPName(Document doc, InternalQName name) throws RepositoryException {
        block2: {
            try {
                String propName = this.resolver.createJCRName(name).getAsString();
                doc.add((Fieldable)new Field(FieldNames.MVP, propName, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
            }
            catch (NamespaceException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace("An exception occurred: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValues(Document doc, PropertyData prop) throws RepositoryException {
        int propType = prop.getType();
        String fieldName = this.resolver.createJCRName(prop.getQPath().getName()).getAsString();
        if (propType == 2) {
            List<ValueData> data = null;
            if (this.node.getQPath().getName().equals((Object)Constants.JCR_CONTENT)) {
                PropertyData pmime = this.node.getProperty(Constants.JCR_MIMETYPE.getAsString());
                if (pmime == null && !this.node.containAllProperties()) {
                    pmime = (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_MIMETYPE, 0), ItemType.PROPERTY);
                }
                if (pmime != null) {
                    PropertyData propData = prop.getValues().size() > 0 ? prop : (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_DATA, 0), ItemType.PROPERTY);
                    try {
                        PropertyData encProp;
                        DocumentReader dreader = this.extractor.getDocumentReader(new String(pmime.getValues().get(0).getAsByteArray(), "UTF-8"));
                        data = propData.getValues();
                        if (data == null) {
                            LOG.warn("null value found at property " + prop.getQPath().getAsString());
                        }
                        if ((encProp = this.node.getProperty(Constants.JCR_ENCODING.getAsString())) == null && !this.node.containAllProperties()) {
                            encProp = (PropertyData)this.stateProvider.getItemData(this.node, new QPathEntry(Constants.JCR_ENCODING, 0), ItemType.PROPERTY);
                        }
                        String encoding = null;
                        if (encProp != null) {
                            encoding = new String(encProp.getValues().get(0).getAsByteArray(), "UTF-8");
                        }
                        if (dreader instanceof AdvancedDocumentReader) {
                            for (ValueData pvd : data) {
                                InputStream is = null;
                                is = pvd.getAsStream();
                                Reader reader = encoding != null ? ((AdvancedDocumentReader)dreader).getContentAsReader(is, encoding) : ((AdvancedDocumentReader)dreader).getContentAsReader(is);
                                doc.add(this.createFulltextField(reader));
                            }
                        } else {
                            for (ValueData pvd : data) {
                                InputStream is = null;
                                try {
                                    is = pvd.getAsStream();
                                    StringReader reader = encoding != null ? new StringReader(dreader.getContentAsText(is, encoding)) : new StringReader(dreader.getContentAsText(is));
                                    doc.add(this.createFulltextField(reader));
                                }
                                finally {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable e) {
                                        if (!LOG.isTraceEnabled()) continue;
                                        LOG.trace("An exception occurred: " + e.getMessage());
                                    }
                                }
                            }
                        }
                        if (data.size() > 1) {
                            this.addMVPName(doc, prop.getQPath().getName());
                        }
                    }
                    catch (DocumentReadException e) {
                        LOG.error("Can not indexing the document by path " + propData.getQPath().getAsString() + ", propery id '" + propData.getIdentifier() + "' : " + (Object)((Object)e), (Throwable)e);
                    }
                    catch (HandlerNotFoundException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Can not indexing the document by path " + propData.getQPath().getAsString() + ", propery id '" + propData.getIdentifier() + "' : " + (Object)((Object)e), (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Binary value indexer IO error, document by path " + propData.getQPath().getAsString() + ", propery id '" + propData.getIdentifier() + "' : " + e, (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Binary value indexer error, document by path " + propData.getQPath().getAsString() + ", propery id '" + propData.getIdentifier() + "' : " + e, (Throwable)e);
                    }
                }
            }
        } else {
            try {
                List<ValueData> data;
                List<ValueData> list = data = prop.getValues().size() > 0 ? prop.getValues() : ((PropertyData)this.stateProvider.getItemData(prop.getIdentifier())).getValues();
                if (data == null) {
                    LOG.warn("null value found at property " + prop.getQPath().getAsString());
                }
                ExtendedValue val = null;
                InternalQName name = prop.getQPath().getName();
                for (ValueData value : data) {
                    val = (ExtendedValue)this.vFactory.loadValue(value, propType);
                    switch (propType) {
                        case 6: {
                            if (!this.isIndexed(name)) break;
                            this.addBooleanValue(doc, fieldName, val.getBoolean());
                            break;
                        }
                        case 5: {
                            if (!this.isIndexed(name)) break;
                            this.addCalendarValue(doc, fieldName, val.getDate());
                            break;
                        }
                        case 4: {
                            if (!this.isIndexed(name)) break;
                            this.addDoubleValue(doc, fieldName, new Double(val.getDouble()));
                            break;
                        }
                        case 3: {
                            if (!this.isIndexed(name)) break;
                            this.addLongValue(doc, fieldName, new Long(val.getLong()));
                            break;
                        }
                        case 9: {
                            if (!this.isIndexed(name)) break;
                            this.addReferenceValue(doc, fieldName, val.getString());
                            break;
                        }
                        case 8: {
                            if (!this.isIndexed(name)) break;
                            this.addPathValue(doc, fieldName, val.getString());
                            break;
                        }
                        case 1: {
                            if (!this.isIndexed(name)) break;
                            if (name.equals((Object)Constants.JCR_UUID)) {
                                this.addStringValue(doc, fieldName, val.getString(), false, false, 1.0f);
                                break;
                            }
                            this.addStringValue(doc, fieldName, val.getString(), true, this.isIncludedInNodeIndex(name), this.getPropertyBoost(name), this.useInExcerpt(name));
                            break;
                        }
                        case 7: {
                            if (!this.isIndexed(name) && !name.equals((Object)Constants.JCR_PRIMARYTYPE) && !name.equals((Object)Constants.JCR_MIXINTYPES)) break;
                            this.addNameValue(doc, fieldName, val.getString());
                            break;
                        }
                        case 100: {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("illegal internal value type " + propType);
                        }
                    }
                    if (this.indexFormatVersion.getVersion() < IndexFormatVersion.V3.getVersion()) continue;
                    this.addLength(doc, fieldName, value, propType);
                }
                if (data.size() > 1) {
                    this.addMVPName(doc, prop.getQPath().getName());
                }
            }
            catch (RepositoryException e) {
                LOG.error("Index of property value error. " + prop.getQPath().getAsString() + ".", (Throwable)e);
                throw new RepositoryException("Index of property value error. " + prop.getQPath().getAsString() + ". " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    private void addPropertyName(Document doc, InternalQName name) throws RepositoryException {
        String fieldName;
        block2: {
            fieldName = name.getName();
            try {
                fieldName = this.resolver.createJCRName(name).getAsString();
            }
            catch (NamespaceException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace("An exception occurred: " + e.getMessage());
            }
        }
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES_SET, fieldName, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    protected void addBooleanValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), 6));
    }

    protected Field createFieldWithoutNorms(String fieldName, String internalValue, int propertyType) {
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            Field field = new Field(FieldNames.PROPERTIES, (TokenStream)new SingletonTokenStream(FieldNames.createNamedValue(fieldName, internalValue), propertyType));
            field.setOmitNorms(true);
            return field;
        }
        return new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, internalValue), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
    }

    protected void addCalendarValue(Document doc, String fieldName, Object internalValue) {
        Calendar value = (Calendar)internalValue;
        long millis = value.getTimeInMillis();
        try {
            doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DateField.timeToString(millis), 5));
        }
        catch (IllegalArgumentException e) {
            LOG.warn("'{}' is outside of supported date value range.", (Object)new Date(value.getTimeInMillis()));
        }
    }

    protected void addDoubleValue(Document doc, String fieldName, Object internalValue) {
        double doubleVal = (Double)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, DoubleField.doubleToString(doubleVal), 4));
    }

    protected void addLongValue(Document doc, String fieldName, Object internalValue) {
        long longVal = (Long)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, LongField.longToString(longVal), 3));
    }

    protected void addReferenceValue(Document doc, String fieldName, Object internalValue) {
        String uuid = internalValue.toString();
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, uuid, 9));
        doc.add((Fieldable)new Field(FieldNames.PROPERTIES, FieldNames.createNamedValue(fieldName, uuid), Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
    }

    protected void addPathValue(Document doc, String fieldName, Object pathString) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, pathString.toString(), 8));
    }

    @Deprecated
    protected void addStringValue(Document doc, String fieldName, Object internalValue) {
        this.addStringValue(doc, fieldName, internalValue, true, true, 1.0f);
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized) {
        this.addStringValue(doc, fieldName, internalValue, tokenized, true, 1.0f);
    }

    @Deprecated
    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized, boolean includeInNodeIndex, float boost) {
        this.addStringValue(doc, fieldName, internalValue, tokenized, includeInNodeIndex, boost, true);
    }

    protected void addStringValue(Document doc, String fieldName, Object internalValue, boolean tokenized, boolean includeInNodeIndex, float boost, boolean useInExcerpt) {
        String stringValue = (String)internalValue;
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, stringValue, 1));
        if (tokenized) {
            if (stringValue.length() == 0) {
                return;
            }
            int idx = fieldName.indexOf(58);
            fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
            Field f = new Field(fieldName, stringValue, Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.NO);
            f.setBoost(boost);
            doc.add((Fieldable)f);
            if (includeInNodeIndex) {
                boolean store = this.supportHighlighting && useInExcerpt;
                f = this.createFulltextField(stringValue, store, this.supportHighlighting);
                if (useInExcerpt) {
                    doc.add((Fieldable)f);
                } else {
                    this.doNotUseInExcerpt.add(f);
                }
            }
        }
    }

    protected void addNameValue(Document doc, String fieldName, Object internalValue) {
        doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, internalValue.toString(), 7));
    }

    @Deprecated
    protected Field createFulltextField(String value) {
        return this.createFulltextField(value, this.supportHighlighting, this.supportHighlighting);
    }

    protected Field createFulltextField(String value, boolean store, boolean withOffsets) {
        Field.TermVector tv = withOffsets ? Field.TermVector.WITH_OFFSETS : Field.TermVector.NO;
        if (store) {
            Field.Store stored = value.length() > 16384 ? Field.Store.COMPRESS : Field.Store.YES;
            return new Field(FieldNames.FULLTEXT, value, stored, Field.Index.ANALYZED, tv);
        }
        return new Field(FieldNames.FULLTEXT, value, Field.Store.NO, Field.Index.ANALYZED, tv);
    }

    protected Fieldable createFulltextField(Reader value) {
        if (this.supportHighlighting) {
            return new LazyTextExtractorField(FieldNames.FULLTEXT, value, true, true);
        }
        return new LazyTextExtractorField(FieldNames.FULLTEXT, value, false, false);
    }

    protected boolean isIndexed(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIndexed(this.node, propertyName);
    }

    protected boolean isIncludedInNodeIndex(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.isIncludedInNodeScopeIndex(this.node, propertyName);
    }

    protected boolean useInExcerpt(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return true;
        }
        return this.indexingConfig.useInExcerpt(this.node, propertyName);
    }

    protected float getPropertyBoost(InternalQName propertyName) {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getPropertyBoost(this.node, propertyName);
    }

    protected float getNodeBoost() {
        if (this.indexingConfig == null) {
            return 1.0f;
        }
        return this.indexingConfig.getNodeBoost(this.node);
    }

    protected void addLength(Document doc, String propertyName, ValueData value, int propType) {
        long length = Util.getLength(value, propType);
        if (length != -1L) {
            doc.add((Fieldable)new Field(FieldNames.PROPERTY_LENGTHS, FieldNames.createNamedLength(propertyName, length), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }

    protected void addNodeName(Document doc, String namespaceURI, String localName) throws RepositoryException {
        String name = this.mappings.getNamespacePrefixByURI(namespaceURI) + ":" + localName;
        doc.add((Fieldable)new Field(FieldNames.LABEL, name, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        if (this.indexFormatVersion.getVersion() >= IndexFormatVersion.V3.getVersion()) {
            doc.add((Fieldable)new Field(FieldNames.NAMESPACE_URI, namespaceURI, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            doc.add((Fieldable)new Field(FieldNames.LOCAL_NAME, localName, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }

    protected void addParentChildRelation(Document doc, String parentId) throws RepositoryException {
        doc.add((Fieldable)new Field(FieldNames.PARENT, parentId, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO));
        InternalQName name = this.node.getQPath().getName();
        this.addNodeName(doc, name.getNamespace(), name.getName());
    }
}

