/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.IOException;
import java.util.ArrayList;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.dataflow.serialization.UnknownClassIdException;

public class ACLReader {
    public AccessControlList read(ObjectReader in) throws UnknownClassIdException, IOException {
        int key = in.readInt();
        if (key != 2) {
            throw new UnknownClassIdException("There is unexpected class [" + key + "]");
        }
        String owner = in.readByte() == 1 ? in.readString() : null;
        ArrayList<AccessControlEntry> accessList = new ArrayList<AccessControlEntry>();
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            String ident = in.readString();
            String perm = in.readString();
            accessList.add(new AccessControlEntry(ident, perm));
        }
        return new AccessControlList(owner, accessList);
    }
}

