/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.util.HashMap;
import javax.jcr.Node;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.documents.FavoriteService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class FavoriteNewUserListener
extends UserEventListener {
    private static final String ADD_TO_FAVORITE_ACTION = "addToFavorite";
    private ActionServiceContainer actionServiceContainer_;
    private TemplateService templateService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private static final String FAVORITE_ALIAS = "userPrivateFavorites";

    public FavoriteNewUserListener(NodeHierarchyCreator nodeHierarchyCreatorService, FavoriteService favoriteService, ActionServiceContainer actionServiceContainer, TemplateService templateService) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreatorService;
        this.actionServiceContainer_ = actionServiceContainer;
        this.templateService_ = templateService;
    }

    public void postSave(User user, boolean isNew) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = this.nodeHierarchyCreator_.getUserNode(sessionProvider, user.getUserName());
        String favoritePath = this.nodeHierarchyCreator_.getJcrPath(FAVORITE_ALIAS);
        Node favoriteNode = userNode.getNode(favoritePath);
        this.applyAddToFavoriteAction(favoriteNode);
    }

    private void applyAddToFavoriteAction(Node favoriteNode) throws Exception {
        HashMap<String, JcrInputProperty> mappings = new HashMap<String, JcrInputProperty>();
        JcrInputProperty nodeTypeInputProperty = new JcrInputProperty();
        nodeTypeInputProperty.setJcrPath("/node");
        nodeTypeInputProperty.setValue(ADD_TO_FAVORITE_ACTION);
        mappings.put("/node", nodeTypeInputProperty);
        JcrInputProperty nameInputProperty = new JcrInputProperty();
        nameInputProperty.setJcrPath("/node/exo:name");
        nameInputProperty.setValue(ADD_TO_FAVORITE_ACTION);
        mappings.put("/node/exo:name", nameInputProperty);
        JcrInputProperty lifeCycleInputProperty = new JcrInputProperty();
        lifeCycleInputProperty.setJcrPath("/node/exo:lifecyclePhase");
        lifeCycleInputProperty.setValue(new String[]{"node_added"});
        mappings.put("/node/exo:lifecyclePhase", lifeCycleInputProperty);
        JcrInputProperty deepInputProperty = new JcrInputProperty();
        deepInputProperty.setJcrPath("/node/exo:isDeep");
        deepInputProperty.setValue(true);
        mappings.put("/node/exo:isDeep", deepInputProperty);
        JcrInputProperty descriptionInputProperty = new JcrInputProperty();
        descriptionInputProperty.setJcrPath("/node/exo:description");
        descriptionInputProperty.setValue("auto Add favorite when new document node created at favorite");
        mappings.put("/node/exo:description", descriptionInputProperty);
        this.actionServiceContainer_.addAction(favoriteNode, "exo:addToFavoriteAction", mappings);
        Node actionNode = this.actionServiceContainer_.getAction(favoriteNode, ADD_TO_FAVORITE_ACTION);
        actionNode.addMixin("mix:affectedNodeTypes");
        actionNode.setProperty("exo:affectedNodeTypeNames", this.templateService_.getAllDocumentNodeTypes().toArray(new String[0]));
        actionNode.save();
    }
}

