/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class LockUtil {
    public static ExoCache getLockCache() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CacheService cacheService = (CacheService)container.getComponentInstanceOfType(CacheService.class);
        return cacheService.getCacheInstance(LockManagerImpl.class.getName());
    }

    public static void keepLock(Lock lock) throws Exception {
        HashMap<String, String> lockedNodesInfo;
        ExoCache lockcache = LockUtil.getLockCache();
        String key = LockUtil.createLockKey(lock.getNode());
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = (HashMap<String, String>)lockcache.get((Serializable)((Object)userId))) == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(key, lock.getLockToken());
        lockcache.put((Serializable)((Object)userId), lockedNodesInfo);
    }

    public static void keepLock(Lock lock, String userId) throws Exception {
        ExoCache lockcache = LockUtil.getLockCache();
        String keyRoot = LockUtil.createLockKey(lock.getNode(), userId);
        HashMap<String, String> lockedNodesInfo = (HashMap<String, String>)lockcache.get((Serializable)((Object)userId));
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(keyRoot, lock.getLockToken());
        lockcache.put((Serializable)((Object)userId), lockedNodesInfo);
    }

    public static void keepLock(Lock lock, String userId, String lockToken) throws Exception {
        ExoCache lockcache = LockUtil.getLockCache();
        String keyRoot = LockUtil.createLockKey(lock.getNode(), userId);
        HashMap<String, String> lockedNodesInfo = (HashMap<String, String>)lockcache.get((Serializable)((Object)userId));
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(keyRoot, lockToken);
        lockcache.put((Serializable)((Object)userId), lockedNodesInfo);
    }

    public static void removeLock(Node node) throws Exception {
        Map lockedNodesInfo;
        ExoCache lockcache = LockUtil.getLockCache();
        String key = LockUtil.createLockKey(node);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = (Map)lockcache.get((Serializable)((Object)userId))) == null) {
            return;
        }
        lockedNodesInfo.remove(key);
    }

    public static void changeLockToken(Node oldNode, Node newNode) throws Exception {
        HashMap<String, String> lockedNodesInfo;
        ExoCache lockcache = LockUtil.getLockCache();
        String newKey = LockUtil.createLockKey(newNode);
        String oldKey = LockUtil.createLockKey(oldNode);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = (HashMap<String, String>)lockcache.get((Serializable)((Object)userId))) == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.remove(oldKey);
        lockedNodesInfo.put(newKey, newNode.getLock().getLockToken());
        lockcache.put((Serializable)((Object)userId), lockedNodesInfo);
    }

    public static void changeLockToken(String srcPath, Node newNode) throws Exception {
        HashMap lockedNodesInfo;
        ExoCache lockcache = LockUtil.getLockCache();
        String newKey = LockUtil.createLockKey(newNode);
        String oldKey = LockUtil.getOldLockKey(srcPath, newNode);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = (HashMap)lockcache.get((Serializable)((Object)userId))) == null) {
            lockedNodesInfo = new HashMap();
        }
        if (lockedNodesInfo.containsKey(oldKey)) {
            lockedNodesInfo.put(newKey, lockedNodesInfo.get(oldKey));
            lockedNodesInfo.remove(oldKey);
        }
        lockcache.put((Serializable)((Object)userId), lockedNodesInfo);
    }

    public static String getLockTokenOfUser(Node node) throws Exception {
        Map lockedNodesInfo;
        ExoCache lockcache = LockUtil.getLockCache();
        String key = LockUtil.createLockKey(node);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = (Map)lockcache.get((Serializable)((Object)userId))) != null && lockedNodesInfo.get(key) != null) {
            return (String)lockedNodesInfo.get(key);
        }
        return null;
    }

    public static String getLockToken(Node node) throws Exception {
        Map lockedNodesInfo;
        ExoCache lockcache = LockUtil.getLockCache();
        String key = LockUtil.createLockKey(node);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = (Map)lockcache.get((Serializable)((Object)userId))) != null && lockedNodesInfo.get(key) != null) {
            return (String)lockedNodesInfo.get(key);
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OrganizationService service = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        Collection collection = service.getMembershipHandler().findMembershipsByUser(userId);
        for (Membership membership : collection) {
            StringBuffer permissionBuffer = new StringBuffer();
            permissionBuffer.append(membership.getMembershipType()).append(":").append(membership.getGroupId());
            if (permissionBuffer == null || permissionBuffer.toString().length() <= 0) continue;
            String keyPermission = LockUtil.createLockKey(node, permissionBuffer.toString());
            lockedNodesInfo = (Map)lockcache.get((Serializable)((Object)permissionBuffer.toString()));
            if (lockedNodesInfo == null || lockedNodesInfo.get(keyPermission) == null) continue;
            return (String)lockedNodesInfo.get(keyPermission);
        }
        return null;
    }

    public static String getOldLockKey(String srcPath, Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(session.getUserID()).append(":/:").append(srcPath);
        return buffer.toString();
    }

    public static String createLockKey(Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(userId).append(":/:").append(node.getPath());
        return buffer.toString();
    }

    public static String createLockKey(Node node, String userId) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(userId).append(":/:").append(node.getPath());
        return buffer.toString();
    }

    public static boolean isLocked(Node node) throws Exception {
        if (!node.isLocked()) {
            return false;
        }
        String lockToken = LockUtil.getLockTokenOfUser(node);
        if (lockToken != null) {
            node.getSession().addLockToken(LockUtil.getLockToken(node));
            return false;
        }
        return true;
    }

    public static void updateLockCache(String membership) throws Exception {
        ExoCache lockcache = LockUtil.getLockCache();
        ManageableRepository repo = WCMCoreUtils.getRepository();
        Session session = null;
        for (String ws : repo.getWorkspaceNames()) {
            session = WCMCoreUtils.getSystemSessionProvider().getSession(ws, repo);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT * FROM mix:lockable order by exo:dateCreated DESC", "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node itemNode = iter.nextNode();
                if (Utils.isInTrash(itemNode) || !itemNode.isLocked()) continue;
                String lockToken = LockUtil.getLockToken(itemNode);
                LockUtil.keepLock(itemNode.getLock(), membership, lockToken);
                if (!membership.startsWith("*")) continue;
                String lockTokenString = membership;
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                OrganizationService service = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
                List memberships = (List)service.getMembershipTypeHandler().findMembershipTypes();
                for (MembershipType m : memberships) {
                    lockTokenString = membership.replace("*", m.getName());
                    LockUtil.keepLock(itemNode.getLock(), lockTokenString, lockToken);
                }
            }
        }
    }
}

