/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.skin;

import javax.jcr.Node;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.skin.XSkinService;

public class CSSFileHandler
extends BaseWebSchemaHandler {
    private boolean isInPortalCSSFolder = false;

    protected String getHandlerNodeType() {
        return "nt:file";
    }

    protected String getParentNodeType() {
        return "exo:cssFolder";
    }

    public boolean matchHandler(SessionProvider sessionProvider, Node node) throws Exception {
        if (!this.matchNodeType(node)) {
            return false;
        }
        if (!this.matchMimeType(node)) {
            return false;
        }
        this.isInPortalCSSFolder = this.matchPortalCSSFolder(sessionProvider, node);
        if (this.isInPortalCSSFolder) {
            return true;
        }
        return this.matchParentNodeType(node);
    }

    private boolean matchNodeType(Node node) throws Exception {
        return node.getPrimaryNodeType().getName().equals("nt:file");
    }

    private boolean matchMimeType(Node node) throws Exception {
        String mimeType = this.getFileMimeType(node);
        if ("text/css".equals(mimeType)) {
            return true;
        }
        return "text/plain".equals(mimeType);
    }

    private boolean matchParentNodeType(Node file) throws Exception {
        return file.getParent().isNodeType("exo:cssFolder");
    }

    private boolean matchPortalCSSFolder(SessionProvider sessionProvider, Node file) throws Exception {
        Node portal = this.findPortalNode(sessionProvider, file);
        if (portal == null) {
            return false;
        }
        WebSchemaConfigService schemaConfigService = this.getService(WebSchemaConfigService.class);
        PortalFolderSchemaHandler schemaHandler = schemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
        Node cssFolder = schemaHandler.getCSSFolder(portal);
        return file.getPath().startsWith(cssFolder.getPath());
    }

    public void onCreateNode(SessionProvider sessionProvider, Node file) throws Exception {
        this.addMixin(file, "exo:cssFile");
        this.addMixin(file, "exo:owneable");
        file.setProperty("exo:presentationType", "exo:cssFile");
        if (this.isInPortalCSSFolder) {
            file.setProperty("exo:sharedCSS", true);
        }
    }

    public void onModifyNode(SessionProvider sessionProvider, Node file) throws Exception {
        if (this.isInPortalCSSFolder) {
            Node portal = this.findPortalNode(sessionProvider, file);
            XSkinService skinService = this.getService(XSkinService.class);
            skinService.updatePortalSkinOnModify(portal, file);
        }
    }

    public void onRemoveNode(SessionProvider sessionProvider, Node file) throws Exception {
        if (this.isInPortalCSSFolder) {
            XSkinService skinService = this.getService(XSkinService.class);
            Node portal = this.findPortalNode(sessionProvider, file);
            skinService.updatePortalSkinOnRemove(portal, file);
        }
    }
}

